/*
 * Decompiled with CFR 0.152.
 */
package io.antmedia.console.rest;

import com.auth0.jwk.Jwk;
import com.auth0.jwk.JwkException;
import com.auth0.jwk.UrlJwkProvider;
import com.auth0.jwt.JWT;
import com.auth0.jwt.JWTVerifier;
import com.auth0.jwt.algorithms.Algorithm;
import com.auth0.jwt.exceptions.JWTVerificationException;
import com.auth0.jwt.interfaces.DecodedJWT;
import io.antmedia.filter.AbstractFilter;
import io.antmedia.settings.ServerSettings;
import java.io.IOException;
import java.security.interfaces.RSAPublicKey;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class JWTServerFilter
extends AbstractFilter {
    private ServerSettings serverSettings;
    public static final String JWT_TOKEN = "Authorization";

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest httpjwtRequest = (HttpServletRequest)request;
        String path = ((HttpServletRequest)request).getRequestURI();
        this.serverSettings = this.getServerSetting();
        if (this.serverSettings != null && !this.serverSettings.isJwtServerControlEnabled() || httpjwtRequest.getHeader(JWT_TOKEN) != null && this.checkJWT(httpjwtRequest.getHeader(JWT_TOKEN))) {
            chain.doFilter(request, response);
            logger.info("Request {} is completed", (Object)path);
        } else {
            HttpServletResponse resp = (HttpServletResponse)response;
            resp.setStatus(403);
        }
    }

    private boolean checkJWT(String jwtString) {
        boolean result = true;
        try {
            logger.info("Checking JWT key ");
            String jwksURL = this.serverSettings.getJwksURL();
            if (jwksURL != null && !jwksURL.isEmpty()) {
                DecodedJWT jwt = JWT.decode((String)jwtString);
                UrlJwkProvider provider = new UrlJwkProvider(jwksURL);
                Jwk jwk = provider.get(jwt.getKeyId());
                Algorithm algorithm = Algorithm.RSA256((RSAPublicKey)((RSAPublicKey)jwk.getPublicKey()), null);
                algorithm.verify(jwt);
            } else {
                Algorithm algorithm = Algorithm.HMAC256((String)this.serverSettings.getJwtServerSecretKey());
                JWTVerifier verifier = JWT.require((Algorithm)algorithm).build();
                verifier.verify(jwtString);
            }
        }
        catch (JWTVerificationException ex) {
            logger.error(ex.toString());
            result = false;
        }
        catch (JwkException e) {
            logger.error(e.toString());
            result = false;
        }
        return result;
    }

    @Override
    public void destroy() {
    }
}

