/*
 * Decompiled with CFR 0.152.
 */
package io.antmedia.datastore.db.types;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import dev.morphia.annotations.Embedded;
import dev.morphia.annotations.Entity;
import dev.morphia.annotations.Field;
import dev.morphia.annotations.Id;
import dev.morphia.annotations.Index;
import dev.morphia.annotations.Indexes;
import io.antmedia.datastore.db.types.SubscriberStats;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import org.bson.types.ObjectId;

@Entity(value="subscriber")
@Indexes(value={@Index(fields={@Field(value="subscriberId")}), @Index(fields={@Field(value="streamId")})})
@ApiModel(value="Subscriber", description="The time based token subscriber class")
public class Subscriber {
    @JsonIgnore
    public static final String PLAY_TYPE = "play";
    @JsonIgnore
    public static final String PUBLISH_TYPE = "publish";
    @JsonIgnore
    @Id
    @ApiModelProperty(value="the db id of the subscriber")
    private ObjectId dbId;
    @ApiModelProperty(value="the subscriber id of the subscriber")
    private String subscriberId;
    @JsonIgnore
    @ApiModelProperty(value="the stream id of the token")
    private String streamId;
    @ApiModelProperty(value="stats for this subscriber")
    @Embedded
    private SubscriberStats stats = new SubscriberStats();
    @JsonProperty(access=JsonProperty.Access.WRITE_ONLY)
    @ApiModelProperty(value="secret code of the subscriber")
    private String b32Secret;
    @ApiModelProperty(value="is subscriber connected")
    private boolean connected;
    @ApiModelProperty(value=" type of subscriber (play or publish)")
    private String type = "play";

    public String getSubscriberId() {
        return this.subscriberId;
    }

    public void setSubscriberId(String subscriberId) {
        this.subscriberId = subscriberId;
    }

    public String getStreamId() {
        return this.streamId;
    }

    public void setStreamId(String streamId) {
        this.streamId = streamId;
    }

    public String getB32Secret() {
        return this.b32Secret;
    }

    public void setB32Secret(String b32Secret) {
        this.b32Secret = b32Secret;
    }

    public SubscriberStats getStats() {
        return this.stats;
    }

    @JsonIgnore
    public void setStats(SubscriberStats stats) {
        if (stats != null) {
            stats.setStreamId(this.streamId);
            stats.setSubscriberId(this.subscriberId);
        }
        this.stats = stats;
    }

    @JsonIgnore
    public String getSubscriberKey() {
        return Subscriber.getDBKey(this.streamId, this.subscriberId);
    }

    public static String getDBKey(String streamId, String subscriberId) {
        return streamId + "-" + subscriberId;
    }

    public boolean isConnected() {
        return this.connected;
    }

    public void setConnected(boolean connected) {
        this.connected = connected;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        if (PLAY_TYPE.equals(type) || PUBLISH_TYPE.equals(type)) {
            this.type = type;
        }
    }
}

