/*
 * Decompiled with CFR 0.152.
 */
package io.antmedia.muxer;

import io.antmedia.AppSettings;
import io.antmedia.muxer.IAntMediaStreamHandler;
import io.antmedia.muxer.Muxer;
import io.antmedia.storage.StorageClient;
import io.vertx.core.Vertx;
import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.bytedeco.ffmpeg.avcodec.AVBSFContext;
import org.bytedeco.ffmpeg.avcodec.AVCodec;
import org.bytedeco.ffmpeg.avcodec.AVCodecContext;
import org.bytedeco.ffmpeg.avcodec.AVCodecParameters;
import org.bytedeco.ffmpeg.avcodec.AVPacket;
import org.bytedeco.ffmpeg.avformat.AVFormatContext;
import org.bytedeco.ffmpeg.avformat.AVIOContext;
import org.bytedeco.ffmpeg.avformat.AVStream;
import org.bytedeco.ffmpeg.avutil.AVDictionary;
import org.bytedeco.ffmpeg.avutil.AVRational;
import org.bytedeco.ffmpeg.global.avcodec;
import org.bytedeco.ffmpeg.global.avformat;
import org.bytedeco.ffmpeg.global.avutil;
import org.bytedeco.javacpp.BytePointer;
import org.red5.server.api.IContext;
import org.red5.server.api.scope.IScope;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;

public abstract class RecordMuxer
extends Muxer {
    protected static Logger logger = LoggerFactory.getLogger(RecordMuxer.class);
    protected File fileTmp;
    protected StorageClient storageClient = null;
    protected String streamId;
    protected int videoIndex;
    protected int audioIndex;
    protected int resolution;
    protected AVBSFContext bsfExtractdataContext = null;
    protected AVPacket tmpPacket;
    protected Map<Integer, AVRational> codecTimeBaseMap = new HashMap<Integer, AVRational>();
    protected AVPacket videoPkt;
    protected int rotation;
    private String subFolder = null;
    protected boolean firstKeyFrameReceivedChecked = false;
    protected boolean dynamic = false;
    private String s3FolderPath = "streams";
    protected int[] SUPPORTED_CODECS;
    private long firstAudioDts = -1L;
    private long firstVideoDts = -1L;

    public RecordMuxer(StorageClient storageClient, Vertx vertx, String s3FolderPath) {
        super(vertx);
        this.storageClient = storageClient;
        this.s3FolderPath = s3FolderPath;
    }

    public boolean isCodecSupported(int codecId) {
        for (int i = 0; i < this.SUPPORTED_CODECS.length; ++i) {
            if (codecId != this.SUPPORTED_CODECS[i]) continue;
            return true;
        }
        return false;
    }

    @Override
    public void init(IScope scope, String name, int resolutionHeight, String subFolder) {
        super.init(scope, name, resolutionHeight, false, subFolder);
        this.streamId = name;
        this.resolution = resolutionHeight;
        this.subFolder = subFolder;
        this.tmpPacket = avcodec.av_packet_alloc();
        avcodec.av_init_packet((AVPacket)this.tmpPacket);
        this.videoPkt = avcodec.av_packet_alloc();
        avcodec.av_init_packet((AVPacket)this.videoPkt);
    }

    @Override
    public synchronized boolean addVideoStream(int width, int height, AVRational timebase, int codecId, int streamIndex, boolean isAVC, AVCodecParameters codecpar) {
        boolean result = false;
        AVFormatContext outputContext = this.getOutputFormatContext();
        if (outputContext != null && this.isCodecSupported(codecId)) {
            this.registeredStreamIndexList.add(streamIndex);
            AVStream outStream = avformat.avformat_new_stream((AVFormatContext)outputContext, null);
            outStream.codecpar().width(width);
            outStream.codecpar().height(height);
            outStream.codecpar().codec_id(codecId);
            outStream.codecpar().codec_type(0);
            outStream.codecpar().format(0);
            outStream.codecpar().codec_tag(0);
            AVRational timeBase = new AVRational();
            timeBase.num(1).den(1000);
            this.codecTimeBaseMap.put(streamIndex, timeBase);
            result = true;
        }
        return result;
    }

    @Override
    public boolean addAudioStream(int sampleRate, int channelLayout, int codecId, int streamIndex) {
        boolean result = false;
        AVFormatContext outputContext = this.getOutputFormatContext();
        if (outputContext != null && this.isCodecSupported(codecId)) {
            this.registeredStreamIndexList.add(streamIndex);
            AVStream outStream = avformat.avformat_new_stream((AVFormatContext)outputContext, null);
            outStream.codecpar().sample_rate(sampleRate);
            outStream.codecpar().channel_layout((long)channelLayout);
            outStream.codecpar().codec_id(codecId);
            outStream.codecpar().codec_type(1);
            outStream.codecpar().codec_tag(0);
            AVRational timeBase = new AVRational();
            timeBase.num(1).den(sampleRate);
            this.codecTimeBaseMap.put(streamIndex, timeBase);
            result = true;
        }
        return result;
    }

    @Override
    public synchronized boolean addStream(AVCodec codec, AVCodecContext codecContext, int streamIndex) {
        AVCodecParameters codecParameter = new AVCodecParameters();
        int ret = avcodec.avcodec_parameters_from_context((AVCodecParameters)codecParameter, (AVCodecContext)codecContext);
        if (ret < 0) {
            logger.error("Cannot get codec parameters for {}", (Object)this.streamId);
        }
        return this.addStream(codecParameter, codecContext.time_base(), streamIndex);
    }

    @Override
    public synchronized boolean addStream(AVCodecParameters codecParameters, AVRational timebase, int streamIndex) {
        boolean result = false;
        AVFormatContext outputContext = this.getOutputFormatContext();
        if (outputContext != null && this.isCodecSupported(codecParameters.codec_id()) && (codecParameters.codec_type() == 1 || codecParameters.codec_type() == 0)) {
            AVStream outStream = this.avNewStream(outputContext);
            avcodec.avcodec_parameters_copy((AVCodecParameters)outStream.codecpar(), (AVCodecParameters)codecParameters);
            outStream.time_base(timebase);
            this.codecTimeBaseMap.put(outStream.index(), timebase);
            this.registeredStreamIndexList.add(streamIndex);
            outStream.codecpar().codec_tag(0);
            if (codecParameters.codec_type() == 1) {
                this.audioIndex = outStream.index();
            } else {
                this.videoIndex = outStream.index();
            }
            result = true;
        } else if (codecParameters.codec_type() == 2) {
            result = true;
        } else {
            logger.warn("Stream is not added for muxing to {} for stream:{}", (Object)this.getFileName(), (Object)this.streamId);
        }
        return result;
    }

    public AVFormatContext getOutputFormatContext() {
        if (this.outputFormatContext == null) {
            this.outputFormatContext = new AVFormatContext(null);
            this.fileTmp = new File(this.file.getAbsolutePath() + ".tmp_extension");
            int ret = avformat.avformat_alloc_output_context2((AVFormatContext)this.outputFormatContext, null, (String)this.format, (String)this.fileTmp.getAbsolutePath());
            if (ret < 0) {
                logger.info("Could not create output context for {}", (Object)this.streamId);
                return null;
            }
        }
        return this.outputFormatContext;
    }

    public AVStream avNewStream(AVFormatContext context) {
        return avformat.avformat_new_stream((AVFormatContext)context, null);
    }

    protected boolean prepareAudioOutStream(AVStream inStream, AVStream outStream) {
        int ret = avcodec.avcodec_parameters_copy((AVCodecParameters)outStream.codecpar(), (AVCodecParameters)inStream.codecpar());
        if (ret < 0) {
            logger.info("Cannot get codec parameters for {}", (Object)this.streamId);
            return false;
        }
        return true;
    }

    @Override
    public synchronized boolean prepareIO() {
        AVFormatContext context = this.getOutputFormatContext();
        if (context == null || context.pb() != null) {
            return false;
        }
        AVIOContext pb = new AVIOContext(null);
        int ret = avformat.avio_open((AVIOContext)pb, (String)this.fileTmp.getAbsolutePath(), (int)2);
        if (ret < 0) {
            logger.warn("Could not open output file: {} parent file exists:{}", (Object)this.fileTmp.getAbsolutePath(), (Object)this.fileTmp.getParentFile().exists());
            return false;
        }
        context.pb(pb);
        AVDictionary optionsDictionary = null;
        if (!this.options.isEmpty()) {
            optionsDictionary = new AVDictionary();
            Set keySet = this.options.keySet();
            for (String key : keySet) {
                avutil.av_dict_set((AVDictionary)optionsDictionary, (String)key, (String)((String)this.options.get(key)), (int)0);
            }
        }
        if ((ret = avformat.avformat_write_header((AVFormatContext)context, optionsDictionary)) < 0) {
            logger.warn("could not write header for {}", (Object)this.fileTmp.getName());
            this.clearResource();
            return false;
        }
        if (optionsDictionary != null) {
            avutil.av_dict_free((AVDictionary)optionsDictionary);
        }
        this.isRunning.set(true);
        return true;
    }

    @Override
    public synchronized void writeVideoBuffer(ByteBuffer encodedVideoFrame, long dts, int frameRotation, int streamIndex, boolean isKeyFrame, long firstFrameTimeStamp, long pts) {
        if (!this.isRunning.get()) {
            if (this.time2log % 100 == 0) {
                logger.warn("Not writing VideoBuffer for {} because Is running:{}", (Object)this.streamId, (Object)this.isRunning.get());
                this.time2log = 0;
            }
            ++this.time2log;
            return;
        }
        this.rotation = frameRotation;
        this.videoPkt.stream_index(streamIndex);
        this.videoPkt.pts(pts);
        this.videoPkt.dts(dts);
        if (isKeyFrame) {
            this.videoPkt.flags(this.videoPkt.flags() | 1);
        }
        encodedVideoFrame.rewind();
        this.videoPkt.data(new BytePointer(encodedVideoFrame));
        this.videoPkt.size(encodedVideoFrame.limit());
        this.videoPkt.position(0L);
        this.writePacket(this.videoPkt, (AVCodecContext)null);
        avcodec.av_packet_unref((AVPacket)this.videoPkt);
    }

    @Override
    public synchronized void writeAudioBuffer(ByteBuffer audioFrame, int streamIndex, long timestamp) {
        if (!this.isRunning.get()) {
            if (this.time2log % 100 == 0) {
                logger.warn("Not writing AudioBuffer for {} because Is running:{}", (Object)this.streamId, (Object)this.isRunning.get());
                this.time2log = 0;
            }
            ++this.time2log;
            return;
        }
        this.audioPkt.stream_index(streamIndex);
        this.audioPkt.pts(timestamp);
        this.audioPkt.dts(timestamp);
        audioFrame.rewind();
        this.audioPkt.flags(this.audioPkt.flags() | 1);
        this.audioPkt.data(new BytePointer(audioFrame));
        this.audioPkt.size(audioFrame.limit());
        this.audioPkt.position(0L);
        this.writePacket(this.audioPkt, (AVCodecContext)null);
        avcodec.av_packet_unref((AVPacket)this.audioPkt);
    }

    @Override
    public synchronized void writeTrailer() {
        if (!this.isRunning.get() || this.outputFormatContext == null || this.outputFormatContext.pb() == null) {
            logger.warn("OutputFormatContext is not initialized or it is freed for file {}", this.fileTmp != null ? this.fileTmp.getName() : null);
            return;
        }
        logger.info("Record Muxer writing trailer for stream: {}", (Object)this.streamId);
        this.isRunning.set(false);
        avformat.av_write_trailer((AVFormatContext)this.outputFormatContext);
        logger.info("Clearing resources for stream: {}", (Object)this.streamId);
        this.clearResource();
        logger.info("Resources are cleaned for stream: {}", (Object)this.streamId);
        this.isRecording = false;
        this.vertx.executeBlocking(l -> {
            try {
                AppSettings appSettings;
                String absolutePath = this.fileTmp.getAbsolutePath();
                String origFileName = absolutePath.replace(".tmp_extension", "");
                File f = new File(origFileName);
                logger.info("File: {} exist: {}", (Object)this.fileTmp.getAbsolutePath(), (Object)this.fileTmp.exists());
                this.finalizeRecordFile(f);
                IContext context = this.scope.getContext();
                ApplicationContext appCtx = context.getApplicationContext();
                Object bean = appCtx.getBean("web.handler");
                if (bean instanceof IAntMediaStreamHandler) {
                    ((IAntMediaStreamHandler)bean).muxingFinished(this.streamId, f, RecordMuxer.getDurationInMs(f, this.streamId), this.resolution);
                }
                if ((appSettings = (AppSettings)appCtx.getBean("app.settings")).isS3RecordingEnabled()) {
                    logger.info("Storage client is available saving {} to storage", (Object)f.getName());
                    RecordMuxer.saveToStorage(this.s3FolderPath + File.separator + (String)(this.subFolder != null ? this.subFolder + File.separator : ""), f, this.getFile().getName(), this.storageClient);
                }
            }
            catch (Exception e) {
                logger.error(e.getMessage());
            }
            l.complete();
        }, null);
    }

    public static void saveToStorage(String prefix, File fileToUpload, String fileName, StorageClient storageClient) {
        if (storageClient.fileExist(prefix + fileName)) {
            String tmpName = fileName;
            int i = 0;
            while (storageClient.fileExist(prefix + (fileName = tmpName.replace(".", "_" + ++i + ".")))) {
            }
        }
        storageClient.save(prefix + fileName, fileToUpload);
    }

    protected void finalizeRecordFile(File file) throws IOException {
        Files.move(this.fileTmp.toPath(), file.toPath(), new CopyOption[0]);
        logger.info("{} is ready", (Object)file.getName());
    }

    public static long getDurationInMs(File f, String streamId) {
        AVFormatContext inputFormatContext = avformat.avformat_alloc_context();
        if (avformat.avformat_open_input((AVFormatContext)inputFormatContext, (String)f.getAbsolutePath(), null, (AVDictionary)null) < 0) {
            logger.info("cannot open input context for duration for stream: {}", (Object)streamId);
            avformat.avformat_close_input((AVFormatContext)inputFormatContext);
            return -1L;
        }
        int ret = avformat.avformat_find_stream_info((AVFormatContext)inputFormatContext, (AVDictionary)null);
        if (ret < 0) {
            logger.info("Could not find stream information for stream: {}", (Object)streamId);
            avformat.avformat_close_input((AVFormatContext)inputFormatContext);
            return -1L;
        }
        long durationInMS = -1L;
        if (inputFormatContext.duration() != avutil.AV_NOPTS_VALUE) {
            durationInMS = inputFormatContext.duration() / 1000L;
        }
        avformat.avformat_close_input((AVFormatContext)inputFormatContext);
        return durationInMS;
    }

    protected void clearResource() {
        if (this.tmpPacket != null) {
            avcodec.av_packet_free((AVPacket)this.tmpPacket);
            this.tmpPacket = null;
        }
        if (this.videoPkt != null) {
            avcodec.av_packet_free((AVPacket)this.videoPkt);
            this.videoPkt = null;
        }
        if (this.audioPkt != null) {
            avcodec.av_packet_free((AVPacket)this.audioPkt);
            this.audioPkt = null;
        }
        if (this.bsfExtractdataContext != null) {
            avcodec.av_bsf_free((AVBSFContext)this.bsfExtractdataContext);
            this.bsfExtractdataContext = null;
        }
        if ((this.outputFormatContext.flags() & 1) == 0) {
            avformat.avio_closep((AVIOContext)this.outputFormatContext.pb());
        }
        avformat.avformat_free_context((AVFormatContext)this.outputFormatContext);
        this.outputFormatContext = null;
    }

    @Override
    public synchronized void writePacket(AVPacket pkt, AVStream stream) {
        int streamIndex;
        if (!this.firstKeyFrameReceivedChecked && stream.codecpar().codec_type() == 0) {
            int keyFrame = pkt.flags() & 1;
            if (keyFrame == 1) {
                this.firstKeyFrameReceivedChecked = true;
                logger.warn("First key frame received for stream: {}", (Object)this.streamId);
            } else {
                logger.warn("First video packet is not key frame. It will drop for direct muxing. Stream {}", (Object)this.streamId);
                return;
            }
        }
        if (!this.isRunning.get() || !this.registeredStreamIndexList.contains(pkt.stream_index())) {
            if (this.time2log % 100 == 0) {
                logger.warn("Not writing packet1 for {} - Is running:{} or stream index({}) is registered: {}", new Object[]{this.streamId, this.isRunning.get(), pkt.stream_index(), this.registeredStreamIndexList.contains(pkt.stream_index())});
                this.time2log = 0;
            }
            ++this.time2log;
            return;
        }
        if (stream.codecpar().codec_type() == 0) {
            streamIndex = this.videoIndex;
        } else if (stream.codecpar().codec_type() == 1) {
            streamIndex = this.audioIndex;
        } else {
            logger.error("Undefined codec type for stream: {} ", (Object)this.streamId);
            return;
        }
        AVStream outStream = this.outputFormatContext.streams(streamIndex);
        int index = pkt.stream_index();
        pkt.stream_index(streamIndex);
        this.writePacket(pkt, stream.time_base(), outStream.time_base(), outStream.codecpar().codec_type());
        pkt.stream_index(index);
    }

    @Override
    public synchronized void writePacket(AVPacket pkt, AVCodecContext codecContext) {
        if (!this.isRunning.get() || !this.registeredStreamIndexList.contains(pkt.stream_index())) {
            if (this.time2log % 100 == 0) {
                logger.warn("Not writing packet for {} - Is running:{} or stream index({}) is registered: {}", new Object[]{this.streamId, this.isRunning.get(), pkt.stream_index(), this.registeredStreamIndexList.contains(pkt.stream_index())});
                this.time2log = 0;
            }
            ++this.time2log;
            return;
        }
        AVStream outStream = this.outputFormatContext.streams(pkt.stream_index());
        AVRational codecTimebase = this.codecTimeBaseMap.get(pkt.stream_index());
        int codecType = outStream.codecpar().codec_type();
        if (!this.firstKeyFrameReceivedChecked && codecType == 0) {
            int keyFrame = pkt.flags() & 1;
            if (keyFrame == 1) {
                this.firstKeyFrameReceivedChecked = true;
                logger.warn("First key frame received for stream: {}", (Object)this.streamId);
            } else {
                logger.info("First video packet is not key frame. It will drop for direct muxing. Stream {}", (Object)this.streamId);
                return;
            }
        }
        this.writePacket(pkt, codecTimebase, outStream.time_base(), codecType);
    }

    private void writePacket(AVPacket pkt, AVRational inputTimebase, AVRational outputTimebase, int codecType) {
        AVFormatContext context = this.getOutputFormatContext();
        if (context == null || context.pb() == null) {
            logger.warn("output context.pb field is null for stream: {}", (Object)this.streamId);
            return;
        }
        long pts = pkt.pts();
        long dts = pkt.dts();
        long duration = pkt.duration();
        long pos = pkt.pos();
        pkt.duration(avutil.av_rescale_q((long)pkt.duration(), (AVRational)inputTimebase, (AVRational)outputTimebase));
        pkt.pos(-1L);
        if (codecType == 1) {
            if (this.firstAudioDts == -1L) {
                this.firstAudioDts = pkt.dts();
            }
            pkt.pts(avutil.av_rescale_q_rnd((long)(pkt.pts() - this.firstAudioDts), (AVRational)inputTimebase, (AVRational)outputTimebase, (int)8197));
            pkt.dts(avutil.av_rescale_q_rnd((long)(pkt.dts() - this.firstAudioDts), (AVRational)inputTimebase, (AVRational)outputTimebase, (int)8197));
            int ret = avcodec.av_packet_ref((AVPacket)this.tmpPacket, (AVPacket)pkt);
            if (ret < 0) {
                logger.error("Cannot copy audio packet for {}", (Object)this.streamId);
                return;
            }
            this.writeAudioFrame(this.tmpPacket, inputTimebase, outputTimebase, context, dts);
            avcodec.av_packet_unref((AVPacket)this.tmpPacket);
        } else if (codecType == 0) {
            if (this.firstVideoDts == -1L) {
                this.firstVideoDts = pkt.dts();
            }
            pkt.pts(avutil.av_rescale_q_rnd((long)(pkt.pts() - this.firstVideoDts), (AVRational)inputTimebase, (AVRational)outputTimebase, (int)8197));
            pkt.dts(avutil.av_rescale_q_rnd((long)(pkt.dts() - this.firstVideoDts), (AVRational)inputTimebase, (AVRational)outputTimebase, (int)8197));
            int ret = avcodec.av_packet_ref((AVPacket)this.tmpPacket, (AVPacket)pkt);
            if (ret < 0) {
                logger.error("Cannot copy video packet for {}", (Object)this.streamId);
                return;
            }
            this.writeVideoFrame(this.tmpPacket, context);
            avcodec.av_packet_unref((AVPacket)this.tmpPacket);
        } else {
            int ret = avformat.av_write_frame((AVFormatContext)context, (AVPacket)pkt);
            if (ret < 0 && logger.isWarnEnabled()) {
                if (this.time2log % 100 == 0) {
                    byte[] data = new byte[64];
                    avutil.av_strerror((int)ret, (byte[])data, (long)data.length);
                    logger.warn("cannot frame to muxer({}) not audio and not video. Error is {} ", (Object)this.file.getName(), (Object)new String(data, 0, data.length));
                    this.time2log = 0;
                }
                ++this.time2log;
            }
        }
        pkt.pts(pts);
        pkt.dts(dts);
        pkt.duration(duration);
        pkt.pos(pos);
    }

    protected void writeVideoFrame(AVPacket pkt, AVFormatContext context) {
        if (this.bsfExtractdataContext != null) {
            int ret = avcodec.av_bsf_send_packet((AVBSFContext)this.bsfExtractdataContext, (AVPacket)this.tmpPacket);
            if (ret < 0) {
                return;
            }
            while (avcodec.av_bsf_receive_packet((AVBSFContext)this.bsfExtractdataContext, (AVPacket)this.tmpPacket) == 0) {
                ret = avformat.av_write_frame((AVFormatContext)context, (AVPacket)this.tmpPacket);
                if (ret >= 0 || !logger.isWarnEnabled()) continue;
                byte[] data = new byte[64];
                avutil.av_strerror((int)ret, (byte[])data, (long)data.length);
                logger.warn("cannot write video frame to muxer({}) av_bsf_receive_packet. Error is {} ", (Object)this.file.getName(), (Object)new String(data, 0, data.length));
            }
        } else {
            int ret = avformat.av_write_frame((AVFormatContext)context, (AVPacket)pkt);
            if (ret < 0 && logger.isWarnEnabled()) {
                byte[] data = new byte[64];
                avutil.av_strerror((int)ret, (byte[])data, (long)data.length);
                logger.warn("cannot write video frame to muxer({}). Pts: {} dts:{}  Error is {} ", new Object[]{this.file.getName(), pkt.pts(), pkt.dts(), new String(data, 0, data.length)});
            }
        }
    }

    protected void writeAudioFrame(AVPacket pkt, AVRational inputTimebase, AVRational outputTimebase, AVFormatContext context, long dts) {
        int ret = avformat.av_write_frame((AVFormatContext)context, (AVPacket)this.tmpPacket);
        if (ret < 0 && logger.isInfoEnabled()) {
            byte[] data = new byte[64];
            avutil.av_strerror((int)ret, (byte[])data, (long)data.length);
            logger.info("cannot write audio frame to muxer({}). Error is {} ", (Object)this.file.getName(), (Object)new String(data, 0, data.length));
        }
    }

    public void setDynamic(boolean dynamic) {
        this.dynamic = dynamic;
    }

    public boolean isDynamic() {
        return this.dynamic;
    }
}

