/*
 * Decompiled with CFR 0.152.
 */
package io.antmedia.muxer.parser;

import io.antmedia.muxer.parser.Parser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AACConfigParser
extends Parser {
    protected static Logger logger = LoggerFactory.getLogger(AACConfigParser.class);
    protected static final int SAMPLE_RATE_96000 = 0;
    protected static final int SAMPLE_RATE_88200 = 1;
    protected static final int SAMPLE_RATE_64000 = 2;
    protected static final int SAMPLE_RATE_48000 = 3;
    protected static final int SAMPLE_RATE_44100 = 4;
    protected static final int SAMPLE_RATE_32000 = 5;
    protected static final int SAMPLE_RATE_24000 = 6;
    protected static final int SAMPLE_RATE_22050 = 7;
    protected static final int SAMPLE_RATE_16000 = 8;
    protected static final int SAMPLE_RATE_12000 = 9;
    protected static final int SAMPLE_RATE_11025 = 10;
    protected static final int SAMPLE_RATE_8000 = 11;
    protected static final int SAMPLE_RATE_7350 = 12;
    private int sampleRate;
    private int channelCount;
    private AudioObjectTypes objectType;
    private int frameSize;

    public AACConfigParser(byte[] data, int offset) {
        super(data, offset);
    }

    @Override
    protected void parse() {
        int objectTypeIndex = this.readBits(5);
        if (objectTypeIndex == AudioObjectTypes.NULL.value) {
            this.objectType = AudioObjectTypes.NULL;
        } else if (objectTypeIndex == AudioObjectTypes.AAC_MAIN.value) {
            this.objectType = AudioObjectTypes.AAC_MAIN;
        } else if (objectTypeIndex == AudioObjectTypes.AAC_LC.value) {
            this.objectType = AudioObjectTypes.AAC_LC;
        } else if (objectTypeIndex == AudioObjectTypes.AAC_SSR.value) {
            this.objectType = AudioObjectTypes.AAC_SSR;
        } else if (objectTypeIndex == AudioObjectTypes.AAC_LTP.value) {
            this.objectType = AudioObjectTypes.AAC_LTP;
        } else if (objectTypeIndex == AudioObjectTypes.SBR.value) {
            this.objectType = AudioObjectTypes.SBR;
        } else if (objectTypeIndex == AudioObjectTypes.AAC_SCALABLE.value) {
            this.objectType = AudioObjectTypes.AAC_SCALABLE;
        } else {
            logger.error("Cannot determine the AAC object type:{} ", (Object)objectTypeIndex);
        }
        logger.info("AAC object type:{} ", (Object)this.objectType);
        int sampleRateIndex = this.readBits(4);
        if (sampleRateIndex == 0) {
            this.sampleRate = 96000;
        } else if (sampleRateIndex == 1) {
            this.sampleRate = 88200;
        } else if (sampleRateIndex == 2) {
            this.sampleRate = 64000;
        } else if (sampleRateIndex == 3) {
            this.sampleRate = 48000;
        } else if (sampleRateIndex == 4) {
            this.sampleRate = 44100;
        } else if (sampleRateIndex == 5) {
            this.sampleRate = 32000;
        } else if (sampleRateIndex == 6) {
            this.sampleRate = 24000;
        } else if (sampleRateIndex == 7) {
            this.sampleRate = 22050;
        } else if (sampleRateIndex == 8) {
            this.sampleRate = 16000;
        } else if (sampleRateIndex == 9) {
            this.sampleRate = 12000;
        } else if (sampleRateIndex == 10) {
            this.sampleRate = 11025;
        } else if (sampleRateIndex == 11) {
            this.sampleRate = 8000;
        } else if (sampleRateIndex == 12) {
            this.sampleRate = 7350;
        } else {
            logger.error("Cannot determine the AAC Sample Rate:{} ", (Object)sampleRateIndex);
        }
        logger.info("AAC Sample rate:{} ", (Object)this.sampleRate);
        this.channelCount = this.readBits(4);
        if (this.channelCount == 0 || this.channelCount > 7) {
            logger.error("Cannot determine the channel count: {}", (Object)this.channelCount);
        }
        if (this.channelCount == 7) {
            this.channelCount = 8;
        }
        this.frameSize = this.readBit() == 0 ? 1024 : 960;
    }

    public AudioObjectTypes getObjectType() {
        return this.objectType;
    }

    public int getChannelCount() {
        return this.channelCount;
    }

    public int getSampleRate() {
        return this.sampleRate;
    }

    public int getFrameSize() {
        return this.frameSize;
    }

    public static enum AudioObjectTypes {
        NULL(0),
        AAC_MAIN(1),
        AAC_LC(2),
        AAC_SSR(3),
        AAC_LTP(4),
        SBR(5),
        AAC_SCALABLE(6);

        public final int value;

        private AudioObjectTypes(int value) {
            this.value = value;
        }
    }
}

