/*
 * Decompiled with CFR 0.152.
 */
package io.antmedia.plugin;

import io.antmedia.plugin.api.IPacketListener;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import org.bytedeco.ffmpeg.avcodec.AVPacket;
import org.bytedeco.ffmpeg.global.avcodec;
import org.bytedeco.javacpp.BytePointer;

public class PacketFeeder {
    private ArrayList<IPacketListener> listeners = new ArrayList();
    private String streamId;
    private AVPacket videoPkt;
    private AVPacket audioPkt;

    public PacketFeeder(String streamId) {
        this.streamId = streamId;
        this.audioPkt = avcodec.av_packet_alloc();
        avcodec.av_init_packet((AVPacket)this.audioPkt);
        this.videoPkt = avcodec.av_packet_alloc();
        avcodec.av_init_packet((AVPacket)this.videoPkt);
    }

    public void writeTrailer() {
        for (IPacketListener listener : this.listeners) {
            listener.writeTrailer();
        }
    }

    public void writePacket(AVPacket packet) {
        for (IPacketListener listener : this.listeners) {
            listener.onPacket(this.streamId, packet);
        }
    }

    public void addListener(IPacketListener listener) {
        this.listeners.add(listener);
    }

    public void removeListener(IPacketListener listener) {
        this.listeners.remove(listener);
    }

    public void writeAudioBuffer(ByteBuffer audioFrame, int streamIndex, long timestamp) {
        if (!this.listeners.isEmpty()) {
            this.audioPkt.stream_index(streamIndex);
            this.audioPkt.pts(timestamp);
            this.audioPkt.dts(timestamp);
            audioFrame.rewind();
            this.audioPkt.flags(this.audioPkt.flags() | 1);
            this.audioPkt.data(new BytePointer(audioFrame));
            this.audioPkt.size(audioFrame.limit());
            this.audioPkt.position(0L);
            this.writePacket(this.audioPkt);
            avcodec.av_packet_unref((AVPacket)this.audioPkt);
        }
    }

    public void writeVideoBuffer(ByteBuffer encodedVideoFrame, long dts, int frameRotation, int streamIndex, boolean isKeyFrame, long firstFrameTimeStamp, long pts) {
        if (!this.listeners.isEmpty()) {
            this.videoPkt.stream_index(streamIndex);
            this.videoPkt.pts(pts);
            this.videoPkt.dts(dts);
            encodedVideoFrame.rewind();
            if (isKeyFrame) {
                this.videoPkt.flags(this.videoPkt.flags() | 1);
            }
            BytePointer bytePointer = new BytePointer(encodedVideoFrame);
            this.videoPkt.data(bytePointer);
            this.videoPkt.size(encodedVideoFrame.limit());
            this.videoPkt.position(0L);
            this.writePacket(this.videoPkt);
            avcodec.av_packet_unref((AVPacket)this.videoPkt);
        }
    }
}

