/*
 * Decompiled with CFR 0.152.
 */
package io.antmedia.rest;

import io.antmedia.AntMediaApplicationAdapter;
import io.antmedia.AppSettings;
import io.antmedia.IApplicationAdaptorFactory;
import io.antmedia.RecordType;
import io.antmedia.datastore.db.DataStore;
import io.antmedia.datastore.db.DataStoreFactory;
import io.antmedia.datastore.db.types.Broadcast;
import io.antmedia.datastore.db.types.ConferenceRoom;
import io.antmedia.datastore.db.types.Endpoint;
import io.antmedia.datastore.db.types.SocialEndpointChannel;
import io.antmedia.datastore.db.types.SocialEndpointCredentials;
import io.antmedia.datastore.db.types.TensorFlowObject;
import io.antmedia.datastore.db.types.Token;
import io.antmedia.datastore.db.types.VoD;
import io.antmedia.ipcamera.OnvifCamera;
import io.antmedia.ipcamera.onvifdiscovery.OnvifDiscovery;
import io.antmedia.muxer.Mp4Muxer;
import io.antmedia.muxer.MuxAdaptor;
import io.antmedia.muxer.Muxer;
import io.antmedia.muxer.RecordMuxer;
import io.antmedia.rest.WebRTCClientStats;
import io.antmedia.rest.model.Interaction;
import io.antmedia.rest.model.Result;
import io.antmedia.rest.model.Version;
import io.antmedia.security.ITokenService;
import io.antmedia.settings.ServerSettings;
import io.antmedia.social.LiveComment;
import io.antmedia.social.endpoint.PeriscopeEndpoint;
import io.antmedia.social.endpoint.VideoServiceEndpoint;
import io.antmedia.statistic.HlsViewerStats;
import io.antmedia.statistic.IStatsCollector;
import io.antmedia.storage.StorageClient;
import io.antmedia.streamsource.StreamFetcher;
import io.antmedia.webrtc.api.IWebRTCAdaptor;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.URL;
import java.nio.file.Files;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.jar.Manifest;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import javax.servlet.ServletContext;
import javax.ws.rs.core.Context;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.RandomStringUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.red5.server.api.scope.IBroadcastScope;
import org.red5.server.api.scope.IScope;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;

public abstract class RestServiceBase {
    public static final String BUILD_NUMBER = "Build-Number";
    public static final String ENTERPRISE_EDITION = "Enterprise Edition";
    public static final String COMMUNITY_EDITION = "Community Edition";
    public static final int MAX_ITEM_IN_ONE_LIST = 50;
    public static final int ERROR_SOCIAL_ENDPOINT_UNDEFINED_CLIENT_ID = -1;
    public static final int ERROR_SOCIAL_ENDPOINT_UNDEFINED_ENDPOINT = -2;
    public static final int ERROR_SOCIAL_ENDPOINT_EXCEPTION_IN_ASKING_AUTHPARAMS = -3;
    public static final int RECORD_ENABLE = 1;
    public static final int RECORD_DISABLE = -1;
    public static final int RECORD_NO_SET = 0;
    public static final int HIGH_CPU_ERROR = -3;
    public static final int FETCHER_NOT_STARTED_ERROR = -4;
    public static final int INVALID_STREAM_NAME_ERROR = -5;
    public static final String HTTP = "http://";
    public static final String RTSP = "rtsp://";
    public static final String ENDPOINT_GENERIC = "generic";
    protected static Logger logger = LoggerFactory.getLogger(RestServiceBase.class);
    private ProcessBuilderFactory processBuilderFactory = null;
    public static final String IPV4_REGEX = "(([0-1]?[0-9]{1,2}\\.)|(2[0-4][0-9]\\.)|(25[0-5]\\.)){3}(([0-1]?[0-9]{1,2})|(2[0-4][0-9])|(25[0-5]))";
    public static final String LOOPBACK_REGEX = "^localhost$|^127(?:\\.[0-9]+){0,2}\\.[0-9]+$|^(?:0*\\:)*?:?0*1$";
    private static final String REPLACE_CHARS = "[\n|\r|\t]";
    @Context
    protected ServletContext servletContext;
    protected DataStoreFactory dataStoreFactory;
    private DataStore dbStore;
    protected ApplicationContext appCtx;
    protected IScope scope;
    protected AntMediaApplicationAdapter appInstance;
    private AppSettings appSettings;
    private ServerSettings serverSettings;

    protected boolean addSocialEndpoints(Broadcast broadcast, String socialEndpointIds) {
        boolean success = false;
        Map<String, VideoServiceEndpoint> endPointServiceList = this.getApplication().getVideoServiceEndpoints();
        String[] endpointIds = socialEndpointIds.split(",");
        if (endPointServiceList != null) {
            for (String endpointId : endpointIds) {
                VideoServiceEndpoint videoServiceEndpoint = endPointServiceList.get(endpointId);
                if (videoServiceEndpoint != null) {
                    success = this.addSocialEndpoint(broadcast, videoServiceEndpoint);
                    continue;
                }
                String id = endpointId != null ? endpointId.replaceAll(REPLACE_CHARS, "_") : null;
                logger.warn("{} endpoint does not exist in this app.", (Object)id);
            }
        } else {
            logger.warn("endPointServiceList is null");
        }
        return success;
    }

    protected boolean addSocialEndpoint(Broadcast broadcast, VideoServiceEndpoint socialEndpoint) {
        try {
            Endpoint endpoint = socialEndpoint.createBroadcast(broadcast.getName(), broadcast.getDescription(), broadcast.getStreamId(), broadcast.isIs360(), broadcast.isPublicStream(), 2160, true);
            return this.getDataStore().addEndpoint(broadcast.getStreamId(), endpoint);
        }
        catch (Exception e) {
            logger.error(ExceptionUtils.getStackTrace((Throwable)e));
            return false;
        }
    }

    public void setAppCtx(ApplicationContext appCtx) {
        this.appCtx = appCtx;
    }

    @Nullable
    public ApplicationContext getAppContext() {
        if (this.servletContext != null) {
            this.appCtx = (ApplicationContext)this.servletContext.getAttribute(WebApplicationContext.ROOT_WEB_APPLICATION_CONTEXT_ATTRIBUTE);
        }
        return this.appCtx;
    }

    public void setApplication(AntMediaApplicationAdapter app) {
        this.appInstance = app;
    }

    public AntMediaApplicationAdapter getApplication() {
        ApplicationContext appContext;
        if (this.appInstance == null && (appContext = this.getAppContext()) != null) {
            this.appInstance = ((IApplicationAdaptorFactory)appContext.getBean("web.handler")).getAppAdaptor();
        }
        return this.appInstance;
    }

    public IScope getScope() {
        if (this.scope == null) {
            this.scope = this.getApplication().getScope();
        }
        return this.scope;
    }

    public void setScope(IScope scope) {
        this.scope = scope;
    }

    public DataStore getDataStore() {
        if (this.dbStore == null) {
            this.dbStore = this.getDataStoreFactory().getDataStore();
        }
        return this.dbStore;
    }

    public void setDataStore(DataStore dataStore) {
        this.dbStore = dataStore;
    }

    public DataStoreFactory getDataStoreFactory() {
        if (this.dataStoreFactory == null) {
            WebApplicationContext ctxt = WebApplicationContextUtils.getWebApplicationContext((ServletContext)this.servletContext);
            this.dataStoreFactory = (DataStoreFactory)ctxt.getBean("dataStoreFactory");
        }
        return this.dataStoreFactory;
    }

    public void setDataStoreFactory(DataStoreFactory dataStoreFactory) {
        this.dataStoreFactory = dataStoreFactory;
    }

    protected Map<String, VideoServiceEndpoint> getEndpointList() {
        return this.getApplication().getVideoServiceEndpoints();
    }

    public Broadcast createBroadcastWithStreamID(Broadcast broadcast) {
        return RestServiceBase.saveBroadcast(broadcast, "created", this.getScope().getName(), this.getDataStore(), this.getAppSettings().getListenerHookURL(), this.getServerSettings(), 0L);
    }

    public static Broadcast saveBroadcast(Broadcast broadcast, String status, String scopeName, DataStore dataStore, String settingsListenerHookURL, ServerSettings serverSettings, long absoluteStartTimeMs) {
        String fqdn;
        if (broadcast == null) {
            broadcast = new Broadcast();
        }
        broadcast.setStatus(status);
        broadcast.setDate(System.currentTimeMillis());
        String listenerHookURL = broadcast.getListenerHookURL();
        if ((listenerHookURL == null || listenerHookURL.isEmpty()) && settingsListenerHookURL != null && !settingsListenerHookURL.isEmpty()) {
            broadcast.setListenerHookURL(settingsListenerHookURL);
        }
        if ((fqdn = serverSettings.getServerName()) == null || fqdn.length() == 0) {
            fqdn = serverSettings.getHostAddress();
        }
        broadcast.setOriginAdress(serverSettings.getHostAddress());
        broadcast.setAbsoluteStartTimeMs(absoluteStartTimeMs);
        RestServiceBase.removeEmptyPlayListItems(broadcast);
        if (fqdn != null && fqdn.length() >= 0) {
            broadcast.setRtmpURL("rtmp://" + fqdn + "/" + scopeName + "/");
        }
        dataStore.save(broadcast);
        return broadcast;
    }

    public AppSettings getAppSettings() {
        ApplicationContext appContext;
        if (this.appSettings == null && (appContext = this.getAppContext()) != null) {
            this.appSettings = (AppSettings)appContext.getBean("app.settings");
        }
        return this.appSettings;
    }

    public void setAppSettings(AppSettings appSettings) {
        this.appSettings = appSettings;
    }

    public ServerSettings getServerSettings() {
        ApplicationContext appContext;
        if (this.serverSettings == null && (appContext = this.getAppContext()) != null) {
            this.serverSettings = (ServerSettings)appContext.getBean("ant.media.server.settings");
        }
        return this.serverSettings;
    }

    public void setServerSettings(ServerSettings serverSettings) {
        this.serverSettings = serverSettings;
    }

    protected Result deleteBroadcast(String id) {
        Result result = new Result(false);
        boolean stopResult = false;
        Broadcast broadcast = null;
        if (id != null && (broadcast = this.getDataStore().get(id)) != null) {
            boolean isCluster = this.getAppContext().containsBean("tomcat.cluster");
            if (isCluster && !broadcast.getOriginAdress().equals(this.getServerSettings().getHostAddress()) && broadcast.getStatus().equals("broadcasting")) {
                logger.error("Please send a Delete Broadcast request to the {} node or Delete Broadcast in a stopped broadcast.", (Object)broadcast.getOriginAdress());
                result.setSuccess(false);
            } else {
                stopResult = this.stopBroadcastInternal(broadcast);
                result.setSuccess(this.getDataStore().delete(id));
                if (result.isSuccess()) {
                    if (stopResult) {
                        logger.info("broadcast {} is deleted and stopped successfully", (Object)broadcast.getStreamId());
                        result.setMessage("broadcast is deleted and stopped successfully");
                    } else {
                        logger.info("broadcast {} is deleted but could not stopped", (Object)broadcast);
                        result.setMessage("broadcast is deleted but could not stopped ");
                    }
                }
            }
        } else {
            logger.warn("Broadcast delete operation not successfull because broadcast is not found in db for stream id:{}", id != null ? id.replaceAll(REPLACE_CHARS, "_") : null);
        }
        return result;
    }

    protected boolean stopBroadcastInternal(Broadcast broadcast) {
        boolean result = false;
        if (broadcast != null) {
            result = this.getApplication().stopStreaming(broadcast).isSuccess();
            if (result) {
                logger.info("broadcast is stopped streamId: {}", (Object)broadcast.getStreamId());
            } else {
                logger.error("No active broadcast found with id {}, so could not stopped", (Object)broadcast.getStreamId());
            }
        }
        return result;
    }

    protected Broadcast lookupBroadcast(String id) {
        Broadcast broadcast = null;
        try {
            broadcast = this.getDataStore().get(id);
        }
        catch (Exception e) {
            logger.error(ExceptionUtils.getStackTrace((Throwable)e));
        }
        return broadcast;
    }

    protected ConferenceRoom lookupConference(String id) {
        ConferenceRoom room = null;
        try {
            room = this.getDataStore().getConferenceRoom(id);
        }
        catch (Exception e) {
            logger.error(ExceptionUtils.getStackTrace((Throwable)e));
        }
        return room;
    }

    protected Result updateBroadcast(String streamId, Broadcast broadcast, String socialNetworksToPublish) {
        RestServiceBase.removeEmptyPlayListItems(broadcast);
        boolean result = this.getDataStore().updateBroadcastFields(streamId, broadcast);
        StringBuilder message = new StringBuilder();
        int errorId = 0;
        if (result) {
            Broadcast fetchedBroadcast = this.getDataStore().get(streamId);
            this.getDataStore().removeAllEndpoints(fetchedBroadcast.getStreamId());
            if (socialNetworksToPublish != null && socialNetworksToPublish.length() > 0) {
                String[] socialNetworks;
                for (String networkName : socialNetworks = socialNetworksToPublish.split(",")) {
                    Result addSocialEndpoint = this.addSocialEndpoint(streamId, networkName);
                    if (addSocialEndpoint.isSuccess()) continue;
                    result = false;
                    message.append(networkName).append(" ");
                    errorId = -1;
                    break;
                }
            }
        }
        if (message.length() > 0) {
            message.append(" endpoint cannot be added");
        }
        return new Result(result, message.toString(), errorId);
    }

    private static void removeEmptyPlayListItems(Broadcast broadcast) {
        List<Broadcast.PlayListItem> playListItemList = broadcast.getPlayListItemList();
        if (playListItemList != null) {
            Iterator<Broadcast.PlayListItem> iterator = playListItemList.iterator();
            while (iterator.hasNext()) {
                Broadcast.PlayListItem listItem = iterator.next();
                if (listItem.getStreamUrl() != null && !listItem.getStreamUrl().isEmpty()) continue;
                iterator.remove();
            }
        }
    }

    protected Result updateStreamSource(String streamId, Broadcast broadcast, String socialNetworksToPublish) {
        boolean result = false;
        boolean resultStopStreaming = false;
        logger.debug("update cam info for stream {}", (Object)broadcast.getStreamId());
        if (this.checkStreamUrl(broadcast.getStreamUrl())) {
            Broadcast broadcastInDB = this.getDataStore().get(streamId);
            if (broadcastInDB != null) {
                String rtspURL;
                resultStopStreaming = this.checkStopStreaming(broadcastInDB);
                this.waitStopStreaming(broadcastInDB, resultStopStreaming);
                if ("ipCamera".equals(broadcast.getType()) && (rtspURL = this.connectToCamera(broadcast).getMessage()) != null) {
                    String authparam = broadcast.getUsername() + ":" + broadcast.getPassword() + "@";
                    String rtspURLWithAuth = RTSP + authparam + rtspURL.substring(RTSP.length());
                    logger.info("new RTSP URL: {}", (Object)rtspURLWithAuth);
                    broadcast.setStreamUrl(rtspURLWithAuth);
                }
                if (result = this.getDataStore().updateBroadcastFields(streamId, broadcast)) {
                    Broadcast fetchedBroadcast = this.getDataStore().get(streamId);
                    this.getDataStore().removeAllEndpoints(fetchedBroadcast.getStreamId());
                    if (socialNetworksToPublish != null && socialNetworksToPublish.length() > 0) {
                        this.addSocialEndpoints(fetchedBroadcast, socialNetworksToPublish);
                    }
                    this.getApplication().startStreaming(fetchedBroadcast);
                }
            } else {
                streamId = streamId.replaceAll(REPLACE_CHARS, "_");
                logger.info("Broadcast with stream id: {} is null", (Object)streamId);
            }
        }
        return new Result(result);
    }

    public boolean checkStopStreaming(Broadcast broadcast) {
        if ("broadcasting".equals(broadcast.getStatus())) {
            return this.getApplication().stopStreaming(broadcast).isSuccess();
        }
        if (this.getApplication().getStreamFetcherManager().isStreamRunning(broadcast.getStreamId())) {
            return this.getApplication().stopStreaming(broadcast).isSuccess();
        }
        return true;
    }

    public boolean waitStopStreaming(Broadcast broadcast, Boolean resultStopStreaming) {
        int i = 0;
        int waitPeriod = 250;
        while (!"finished".equals(this.getDataStore().get(broadcast.getStreamId()).getStatus()) && !resultStopStreaming.equals(true)) {
            try {
                logger.info("Waiting for stop broadcast: {} Total wait time: {}ms", (Object)broadcast.getStreamId(), (Object)(++i * waitPeriod));
                Thread.sleep(waitPeriod);
                if (i <= 20) continue;
                logger.warn("{} Stream ID broadcast could not be stopped. Total wait time: {}ms", (Object)broadcast.getStreamId(), (Object)(i * waitPeriod));
                break;
            }
            catch (InterruptedException e) {
                logger.error(e.getMessage());
                Thread.currentThread().interrupt();
            }
        }
        return true;
    }

    protected Result addSocialEndpoint(String id, String endpointServiceId) {
        Broadcast broadcast = this.lookupBroadcast(id);
        boolean success = false;
        Object message = "";
        if (broadcast != null && !(success = this.addSocialEndpoints(broadcast, endpointServiceId))) {
            message = endpointServiceId + " endpoint can not be added to " + id;
        }
        return new Result(success, (String)message);
    }

    protected Result revokeSocialNetwork(String endpointId) {
        Map<String, VideoServiceEndpoint> endPointServiceMap = this.getEndpointList();
        String message = null;
        boolean result = false;
        if (endPointServiceMap != null) {
            VideoServiceEndpoint videoServiceEndpoint = endPointServiceMap.get(endpointId);
            if (videoServiceEndpoint != null) {
                videoServiceEndpoint.resetCredentials();
                endPointServiceMap.remove(endpointId);
                result = true;
            } else {
                message = "Service with the name specified is not found in this app";
            }
        } else {
            message = "No endpoint is defined for this app";
        }
        return new Result(result, message);
    }

    @Deprecated
    public Result addEndpoint(String id, String rtmpUrl) {
        boolean success = false;
        String message = null;
        try {
            if (RestServiceBase.validateStreamURL(rtmpUrl)) {
                Endpoint endpoint = new Endpoint();
                endpoint.setRtmpUrl(rtmpUrl);
                endpoint.setType(ENDPOINT_GENERIC);
                success = this.getDataStore().addEndpoint(id, endpoint);
            }
        }
        catch (Exception e) {
            logger.error(ExceptionUtils.getStackTrace((Throwable)e));
        }
        return new Result(success, message);
    }

    public Result addEndpoint(String id, Endpoint endpoint) {
        boolean success = false;
        String message = null;
        endpoint.setType(ENDPOINT_GENERIC);
        Object endpointServiceId = endpoint.getEndpointServiceId();
        if (endpointServiceId == null || ((String)endpointServiceId).isEmpty()) {
            endpointServiceId = "custom" + RandomStringUtils.randomAlphabetic((int)6);
        }
        endpoint.setEndpointServiceId((String)endpointServiceId);
        try {
            if (RestServiceBase.validateStreamURL(endpoint.getRtmpUrl())) {
                success = this.getDataStore().addEndpoint(id, endpoint);
            }
        }
        catch (Exception e) {
            logger.error(ExceptionUtils.getStackTrace((Throwable)e));
        }
        return new Result(success, (String)endpointServiceId, message);
    }

    @Deprecated
    public Result removeEndpoint(String id, String rtmpUrl) {
        Endpoint endpoint = new Endpoint();
        endpoint.setRtmpUrl(rtmpUrl);
        endpoint.setType(ENDPOINT_GENERIC);
        boolean removed = this.getDataStore().removeEndpoint(id, endpoint, true);
        return new Result(removed);
    }

    public Result removeRTMPEndpoint(String id, String endpointServiceId) {
        Endpoint endpoint = new Endpoint();
        endpoint.setType(ENDPOINT_GENERIC);
        endpoint.setEndpointServiceId(endpointServiceId);
        boolean removed = this.getDataStore().removeEndpoint(id, endpoint, false);
        return new Result(removed);
    }

    public boolean isInSameNodeInCluster(String originAddress) {
        boolean isCluster = this.getAppContext().containsBean("tomcat.cluster");
        return !isCluster || originAddress.equals(this.getServerSettings().getHostAddress());
    }

    public Result processRTMPEndpoint(Result result, String streamId, String originAddress, String rtmpUrl, boolean addEndpoint, int resolution) {
        boolean resultBoolean = false;
        if (this.isInSameNodeInCluster(originAddress)) {
            resultBoolean = addEndpoint ? this.getMuxAdaptor(streamId).startRtmpStreaming(rtmpUrl, resolution) : this.getMuxAdaptor(streamId).stopRtmpStreaming(rtmpUrl, resolution);
            result.setSuccess(resultBoolean);
        } else {
            logger.error("Please send a RTMP Endpoint request to the {} node or {} RTMP Endpoint in a stopped broadcast.", (Object)originAddress, (Object)(addEndpoint ? "add" : "remove"));
            result.setSuccess(false);
        }
        return result;
    }

    public Result importLiveStreams2Stalker() {
        String stalkerDBServer = this.getAppSettings().getStalkerDBServer();
        String stalkerDBUsername = this.getAppSettings().getStalkerDBUsername();
        String stalkerDBPassword = this.getAppSettings().getStalkerDBPassword();
        boolean result = false;
        String message = "";
        int errorId = -1;
        if (stalkerDBServer != null && stalkerDBServer.length() > 0 && stalkerDBUsername != null && stalkerDBUsername.length() > 0 && stalkerDBPassword != null && stalkerDBPassword.length() > 0) {
            long broadcastCount = this.getDataStore().getBroadcastCount();
            int pageCount = (int)broadcastCount / 50 + (broadcastCount % 50L != 0L ? 1 : 0);
            ArrayList<Broadcast> broadcastList = new ArrayList<Broadcast>();
            for (int i = 0; i < pageCount; ++i) {
                broadcastList.addAll(this.getDataStore().getBroadcastList(i * 50, 50, null, null, null, null));
            }
            StringBuilder insertQueryString = new StringBuilder();
            insertQueryString.append("DELETE FROM stalker_db.ch_links;");
            insertQueryString.append("DELETE FROM stalker_db.itv;");
            String fqdn = this.getServerSettings().getServerName();
            if (fqdn == null || fqdn.length() == 0) {
                fqdn = this.getServerSettings().getHostAddress();
            }
            int number = 1;
            for (Broadcast broadcast : broadcastList) {
                String cmd = "ffmpeg http://" + fqdn + ":" + this.serverSettings.getDefaultHttpPort() + "/" + this.getScope().getName() + "/streams/" + broadcast.getStreamId() + ".m3u8";
                insertQueryString.append("INSERT INTO stalker_db.itv(name, number, tv_genre_id, base_ch, cmd, languages) VALUES ('" + broadcast.getName() + "' , " + number + ", 2, 1, '" + cmd + "', '');");
                insertQueryString.append("SET @last_id=LAST_INSERT_ID();INSERT INTO stalker_db.ch_links(ch_id, url) VALUES(@last_id, '" + cmd + "');");
                ++number;
            }
            result = this.runStalkerImportQuery(insertQueryString.toString(), stalkerDBServer, stalkerDBUsername, stalkerDBPassword);
        } else {
            message = "Portal DB info is missing";
            errorId = 404;
        }
        return new Result(result, message, errorId);
    }

    private boolean runStalkerImportQuery(String query, String stalkerDBServer, String stalkerDBUsername, String stalkerDBPassword) {
        boolean result = false;
        try {
            Process p = this.getProcess(query, stalkerDBServer, stalkerDBUsername, stalkerDBPassword);
            if (p != null) {
                int exitWith;
                InputStream is = p.getInputStream();
                if (is != null) {
                    int length;
                    byte[] data = new byte[1024];
                    while ((length = is.read(data, 0, data.length)) != -1) {
                        if (!logger.isInfoEnabled()) continue;
                        logger.info(new String(data, 0, length));
                    }
                }
                if ((exitWith = p.waitFor()) == 0) {
                    result = true;
                }
            }
        }
        catch (IOException e) {
            logger.error(ExceptionUtils.getStackTrace((Throwable)e));
        }
        catch (InterruptedException e) {
            logger.error(ExceptionUtils.getStackTrace((Throwable)e));
            Thread.currentThread().interrupt();
        }
        return result;
    }

    private Process getProcess(String query, String stalkerDBServer, String stalkerDBUsername, String stalkerDBPassword) {
        Process process = null;
        String mysqlClientPath = this.getAppSettings().getMySqlClientPath();
        if (this.processBuilderFactory != null) {
            process = this.processBuilderFactory.make(mysqlClientPath, "-h", stalkerDBServer, "-u", stalkerDBUsername, "-p" + stalkerDBPassword, "-e", query);
        } else {
            try {
                process = new ProcessBuilder(mysqlClientPath, "-h", stalkerDBServer, "-u", stalkerDBUsername, "-p" + stalkerDBPassword, "-e", query).redirectErrorStream(true).start();
            }
            catch (IOException e) {
                logger.error(ExceptionUtils.getStackTrace((Throwable)e));
            }
        }
        return process;
    }

    public Result importVoDsToStalker() {
        String stalkerDBServer = this.getAppSettings().getStalkerDBServer();
        String stalkerDBUsername = this.getAppSettings().getStalkerDBUsername();
        String stalkerDBPassword = this.getAppSettings().getStalkerDBPassword();
        boolean result = false;
        String message = "";
        int errorId = -1;
        if (stalkerDBServer != null && stalkerDBUsername != null && stalkerDBPassword != null) {
            String vodFolderPath = this.getAppSettings().getVodFolder();
            if (vodFolderPath != null && !vodFolderPath.isEmpty()) {
                long totalVodNumber = this.getDataStore().getTotalVodNumber();
                int pageCount = (int)totalVodNumber / 50 + (totalVodNumber % 50L != 0L ? 1 : 0);
                ArrayList<VoD> vodList = new ArrayList<VoD>();
                for (int i = 0; i < pageCount; ++i) {
                    vodList.addAll(this.getDataStore().getVodList(i * 50, 50, null, null, null, null));
                }
                String fqdn = this.getServerSettings().getServerName();
                if (fqdn == null || fqdn.length() == 0) {
                    fqdn = this.getServerSettings().getHostAddress();
                }
                StringBuilder insertQueryString = new StringBuilder();
                insertQueryString.append("DELETE FROM stalker_db.video_series_files;");
                insertQueryString.append("DELETE FROM stalker_db.video;");
                for (VoD vod : vodList) {
                    if (!vod.getType().equals("userVod")) continue;
                    insertQueryString.append("INSERT INTO stalker_db.video(name, o_name, protocol, category_id, cat_genre_id_1, status, cost, path, accessed) values('" + vod.getVodName() + "', '" + vod.getVodName() + "', '', 1, 1, 1, 0, '" + vod.getVodName() + "', 1);");
                    File vodFolder = new File(vodFolderPath);
                    int lastIndexOf = vod.getFilePath().lastIndexOf(vodFolder.getName());
                    String filePath = vod.getFilePath().substring(lastIndexOf);
                    String cmd = "ffmpeg http://" + fqdn + ":" + this.serverSettings.getDefaultHttpPort() + "/" + this.getScope().getName() + "/streams/" + filePath;
                    insertQueryString.append("SET @last_id=LAST_INSERT_ID();");
                    insertQueryString.append("INSERT INTO stalker_db.video_series_files(video_id, file_type, protocol, url, languages, quality, date_add, date_modify, status, accessed)VALUES(@last_id, 'video', 'custom', '" + cmd + "', 'a:1:{i:0;s:2:\"en\";}', 5, NOW(), NOW(), 1, 1);");
                }
                result = this.runStalkerImportQuery(insertQueryString.toString(), stalkerDBServer, stalkerDBUsername, stalkerDBPassword);
            } else {
                message = "No VoD folder specified";
                errorId = 500;
            }
        } else {
            message = "Portal DB info is missing";
            errorId = 404;
        }
        return new Result(result, message, errorId);
    }

    protected ProcessBuilderFactory getProcessBuilderFactory() {
        return this.processBuilderFactory;
    }

    public void setProcessBuilderFactory(ProcessBuilderFactory processBuilderFactory) {
        this.processBuilderFactory = processBuilderFactory;
    }

    public IWebRTCAdaptor getWebRTCAdaptor() {
        Object webRTCAdaptorBean;
        IWebRTCAdaptor adaptor = null;
        ApplicationContext appContext = this.getAppContext();
        if (appContext != null && appContext.containsBean("webrtc.adaptor") && (webRTCAdaptorBean = appContext.getBean("webrtc.adaptor")) != null) {
            adaptor = (IWebRTCAdaptor)webRTCAdaptorBean;
        }
        return adaptor;
    }

    public Result addIPCamera(Broadcast stream, String socialEndpointIds) {
        Result connResult = new Result(false);
        if (RestServiceBase.validateStreamURL(stream.getIpAddr())) {
            logger.info("type {}", (Object)stream.getType());
            connResult = this.connectToCamera(stream);
            if (connResult.isSuccess()) {
                String authparam = stream.getUsername() + ":" + stream.getPassword() + "@";
                String rtspURLWithAuth = RTSP + authparam + connResult.getMessage().substring(RTSP.length());
                logger.info("rtsp url with auth: {}", (Object)rtspURLWithAuth);
                stream.setStreamUrl(rtspURLWithAuth);
                Date currentDate = new Date();
                long unixTime = currentDate.getTime();
                stream.setDate(unixTime);
                Broadcast savedBroadcast = RestServiceBase.saveBroadcast(stream, "created", this.getScope().getName(), this.getDataStore(), this.getAppSettings().getListenerHookURL(), this.getServerSettings(), 0L);
                if (socialEndpointIds != null && socialEndpointIds.length() > 0) {
                    this.addSocialEndpoints(savedBroadcast, socialEndpointIds);
                }
                if (!(connResult = this.getApplication().startStreaming(savedBroadcast)).isSuccess()) {
                    this.getDataStore().delete(savedBroadcast.getStreamId());
                }
            }
        } else {
            connResult.setMessage("IP camera addr is not valid: " + stream.getIpAddr());
        }
        return connResult;
    }

    public Result addStreamSource(Broadcast stream, String socialEndpointIds) {
        Result result = new Result(false);
        IStatsCollector monitor = (IStatsCollector)this.getAppContext().getBean("statsCollector");
        if (monitor.enoughResource()) {
            if (stream.getType().equals("ipCamera")) {
                result = this.addIPCamera(stream, socialEndpointIds);
            } else if (stream.getType().equals("streamSource")) {
                result = this.addSource(stream, socialEndpointIds);
            } else {
                result.setMessage("Auto start query needs an IP camera or stream source.");
            }
        } else {
            logger.error("Stream Fetcher can not be created due to high cpu load/limit: {}/{} ram free/minfree:{}/{}", new Object[]{monitor.getCpuLoad(), monitor.getCpuLimit(), monitor.getFreeRam(), monitor.getMinFreeRamSize()});
            result.setMessage("Resource usage is high");
            result.setErrorId(-3);
        }
        return result;
    }

    public Result connectToCamera(Broadcast stream) {
        Result result = new Result(false);
        OnvifCamera onvif = new OnvifCamera();
        int connResult = onvif.connect(stream.getIpAddr(), stream.getUsername(), stream.getPassword());
        if (connResult == 0) {
            result.setSuccess(true);
            result.setMessage(onvif.getRTSPStreamURI());
        } else {
            result.setMessage("Could not connect to " + stream.getIpAddr() + " result:" + connResult);
            result.setErrorId(connResult);
            logger.info("Cannot connect to ip camera:{}", (Object)stream.getIpAddr());
        }
        return result;
    }

    protected static boolean validateStreamURL(String url) {
        boolean ipAddrControl = false;
        String[] ipAddrParts = null;
        String serverAddr = url;
        if (url != null && (url.startsWith(HTTP) || url.startsWith("https://") || url.startsWith("rtmp://") || url.startsWith("rtmps://") || url.startsWith(RTSP))) {
            ipAddrParts = url.split("//");
            serverAddr = ipAddrParts[1];
            ipAddrControl = true;
        }
        if (serverAddr != null) {
            if (serverAddr.contains("@")) {
                ipAddrParts = serverAddr.split("@");
                serverAddr = ipAddrParts[1];
            }
            if (serverAddr.contains(":")) {
                ipAddrParts = serverAddr.split(":");
                serverAddr = ipAddrParts[0];
            }
            if (serverAddr.contains("/")) {
                ipAddrParts = serverAddr.split("/");
                serverAddr = ipAddrParts[0];
            }
            if (logger.isInfoEnabled()) {
                logger.info("IP: {}", (Object)serverAddr.replaceAll(REPLACE_CHARS, "_"));
            }
            if (serverAddr.split("\\.").length == 4 && RestServiceBase.validateIPaddress(serverAddr)) {
                ipAddrControl = true;
            }
        }
        return ipAddrControl;
    }

    protected static boolean validateIPaddress(String ipaddress) {
        Pattern patternIP4 = Pattern.compile(IPV4_REGEX);
        Pattern patternLoopBack = Pattern.compile(LOOPBACK_REGEX);
        return patternIP4.matcher(ipaddress).matches() || patternLoopBack.matcher(ipaddress).matches();
    }

    public boolean checkStreamUrl(String url) {
        boolean streamUrlControl = false;
        String[] ipAddrParts = null;
        String ipAddr = null;
        if (url != null && (url.startsWith(HTTP) || url.startsWith("https://") || url.startsWith("rtmp://") || url.startsWith("rtmps://") || url.startsWith(RTSP) || url.startsWith("udp://") || url.startsWith("srt://"))) {
            streamUrlControl = true;
            ipAddrParts = url.split("//");
            ipAddr = ipAddrParts[1];
            if (ipAddr.contains("@")) {
                ipAddrParts = ipAddr.split("@");
                ipAddr = ipAddrParts[1];
            }
            if (ipAddr.contains(":")) {
                ipAddrParts = ipAddr.split(":");
                ipAddr = ipAddrParts[0];
            }
            if (ipAddr.contains("/")) {
                ipAddrParts = ipAddr.split("/");
                ipAddr = ipAddrParts[0];
            }
        }
        return streamUrlControl;
    }

    protected Result addSource(Broadcast stream, String socialEndpointIds) {
        Result result = new Result(false);
        if (this.checkStreamUrl(stream.getStreamUrl())) {
            Date currentDate = new Date();
            long unixTime = currentDate.getTime();
            stream.setDate(unixTime);
            Broadcast savedBroadcast = RestServiceBase.saveBroadcast(stream, "created", this.getScope().getName(), this.getDataStore(), this.getAppSettings().getListenerHookURL(), this.getServerSettings(), 0L);
            if (socialEndpointIds != null && socialEndpointIds.length() > 0) {
                this.addSocialEndpoints(savedBroadcast, socialEndpointIds);
            }
            if (!(result = this.getApplication().startStreaming(savedBroadcast)).isSuccess()) {
                this.getDataStore().delete(savedBroadcast.getStreamId());
                result.setErrorId(-4);
            }
        }
        return result;
    }

    protected List<WebRTCClientStats> getWebRTCClientStatsList(int offset, int size, String streamId) {
        ArrayList<WebRTCClientStats> list = new ArrayList<WebRTCClientStats>();
        IWebRTCAdaptor webRTCAdaptor = this.getWebRTCAdaptor();
        if (webRTCAdaptor != null) {
            List<WebRTCClientStats> webRTCClientStats = webRTCAdaptor.getWebRTCClientStats(streamId);
            int t = 0;
            int itemCount = 0;
            if (size > 50) {
                size = 50;
            }
            if (offset < 0) {
                offset = 0;
            }
            for (WebRTCClientStats webrtcClientStat : webRTCClientStats) {
                if (t < offset) {
                    ++t;
                    continue;
                }
                list.add(webrtcClientStat);
                if (++itemCount < size) continue;
                return list;
            }
        }
        return list;
    }

    protected Result deleteVoD(String id) {
        boolean success = false;
        String message = "";
        ApplicationContext appContext = this.getAppContext();
        if (appContext != null) {
            File videoFile = null;
            VoD voD = this.getDataStore().getVoD(id);
            if (voD != null) {
                try {
                    String filePath = String.format("webapps/%s/%s", this.getScope().getName(), voD.getFilePath());
                    videoFile = new File(filePath);
                    boolean result = Files.deleteIfExists(videoFile.toPath());
                    if (!result) {
                        logger.warn("File is not deleted because it does not exist {}", (Object)videoFile.getAbsolutePath());
                    }
                    if (success = this.getDataStore().deleteVod(id)) {
                        message = "vod deleted";
                    }
                    String fileName = videoFile.getName();
                    String[] splitFileName = StringUtils.split((String)fileName, (String)".");
                    File previewFile = Muxer.getPreviewFile(this.getScope(), splitFileName[0], ".png");
                    Files.deleteIfExists(previewFile.toPath());
                    StorageClient storageClient = (StorageClient)appContext.getBean("app.storageClient");
                    storageClient.delete(this.getAppSettings().getS3StreamsFolderPath() + File.separator + splitFileName[0] + ".mp4");
                    storageClient.delete(this.getAppSettings().getS3PreviewsFolderPath() + File.separator + splitFileName[0] + ".png");
                }
                catch (Exception e) {
                    logger.error(ExceptionUtils.getStackTrace((Throwable)e));
                }
            }
        }
        return new Result(success, message);
    }

    protected String getStreamsDirectory(String appScopeName) {
        return String.format("%s/webapps/%s/%s", System.getProperty("red5.root"), appScopeName, "streams");
    }

    protected Result uploadVoDFile(String fileName, InputStream inputStream) {
        String id;
        String message;
        boolean success;
        block11: {
            success = false;
            message = "";
            id = null;
            String appScopeName = this.getScope().getName();
            String fileExtension = FilenameUtils.getExtension((String)fileName);
            try {
                if ("mp4".equalsIgnoreCase(fileExtension) || "webm".equalsIgnoreCase(fileExtension) || "mov".equalsIgnoreCase(fileExtension) || "avi".equalsIgnoreCase(fileExtension)) {
                    File streamsDirectory = new File(this.getStreamsDirectory(appScopeName));
                    if (!streamsDirectory.exists()) {
                        streamsDirectory.mkdirs();
                    }
                    String vodId = RandomStringUtils.randomNumeric((int)24);
                    File savedFile = new File(String.format("%s/webapps/%s/%s", System.getProperty("red5.root"), appScopeName, "streams/" + vodId + "." + fileExtension));
                    int read = 0;
                    byte[] bytes = new byte[2048];
                    try (FileOutputStream outpuStream = new FileOutputStream(savedFile);){
                        while ((read = inputStream.read(bytes)) != -1) {
                            ((OutputStream)outpuStream).write(bytes, 0, read);
                        }
                        outpuStream.flush();
                        long fileSize = savedFile.length();
                        long unixTime = System.currentTimeMillis();
                        String path = savedFile.getPath();
                        String relativePath = AntMediaApplicationAdapter.getRelativePath(path);
                        VoD newVod = new VoD(fileName, "file", relativePath, fileName, unixTime, RecordMuxer.getDurationInMs(savedFile, fileName), fileSize, "uploadedVod", vodId);
                        id = this.getDataStore().addVod(newVod);
                        if (id != null) {
                            success = true;
                            message = id;
                        }
                        break block11;
                    }
                }
                message = "notMp4File";
            }
            catch (IOException iox) {
                logger.error(iox.getMessage());
            }
        }
        return new Result(success, id, message);
    }

    protected Result synchUserVodList() {
        boolean result = false;
        int errorId = -1;
        String message = "";
        String vodFolder = this.getAppSettings().getVodFolder();
        logger.info("synch user vod list vod folder is {}", (Object)vodFolder);
        if (vodFolder != null && vodFolder.length() > 0) {
            result = this.getApplication().synchUserVoDFolder(null, vodFolder);
        } else {
            errorId = 404;
            message = "no VodD folder defined";
        }
        return new Result(result, message, errorId);
    }

    protected Object getDeviceAuthParameters(String serviceName) {
        int errorId;
        String message;
        block12: {
            String clientId;
            message = null;
            boolean missingClientIdAndSecret = false;
            errorId = -1;
            VideoServiceEndpoint videoServiceEndpoint = null;
            if (serviceName.equals("facebook")) {
                clientId = this.getAppSettings().getFacebookClientId();
                String clientSecret = this.getAppSettings().getFacebookClientSecret();
                videoServiceEndpoint = this.getApplication().getEndpointService("io.antmedia.enterprise.social.endpoint.FacebookEndpoint", null, clientId, clientSecret);
                if (this.isClientIdMissing(videoServiceEndpoint, clientId, clientSecret)) {
                    missingClientIdAndSecret = true;
                }
            } else if (serviceName.equals("youtube")) {
                clientId = this.getAppSettings().getYoutubeClientId();
                String clientSecret = this.getAppSettings().getYoutubeClientSecret();
                videoServiceEndpoint = this.getApplication().getEndpointService("io.antmedia.enterprise.social.endpoint.YoutubeEndpoint", null, clientId, clientSecret);
                if (this.isClientIdMissing(videoServiceEndpoint, clientId, clientSecret)) {
                    missingClientIdAndSecret = true;
                }
            } else if (serviceName.equals("periscope")) {
                clientId = this.getAppSettings().getPeriscopeClientId();
                String clientSecret = this.getAppSettings().getPeriscopeClientSecret();
                videoServiceEndpoint = this.getApplication().getEndpointService(PeriscopeEndpoint.class.getName(), null, clientId, clientSecret);
                if (this.isClientIdMissing(videoServiceEndpoint, clientId, clientSecret)) {
                    missingClientIdAndSecret = true;
                }
            }
            try {
                if (missingClientIdAndSecret) {
                    errorId = -1;
                    message = "Please enter service client id and client secret in app configuration";
                    break block12;
                }
                if (videoServiceEndpoint == null) {
                    errorId = -2;
                    message = "Service with the name specified is not found in this app";
                    break block12;
                }
                VideoServiceEndpoint.DeviceAuthParameters askDeviceAuthParameters = videoServiceEndpoint.askDeviceAuthParameters();
                this.getApplication().startDeviceAuthStatusPolling(videoServiceEndpoint, askDeviceAuthParameters);
                return askDeviceAuthParameters;
            }
            catch (Exception e) {
                errorId = -3;
                message = "Exception in asking parameters";
                logger.error(ExceptionUtils.getStackTrace((Throwable)e));
            }
        }
        return new Result(false, message, errorId);
    }

    protected boolean isClientIdMissing(VideoServiceEndpoint videoServiceEndpoint, String clientId, String clientSecret) {
        boolean result = false;
        if (videoServiceEndpoint != null && (clientId == null || clientSecret == null || clientId.length() == 0 || clientSecret.length() == 0)) {
            result = true;
        }
        return result;
    }

    protected Result checkDeviceAuthStatus(String userCode) {
        Map<String, VideoServiceEndpoint> endPointMap = this.getEndpointList();
        String message = null;
        boolean authenticated = false;
        String endpointId = null;
        if (endPointMap != null) {
            for (VideoServiceEndpoint videoServiceEndpoint : endPointMap.values()) {
                VideoServiceEndpoint.DeviceAuthParameters authParameters = videoServiceEndpoint.getAuthParameters();
                if (authParameters == null || !authParameters.user_code.equals(userCode)) continue;
                authenticated = true;
                endpointId = videoServiceEndpoint.getCredentials().getId();
                break;
            }
        }
        if (!authenticated) {
            List<VideoServiceEndpoint> endPointList = this.getEndpointsHavingErrorList();
            for (VideoServiceEndpoint videoServiceEndpoint : endPointList) {
                VideoServiceEndpoint.DeviceAuthParameters authParameters = videoServiceEndpoint.getAuthParameters();
                if (authParameters == null || !authParameters.user_code.equals(userCode)) continue;
                message = videoServiceEndpoint.getError();
                endPointList.remove(videoServiceEndpoint);
                break;
            }
        }
        return new Result(authenticated, endpointId, message);
    }

    public MuxAdaptor getMuxAdaptor(String streamId) {
        AntMediaApplicationAdapter application = this.getApplication();
        MuxAdaptor selectedMuxAdaptor = null;
        if (application != null) {
            List<MuxAdaptor> muxAdaptors = application.getMuxAdaptors();
            for (MuxAdaptor muxAdaptor : muxAdaptors) {
                if (!streamId.equals(muxAdaptor.getStreamId())) continue;
                selectedMuxAdaptor = muxAdaptor;
                break;
            }
        }
        return selectedMuxAdaptor;
    }

    public boolean addRtmpMuxerToMuxAdaptor(String streamId, String rtmpURL) {
        MuxAdaptor muxAdaptor = this.getMuxAdaptor(streamId);
        boolean result = false;
        if (muxAdaptor != null) {
            // empty if block
        }
        return result;
    }

    @Nullable
    protected Mp4Muxer getMp4Muxer(MuxAdaptor muxAdaptor) {
        Mp4Muxer mp4Muxer = null;
        for (Muxer muxer : muxAdaptor.getMuxerList()) {
            if (!(muxer instanceof Mp4Muxer)) continue;
            mp4Muxer = (Mp4Muxer)muxer;
        }
        return mp4Muxer;
    }

    protected boolean startRecord(String streamId, RecordType recordType) {
        boolean result = false;
        MuxAdaptor muxAdaptor = this.getMuxAdaptor(streamId);
        if (muxAdaptor != null) {
            result = muxAdaptor.startRecording(recordType);
        }
        return result;
    }

    protected boolean stopRecord(String streamId, RecordType recordType) {
        boolean result = false;
        MuxAdaptor muxAdaptor = this.getMuxAdaptor(streamId);
        if (muxAdaptor != null) {
            result = muxAdaptor.stopRecording(recordType);
        }
        return result;
    }

    protected List<VideoServiceEndpoint> getEndpointsHavingErrorList() {
        return this.getApplication().getVideoServiceEndpointsHavingError();
    }

    protected BroadcastStatistics getBroadcastStatistics(String id) {
        int totalRTMPViewer = -1;
        int totalWebRTCViewer = -1;
        int totalHLSViewer = -1;
        if (id != null) {
            IWebRTCAdaptor webRTCAdaptor;
            Broadcast broadcast;
            IBroadcastScope broadcastScope = this.getScope().getBroadcastScope(id);
            if (broadcastScope != null) {
                totalRTMPViewer = broadcastScope.getConsumers().size();
            }
            if ((broadcast = this.getDataStore().get(id)) != null) {
                totalHLSViewer = broadcast.getHlsViewerCount();
            }
            if ((webRTCAdaptor = this.getWebRTCAdaptor()) != null) {
                totalWebRTCViewer = webRTCAdaptor.getNumberOfViewers(id);
            }
        }
        return new BroadcastStatistics(totalRTMPViewer, totalHLSViewer, totalWebRTCViewer);
    }

    protected AppBroadcastStatistics getBroadcastTotalStatistics() {
        IWebRTCAdaptor webRTCAdaptor;
        HlsViewerStats hlsViewerStats;
        int totalWebRTCViewer = -1;
        int totalHLSViewer = -1;
        if (this.getAppContext().containsBean("hls.viewerstats") && (hlsViewerStats = (HlsViewerStats)this.getAppContext().getBean("hls.viewerstats")) != null) {
            totalHLSViewer = hlsViewerStats.getTotalViewerCount();
        }
        if ((webRTCAdaptor = this.getWebRTCAdaptor()) != null) {
            totalWebRTCViewer = webRTCAdaptor.getNumberOfTotalViewers();
        }
        int activeBroadcastCount = (int)this.getDataStore().getActiveBroadcastCount();
        return new AppBroadcastStatistics(-1, totalHLSViewer, totalWebRTCViewer, activeBroadcastCount);
    }

    protected List<SocialEndpointCredentials> getSocialEndpoints(int offset, int size) {
        ArrayList<SocialEndpointCredentials> endPointCredentials = new ArrayList<SocialEndpointCredentials>();
        Map<String, VideoServiceEndpoint> endPointMap = this.getEndpointList();
        if (endPointMap != null) {
            for (VideoServiceEndpoint videoServiceEndpoint : endPointMap.values()) {
                endPointCredentials.add(videoServiceEndpoint.getCredentials());
            }
        }
        return endPointCredentials;
    }

    protected SocialEndpointChannel getSocialNetworkChannel(String endpointId) {
        Map<String, VideoServiceEndpoint> endPointMap = this.getEndpointList();
        VideoServiceEndpoint endPoint = endPointMap.get(endpointId);
        SocialEndpointChannel channel = null;
        if (endPoint != null) {
            channel = endPoint.getChannel();
        }
        return channel;
    }

    protected List<SocialEndpointChannel> getSocialNetworkChannelList(String endpointId, String type) {
        Map<String, VideoServiceEndpoint> endPointMap = this.getEndpointList();
        VideoServiceEndpoint endPoint = endPointMap.get(endpointId);
        List<SocialEndpointChannel> channelList = null;
        if (endPoint != null) {
            channelList = endPoint.getChannelList();
        }
        return channelList;
    }

    protected Result setSocialNetworkChannelList(String endpointId, String type, String channelId) {
        boolean result = false;
        Map<String, VideoServiceEndpoint> endPointMap = this.getEndpointList();
        VideoServiceEndpoint endPoint = endPointMap.get(endpointId);
        if (endPoint != null) {
            result = endPoint.setActiveChannel(type, channelId);
        }
        return new Result(result, null);
    }

    protected Result getCameraErrorById(String streamId) {
        Result result = new Result(false);
        for (StreamFetcher camScheduler : this.getApplication().getStreamFetcherManager().getStreamFetcherList()) {
            if (!camScheduler.getStreamId().equals(streamId)) continue;
            result = camScheduler.getCameraError();
            break;
        }
        return result;
    }

    public Result startStreamSource(String id) {
        Result result = new Result(false);
        Broadcast broadcast = this.getDataStore().get(id);
        if (broadcast != null) {
            if (broadcast.getStreamUrl() != null || "playlist".equals(broadcast.getType())) {
                result = this.getApplication().startStreaming(broadcast);
            } else if ("ipCamera".equals(broadcast.getType())) {
                result = this.connectToCamera(broadcast);
                if (result.isSuccess()) {
                    String authparam = broadcast.getUsername() + ":" + broadcast.getPassword() + "@";
                    String rtspURLWithAuth = RTSP + authparam + result.getMessage().substring(RTSP.length());
                    logger.info("rtsp url with auth: {}", (Object)rtspURLWithAuth);
                    broadcast.setStreamUrl(rtspURLWithAuth);
                    result = this.getApplication().startStreaming(broadcast);
                }
            } else {
                result.setMessage("Stream url is null and it's not an IP camera to get stream url for id:" + id);
            }
        } else {
            result.setMessage("No Stream Exists with id:" + id);
        }
        return result;
    }

    public Result stopStreaming(String id) {
        Result result = new Result(false);
        Broadcast broadcast = this.getDataStore().get(id);
        if (broadcast != null) {
            result = this.getApplication().stopStreaming(broadcast);
        }
        return result;
    }

    protected String[] searchOnvifDevices() {
        String localIP = null;
        String[] list = null;
        Enumeration<NetworkInterface> interfaces = null;
        try {
            interfaces = NetworkInterface.getNetworkInterfaces();
        }
        catch (SocketException socketException) {
            // empty catch block
        }
        if (interfaces != null) {
            while (interfaces.hasMoreElements()) {
                NetworkInterface i = interfaces.nextElement();
                Enumeration<InetAddress> addresses = i.getInetAddresses();
                while (addresses.hasMoreElements() && (localIP == null || localIP.isEmpty())) {
                    InetAddress address = addresses.nextElement();
                    if (address.isLoopbackAddress() || !address.isSiteLocalAddress()) continue;
                    localIP = address.getHostAddress();
                }
            }
            logger.info("IP Address: {} ", (Object)localIP);
        }
        if (localIP != null) {
            String[] ipAddrParts = localIP.split("\\.");
            String ipAd = ipAddrParts[0] + "." + ipAddrParts[1] + "." + ipAddrParts[2] + ".";
            ArrayList<String> addressList = new ArrayList<String>();
            for (int i = 2; i < 255; ++i) {
                addressList.add(ipAd + i);
            }
            List<URL> onvifDevices = OnvifDiscovery.discoverOnvifDevices(true, addressList);
            list = this.getIPArray(onvifDevices);
        }
        return list;
    }

    public String[] getIPArray(List<URL> onvifDevices) {
        String[] list = null;
        if (onvifDevices != null) {
            list = new String[onvifDevices.size()];
            for (int i = 0; i < onvifDevices.size(); ++i) {
                list[i] = StringUtils.substringBetween((String)onvifDevices.get(i).toString(), (String)HTTP, (String)"/");
                logger.info("IP Camera found: {}", (Object)onvifDevices.get(i));
            }
        }
        return list;
    }

    protected boolean moveRelative(String id, float valueX, float valueY, float valueZoom) {
        boolean result = false;
        OnvifCamera camera = this.getApplication().getOnvifCamera(id);
        if (camera != null) {
            result = camera.moveRelative(valueX, valueY, valueZoom);
        }
        return result;
    }

    protected boolean moveAbsolute(String id, float valueX, float valueY, float valueZoom) {
        boolean result = false;
        OnvifCamera camera = this.getApplication().getOnvifCamera(id);
        if (camera != null) {
            result = camera.moveAbsolute(valueX, valueY, valueZoom);
        }
        return result;
    }

    protected boolean moveContinous(String id, float valueX, float valueY, float valueZoom) {
        boolean result = false;
        OnvifCamera camera = this.getApplication().getOnvifCamera(id);
        if (camera != null) {
            result = camera.moveContinous(valueX, valueY, valueZoom);
        }
        return result;
    }

    protected Result getViewerCountFromEndpoint(String endpointServiceId, String streamId) {
        VideoServiceEndpoint videoServiceEndPoint = this.getApplication().getVideoServiceEndPoint(endpointServiceId);
        long liveViews = 0L;
        if (videoServiceEndPoint != null) {
            liveViews = videoServiceEndPoint.getLiveViews(streamId);
        }
        return new Result(true, String.valueOf(liveViews));
    }

    protected Result getLiveCommentsCount(String endpointServiceId, String streamId) {
        VideoServiceEndpoint videoServiceEndPoint = this.getApplication().getVideoServiceEndPoint(endpointServiceId);
        int commentCount = 0;
        if (videoServiceEndPoint != null) {
            commentCount = videoServiceEndPoint.getTotalCommentsCount(streamId);
        }
        return new Result(true, String.valueOf(commentCount));
    }

    protected Interaction getInteractionFromEndpoint(String endpointServiceId, String streamId) {
        Interaction interaction = null;
        VideoServiceEndpoint videoServiceEndPoint = this.getApplication().getVideoServiceEndPoint(endpointServiceId);
        if (videoServiceEndPoint != null) {
            interaction = videoServiceEndPoint.getInteraction(streamId);
        }
        return interaction;
    }

    protected List<LiveComment> getLiveCommentsFromEndpoint(String endpointServiceId, String streamId, int offset, int batch) {
        VideoServiceEndpoint videoServiceEndPoint = this.getApplication().getVideoServiceEndPoint(endpointServiceId);
        List<LiveComment> liveComment = null;
        if (videoServiceEndPoint != null) {
            liveComment = videoServiceEndPoint.getComments(streamId, offset, batch);
        }
        return liveComment;
    }

    protected List<TensorFlowObject> getDetectionList(String id, int offset, int size) {
        List<Object> list = null;
        if (id != null) {
            list = this.getDataStore().getDetectionList(id, offset, size);
        }
        if (list == null) {
            list = new ArrayList();
        }
        return list;
    }

    protected Object getToken(String streamId, long expireDate, String type, String roomId) {
        Token token = null;
        String message = "Define Stream ID, Token Type and Expire Date (unix time)";
        if (streamId != null && type != null && expireDate > 0L) {
            ApplicationContext appContext = this.getAppContext();
            if (appContext != null && appContext.containsBean(ITokenService.BeanName.TOKEN_SERVICE.toString())) {
                ITokenService tokenService = (ITokenService)appContext.getBean(ITokenService.BeanName.TOKEN_SERVICE.toString());
                token = tokenService.createToken(streamId, expireDate, type, roomId);
                if (token != null) {
                    if (this.getDataStore().saveToken(token)) {
                        return token;
                    }
                    message = "Cannot save token to the datastore";
                } else {
                    message = "Cannot create token. It can be a mock token service";
                }
            } else {
                message = "No token service in this app";
            }
        }
        return new Result(false, message);
    }

    protected Object getJwtToken(String streamId, long expireDate, String type, String roomId) {
        Token token = null;
        String message = "Define Stream ID, Token Type and Expire Date (unix time)";
        if (streamId != null && type != null && expireDate > 0L) {
            ApplicationContext appContext = this.getAppContext();
            if (appContext != null && appContext.containsBean(ITokenService.BeanName.TOKEN_SERVICE.toString())) {
                ITokenService tokenService = (ITokenService)appContext.getBean(ITokenService.BeanName.TOKEN_SERVICE.toString());
                token = tokenService.createJwtToken(streamId, expireDate, type, roomId);
                if (token != null) {
                    return token;
                }
                message = "Cannot create JWT token. It can be a mock token service. Also please check your JWT Stream key parameter";
            } else {
                message = "No token service in this app";
            }
        }
        return new Result(false, message);
    }

    protected Token validateToken(Token token) {
        Token validatedToken = null;
        if (token.getTokenId() != null) {
            validatedToken = this.getDataStore().validateToken(token);
        }
        return validatedToken;
    }

    protected Result revokeTokens(String streamId) {
        Result result = new Result(false);
        if (streamId != null) {
            result.setSuccess(this.getDataStore().revokeTokens(streamId));
        }
        return result;
    }

    public static boolean deleteConferenceRoom(String roomName, DataStore store) {
        if (roomName != null) {
            return store.deleteConferenceRoom(roomName);
        }
        return false;
    }

    protected ConferenceRoom editConferenceRoom(ConferenceRoom room) {
        if (room != null && this.getDataStore().editConferenceRoom(room.getRoomId(), room)) {
            return room;
        }
        return null;
    }

    protected ConferenceRoom createConferenceRoom(ConferenceRoom room) {
        if (room != null) {
            if (room.getStartDate() == 0L) {
                room.setStartDate(Instant.now().getEpochSecond());
            }
            if (room.getEndDate() == 0L) {
                room.setEndDate(Instant.now().getEpochSecond() + 3600L);
            }
            if (this.getDataStore().createConferenceRoom(room)) {
                return room;
            }
        }
        return null;
    }

    protected VoD getVoD(String id) {
        VoD vod = null;
        if (id != null) {
            vod = this.getDataStore().getVoD(id);
        }
        if (vod == null) {
            vod = new VoD();
        }
        return vod;
    }

    public static Version getSoftwareVersion() {
        Version version = new Version();
        version.setVersionName(AntMediaApplicationAdapter.class.getPackage().getImplementationVersion());
        URL url = null;
        Class<RestServiceBase> clazz = RestServiceBase.class;
        String className = clazz.getSimpleName() + ".class";
        String classPath = clazz.getResource(className).toString();
        String manifestPath = classPath.substring(0, classPath.lastIndexOf("!") + 1) + "/META-INF/MANIFEST.MF";
        try {
            url = new URL(manifestPath);
        }
        catch (MalformedURLException e) {
            logger.error(e.getMessage());
        }
        try {
            if (url != null) {
                Manifest manifest = new Manifest(url.openStream());
                version.setBuildNumber(manifest.getMainAttributes().getValue(BUILD_NUMBER));
            } else {
                logger.error("url(META-INF/MANIFEST.MF) is null when getting software version");
            }
        }
        catch (IOException e) {
            logger.error(e.getMessage());
        }
        version.setVersionType(RestServiceBase.isEnterprise() ? ENTERPRISE_EDITION : COMMUNITY_EDITION);
        logger.info("Version Name {} Version Type {}", (Object)version.getVersionName(), (Object)version.getVersionType());
        return version;
    }

    public static boolean isEnterprise() {
        try {
            Class.forName("io.antmedia.enterprise.adaptive.EncoderAdaptor");
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    public static Map<String, String> getRoomInfoFromConference(String roomId, String streamId, DataStore store) {
        HashMap<String, String> streamDetailsMap = null;
        if (roomId != null) {
            ConferenceRoom conferenceRoom = store.getConferenceRoom(roomId);
            if (conferenceRoom == null) {
                logger.warn("There is no room with id:{}", (Object)roomId.replaceAll(REPLACE_CHARS, "_"));
                return streamDetailsMap;
            }
            streamDetailsMap = new HashMap<String, String>();
            List<String> tempList = conferenceRoom.getRoomStreamList();
            if (tempList != null) {
                for (String tmpStreamId : tempList) {
                    Broadcast broadcast = store.get(tmpStreamId);
                    if (broadcast == null || !broadcast.getStatus().equals("broadcasting")) continue;
                    streamDetailsMap.put(tmpStreamId, broadcast.getName());
                }
                streamDetailsMap.remove(streamId);
            }
        }
        return streamDetailsMap;
    }

    public static boolean addStreamToConferenceRoom(String roomId, String streamId, DataStore store) {
        if (roomId != null) {
            Broadcast broadcast;
            List<String> roomStreamList = null;
            ConferenceRoom conferenceRoom = store.getConferenceRoom(roomId);
            if (conferenceRoom != null && !(roomStreamList = conferenceRoom.getRoomStreamList()).contains(streamId) && (broadcast = store.get(streamId)) != null) {
                roomStreamList.add(streamId);
                conferenceRoom.setRoomStreamList(roomStreamList);
                store.editConferenceRoom(roomId, conferenceRoom);
                return true;
            }
        }
        return false;
    }

    public static boolean removeStreamFromRoom(String roomId, String streamId, DataStore store) {
        if (roomId != null) {
            List<String> roomStreamList = null;
            ConferenceRoom conferenceRoom = store.getConferenceRoom(roomId);
            if (conferenceRoom != null && (roomStreamList = conferenceRoom.getRoomStreamList()).contains(streamId)) {
                roomStreamList.remove(streamId);
                conferenceRoom.setRoomStreamList(roomStreamList);
                store.editConferenceRoom(roomId, conferenceRoom);
                return true;
            }
        }
        return false;
    }

    public static String logFailedOperation(boolean enableRecording, String streamId, RecordType type) {
        String id = streamId.replaceAll(REPLACE_CHARS, "_");
        if (enableRecording) {
            logger.warn("{} recording could not be started for stream: {}", (Object)type, (Object)id);
        } else {
            logger.warn("{} recording could not be stopped for stream: {}", (Object)type, (Object)id);
        }
        return id;
    }

    public Result enableRecordMuxing(String streamId, boolean enableRecording, String type) {
        String status;
        boolean result = false;
        Object message = null;
        String string = status = enableRecording ? "started" : "stopped";
        if (streamId != null) {
            Broadcast broadcast = this.getDataStore().get(streamId);
            if (broadcast != null) {
                if (type.equals(RecordType.WEBM.toString()) && enableRecording && broadcast.getWebMEnabled() != 1 || !enableRecording && broadcast.getWebMEnabled() != -1 || type.equals(RecordType.MP4.toString()) && enableRecording && broadcast.getMp4Enabled() != 1 || !enableRecording && broadcast.getMp4Enabled() != -1) {
                    result = true;
                    if (broadcast.getStatus().equals("broadcasting")) {
                        if (this.isInSameNodeInCluster(broadcast.getOriginAdress())) {
                            if (enableRecording && type.equals(RecordType.WEBM.toString())) {
                                result = this.startRecord(streamId, RecordType.WEBM);
                            } else if (!enableRecording && type.equals(RecordType.WEBM.toString())) {
                                result = this.stopRecord(streamId, RecordType.WEBM);
                            } else if (enableRecording && type.equals(RecordType.MP4.toString())) {
                                result = this.startRecord(streamId, RecordType.MP4);
                            } else if (!enableRecording && type.equals(RecordType.MP4.toString())) {
                                result = this.stopRecord(streamId, RecordType.MP4);
                            }
                            if (result) {
                                message = Long.toString(System.currentTimeMillis());
                                logger.warn("{} recording is {} for stream: {}", new Object[]{type, status, streamId});
                            } else {
                                RestServiceBase.logFailedOperation(enableRecording, streamId, type.equals(RecordType.MP4.toString()) ? RecordType.MP4 : RecordType.WEBM);
                                message = type + " recording couldn't " + status;
                            }
                        } else {
                            message = "Please send " + type + " recording request to " + broadcast.getOriginAdress() + " node or send request in a stopped status.";
                            result = false;
                        }
                    }
                    if (result && enableRecording && type.equals(RecordType.WEBM.toString())) {
                        result = this.getDataStore().setWebMMuxing(streamId, 1);
                    } else if (result && enableRecording && type.equals(RecordType.MP4.toString())) {
                        result = this.getDataStore().setMp4Muxing(streamId, 1);
                    } else if (result && !enableRecording && type.equals(RecordType.WEBM.toString())) {
                        result = this.getDataStore().setWebMMuxing(streamId, -1);
                    } else if (result && !enableRecording && type.equals(RecordType.MP4.toString())) {
                        result = this.getDataStore().setMp4Muxing(streamId, -1);
                    }
                } else {
                    message = type + " recording status  is already: " + enableRecording;
                }
            }
        } else {
            message = "No stream for this id: " + streamId + " or wrong setting parameter";
        }
        return new Result(result, (String)message);
    }

    public static interface ProcessBuilderFactory {
        public Process make(String ... var1);
    }

    @ApiModel(value="AppBroadcastStatistics", description="The statistics class of the app. It provides total number of viewers and active live streams")
    public static class AppBroadcastStatistics
    extends BroadcastStatistics {
        @ApiModelProperty(value="the total active live stream count")
        public final int activeLiveStreamCount;

        public AppBroadcastStatistics(int totalRTMPWatchersCount, int totalHLSWatchersCount, int totalWebRTCWatchersCount, int activeLiveStreamCount) {
            super(totalRTMPWatchersCount, totalHLSWatchersCount, totalWebRTCWatchersCount);
            this.activeLiveStreamCount = activeLiveStreamCount;
        }
    }

    @ApiModel(value="BroadcastStatistics", description="The statistics class of the broadcasts")
    public static class BroadcastStatistics {
        @ApiModelProperty(value="the total RTMP viewers of the stream")
        public final int totalRTMPWatchersCount;
        @ApiModelProperty(value="the total HLS viewers of the stream")
        public final int totalHLSWatchersCount;
        @ApiModelProperty(value="the total WebRTC viewers of the stream")
        public final int totalWebRTCWatchersCount;

        public BroadcastStatistics(int totalRTMPWatchersCount, int totalHLSWatchersCount, int totalWebRTCWatchersCount) {
            this.totalRTMPWatchersCount = totalRTMPWatchersCount;
            this.totalHLSWatchersCount = totalHLSWatchersCount;
            this.totalWebRTCWatchersCount = totalWebRTCWatchersCount;
        }
    }
}

