/*
 * Decompiled with CFR 0.152.
 */
package io.antmedia.rest.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.antmedia.rest.model.UserType;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

@ApiModel(value="User", description="The basic user class")
public class User {
    @ApiModelProperty(value="the email of the user")
    private String email;
    @ApiModelProperty(value="the password of the user")
    @JsonProperty(access=JsonProperty.Access.WRITE_ONLY)
    private String password;
    @ApiModelProperty(value="the type of the user", allowableValues="facebook_user, periscope_user, youtube_user, admin, read-only")
    private UserType userType;
    @ApiModelProperty(value="the new password of the user")
    @JsonProperty(access=JsonProperty.Access.WRITE_ONLY)
    private String newPassword;
    @ApiModelProperty(value="the name of the user")
    private String fullName;
    @ApiModelProperty(value="the URL of the user picture")
    private String picture;
    @ApiModelProperty(value="the id of the user")
    private String id;

    public User(String email, String password, UserType userType) {
        this.email = email;
        this.password = password;
        this.userType = userType;
    }

    public User(String id, String name, String picture, UserType userType) {
        this.id = id;
        this.fullName = name;
        this.picture = picture;
        this.userType = userType;
    }

    public User() {
    }

    public String getEmail() {
        return this.email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public UserType getUserType() {
        return this.userType;
    }

    public void setUserType(UserType userType) {
        this.userType = userType;
    }

    public String getNewPassword() {
        return this.newPassword;
    }

    public void setNewPassword(String newPassword) {
        this.newPassword = newPassword;
    }

    public String getFullName() {
        return this.fullName;
    }

    public void setFullName(String fullName) {
        this.fullName = fullName;
    }

    public String getPicture() {
        return this.picture;
    }

    public void setPicture(String picture) {
        this.picture = picture;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }
}

