/*
 * Decompiled with CFR 0.152.
 */
package io.antmedia.servlet;

import io.antmedia.servlet.IChunkedCacheManager;
import io.antmedia.servlet.cmafutils.AtomParser;
import io.antmedia.servlet.cmafutils.ICMAFChunkListener;
import io.antmedia.servlet.cmafutils.IParser;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.concurrent.LinkedBlockingQueue;
import javax.servlet.AsyncContext;
import javax.servlet.AsyncEvent;
import javax.servlet.AsyncListener;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.catalina.connector.ClientAbortException;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.web.context.ConfigurableWebApplicationContext;
import org.springframework.web.context.WebApplicationContext;

public class ChunkedTransferServlet
extends HttpServlet {
    public static final String STREAMS = "/streams";
    public static final String WEBAPPS = "webapps";
    protected static Logger logger = LoggerFactory.getLogger(ChunkedTransferServlet.class);

    protected void doPut(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.handleIncomingStream(req, resp);
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.handleIncomingStream(req, resp);
    }

    public void handleIncomingStream(HttpServletRequest req, HttpServletResponse resp) {
        ConfigurableWebApplicationContext appContext = (ConfigurableWebApplicationContext)req.getServletContext().getAttribute(WebApplicationContext.ROOT_WEB_APPLICATION_CONTEXT_ATTRIBUTE);
        if (appContext != null && appContext.isRunning()) {
            String applicationName = appContext.getApplicationName();
            String filepath = WEBAPPS + applicationName + STREAMS + req.getPathInfo();
            File finalFile = new File(filepath);
            String tmpFilepath = filepath + ".tmp";
            File tmpFile = new File(tmpFilepath);
            File streamsDir = new File(WEBAPPS + applicationName + STREAMS);
            File firstParent = finalFile.getParentFile();
            File grandParent = firstParent.getParentFile();
            if (firstParent.equals(streamsDir) || grandParent.equals(streamsDir)) {
                this.mkdirIfRequired(req, applicationName);
                try {
                    IChunkedCacheManager cacheManager = (IChunkedCacheManager)appContext.getBean("chunked.cache.manager");
                    logger.info("doPut key:{}", (Object)finalFile.getAbsolutePath());
                    cacheManager.addCache(finalFile.getAbsolutePath());
                    IParser atomparser = filepath.endsWith(".mpd") || filepath.endsWith(".m3u8") ? new AtomParser.MockAtomParser() : new AtomParser(completeChunk -> cacheManager.append(finalFile.getAbsolutePath(), completeChunk));
                    AsyncContext asyncContext = req.startAsync();
                    StatusListener statusListener = new StatusListener(filepath);
                    asyncContext.addListener((AsyncListener)statusListener);
                    ServletInputStream inputStream = asyncContext.getRequest().getInputStream();
                    asyncContext.start(() -> this.lambda$handleIncomingStream$1(finalFile, tmpFile, cacheManager, atomparser, asyncContext, (InputStream)inputStream, statusListener));
                }
                catch (IOException | IllegalStateException | BeansException e) {
                    logger.error(ExceptionUtils.getStackTrace((Throwable)e));
                    this.writeInternalError(resp, 500, null);
                }
            } else {
                logger.warn("AppContext is not running for write request to {}", (Object)req.getRequestURI());
            }
        } else {
            logger.warn("AppContext is not running for write request to {}", (Object)req.getRequestURI());
            this.writeInternalError(resp, 500, "Server is not ready. It's likely starting. Please try a few seconds later. ");
        }
    }

    private void mkdirIfRequired(HttpServletRequest req, String applicationName) {
        String subDirName;
        File subDir;
        int secondSlashIndex = req.getPathInfo().indexOf(47, 1);
        if (secondSlashIndex != -1 && !(subDir = new File(WEBAPPS + applicationName + STREAMS + (subDirName = req.getPathInfo().substring(0, secondSlashIndex)))).exists()) {
            subDir.mkdir();
        }
    }

    public void readInputStream(File finalFile, File tmpFile, IChunkedCacheManager cacheManager, IParser atomparser, AsyncContext asyncContext, InputStream inputStream, StatusListener statusListener) {
        boolean exceptionOccured = false;
        try (FileOutputStream fos = new FileOutputStream(tmpFile);){
            byte[] data = new byte[2048];
            int length = 0;
            while ((length = inputStream.read(data, 0, data.length)) > 0) {
                atomparser.parse(data, 0, length);
                fos.write(data, 0, length);
                if (!statusListener.isTimeoutOrErrorExist()) continue;
                logger.warn("Timeout or error exists for file: {} breaking the loop", (Object)finalFile.getAbsolutePath());
                break;
            }
            Files.move(tmpFile.toPath(), finalFile.toPath(), StandardCopyOption.ATOMIC_MOVE, StandardCopyOption.REPLACE_EXISTING);
        }
        catch (ClientAbortException e) {
            logger.warn("Client aborted - Reading input stream for file: {}", (Object)finalFile.getAbsolutePath());
            exceptionOccured = true;
        }
        catch (Exception e) {
            logger.error(ExceptionUtils.getStackTrace((Throwable)e));
            exceptionOccured = true;
        }
        if (!exceptionOccured) {
            asyncContext.complete();
        }
        cacheManager.removeCache(finalFile.getAbsolutePath());
        logger.info("doPut done key:{}", (Object)finalFile.getAbsolutePath());
    }

    public void deleteRequest(HttpServletRequest req, HttpServletResponse resp) {
        block5: {
            ConfigurableWebApplicationContext appContext = (ConfigurableWebApplicationContext)req.getServletContext().getAttribute(WebApplicationContext.ROOT_WEB_APPLICATION_CONTEXT_ATTRIBUTE);
            if (appContext != null && appContext.isRunning()) {
                String applicationName = appContext.getApplicationName();
                String filepath = WEBAPPS + applicationName + STREAMS + req.getPathInfo();
                File file = new File(filepath);
                File streamsDir = new File(WEBAPPS + applicationName + STREAMS);
                logger.debug("doDelete for file: {}", (Object)file.getAbsolutePath());
                try {
                    if (!file.exists()) break block5;
                    File firstParent = file.getParentFile();
                    File grandParent = firstParent.getParentFile();
                    if (firstParent.equals(streamsDir) || grandParent.equals(streamsDir)) {
                        Files.deleteIfExists(file.toPath());
                        this.deleteFreeDir(req, applicationName, streamsDir);
                        break block5;
                    }
                    logger.error("Parent or grant parent is not streams directory for DELETE operation {}", (Object)filepath);
                    this.writeInternalError(resp, 409, null);
                }
                catch (Exception e) {
                    this.writeInternalError(resp, 500, null);
                }
            } else {
                logger.error("Server is not ready for req: {}", (Object)req.getPathInfo());
                this.writeInternalError(resp, 500, null);
            }
        }
    }

    protected void doDelete(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.deleteRequest(req, resp);
    }

    private void deleteFreeDir(HttpServletRequest req, String applicationName, File streamsDir) throws IOException {
        String subDirName;
        File subDir;
        int secondSlashIndex = req.getPathInfo().indexOf(47, 1);
        if (secondSlashIndex != -1 && (subDir = new File(WEBAPPS + applicationName + STREAMS + (subDirName = req.getPathInfo().substring(0, req.getPathInfo().indexOf(47, 1))))).exists() && subDir.isDirectory() && subDir.getParentFile().equals(streamsDir) && subDir.list().length == 0) {
            Files.deleteIfExists(subDir.toPath());
        }
    }

    public void writeOutputStream(File file, AsyncContext asyncContext, OutputStream ostream) {
        try (FileInputStream fis = new FileInputStream(file);){
            int length = 0;
            byte[] data = new byte[2048];
            while ((length = fis.read(data, 0, data.length)) > 0) {
                ostream.write(data, 0, length);
            }
            ostream.flush();
            asyncContext.complete();
        }
        catch (IOException e) {
            logger.error(ExceptionUtils.getStackTrace((Throwable)e));
        }
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.handleGetRequest(req, resp);
    }

    public void handleGetRequest(HttpServletRequest req, HttpServletResponse resp) {
        block6: {
            ConfigurableWebApplicationContext appContext = (ConfigurableWebApplicationContext)req.getServletContext().getAttribute(WebApplicationContext.ROOT_WEB_APPLICATION_CONTEXT_ATTRIBUTE);
            if (appContext != null && appContext.isRunning()) {
                File file = new File(WEBAPPS + File.separator + req.getRequestURI());
                try {
                    if (file.exists()) {
                        logger.trace("File exists: {}", (Object)file.getAbsolutePath());
                        AsyncContext asyncContext = req.startAsync();
                        ServletOutputStream outputStream = asyncContext.getResponse().getOutputStream();
                        asyncContext.start(() -> this.writeOutputStream(file, asyncContext, (OutputStream)outputStream));
                        break block6;
                    }
                    IChunkedCacheManager cacheManager = (IChunkedCacheManager)appContext.getBean("chunked.cache.manager");
                    boolean cacheAvailable = cacheManager.hasCache(file.getAbsolutePath());
                    if (cacheAvailable) {
                        AsyncContext asyncContext = req.startAsync();
                        ChunkListener chunkListener = new ChunkListener();
                        cacheManager.registerChunkListener(file.getAbsolutePath(), chunkListener);
                        asyncContext.start(() -> this.writeChunks(file, cacheManager, asyncContext, chunkListener));
                        break block6;
                    }
                    logger.info("Sending not found error(404) for {}", (Object)file.getAbsolutePath());
                    this.writeInternalError(resp, 404, null);
                }
                catch (IOException | IllegalStateException | BeansException e) {
                    logger.error(ExceptionUtils.getStackTrace((Throwable)e));
                    this.writeInternalError(resp, 500, null);
                }
            } else {
                logger.warn("AppContext is not running for get request {}", (Object)req.getRequestURI());
                this.writeInternalError(resp, 500, "Server is not ready. It's likely starting. Please try a few seconds later. ");
            }
        }
    }

    public void writeChunks(File file, IChunkedCacheManager cacheManager, AsyncContext asyncContext, ChunkListener chunkListener) {
        String filePath = file.getAbsolutePath();
        boolean exceptionOccured = false;
        try {
            byte[] chunk;
            ServletOutputStream oStream = asyncContext.getResponse().getOutputStream();
            while ((chunk = chunkListener.getChunksQueue().take()).length > 0) {
                int offset = 0;
                int batchSize = 2048;
                int length = 0;
                logger.debug("start writing chunk leaving for file: {}", (Object)filePath);
                while ((length = chunk.length - offset) > 0) {
                    if (length > batchSize) {
                        length = batchSize;
                    }
                    oStream.write(chunk, offset, length);
                    offset += length;
                }
                oStream.flush();
                logger.debug("writing chunk leaving for file: {}", (Object)filePath);
            }
        }
        catch (ClientAbortException e) {
            logger.warn("Client aborted - writing chunks for file: {}", (Object)filePath);
            exceptionOccured = true;
        }
        catch (InterruptedException e) {
            logger.error(ExceptionUtils.getStackTrace((Throwable)e));
            Thread.currentThread().interrupt();
        }
        catch (Exception e) {
            logger.error(ExceptionUtils.getStackTrace((Throwable)e));
            exceptionOccured = true;
        }
        if (!exceptionOccured) {
            asyncContext.complete();
        }
        cacheManager.removeChunkListener(filePath, chunkListener);
    }

    private void writeInternalError(HttpServletResponse resp, int status, String message) {
        try {
            resp.setStatus(status);
            PrintWriter writer = resp.getWriter();
            if (message != null) {
                writer.print(message);
            }
            writer.close();
        }
        catch (IOException e) {
            logger.error(ExceptionUtils.getStackTrace((Throwable)e));
        }
    }

    private /* synthetic */ void lambda$handleIncomingStream$1(File finalFile, File tmpFile, IChunkedCacheManager cacheManager, IParser atomparser, AsyncContext asyncContext, InputStream inputStream, StatusListener statusListener) {
        this.readInputStream(finalFile, tmpFile, cacheManager, atomparser, asyncContext, inputStream, statusListener);
    }

    public static class StatusListener
    implements AsyncListener {
        String filepath;
        boolean timeoutOrErrorExist = false;

        public StatusListener(String filepath) {
            this.filepath = filepath;
        }

        public void onTimeout(AsyncEvent event) throws IOException {
            logger.warn("handle incoming stream context Timeout: {}", (Object)this.filepath);
            this.timeoutOrErrorExist = true;
        }

        public void onStartAsync(AsyncEvent event) throws IOException {
            logger.debug("handle incoming stream context onStartAsync: {}", (Object)this.filepath);
        }

        public void onError(AsyncEvent event) throws IOException {
            logger.warn("handle incoming stream context onError: {}", (Object)this.filepath);
            this.timeoutOrErrorExist = true;
        }

        public void onComplete(AsyncEvent event) throws IOException {
            logger.debug("handle incoming stream context onComplete: {}", (Object)this.filepath);
        }

        public boolean isTimeoutOrErrorExist() {
            return this.timeoutOrErrorExist;
        }
    }

    public static class ChunkListener
    implements ICMAFChunkListener {
        LinkedBlockingQueue<byte[]> chunksQueue = new LinkedBlockingQueue();

        @Override
        public void chunkCompleted(byte[] completeChunk) {
            byte[] data;
            if (completeChunk != null) {
                data = new byte[completeChunk.length];
                System.arraycopy(completeChunk, 0, data, 0, data.length);
            } else {
                data = new byte[]{};
            }
            this.chunksQueue.add(data);
        }

        public LinkedBlockingQueue<byte[]> getChunksQueue() {
            return this.chunksQueue;
        }
    }
}

