/*
 * Decompiled with CFR 0.152.
 */
package io.antmedia.servlet.cmafutils;

import io.antmedia.servlet.cmafutils.ICMAFChunkListener;
import io.antmedia.servlet.cmafutils.IParser;
import java.util.LinkedList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AtomParser
implements IParser {
    protected static Logger logger = LoggerFactory.getLogger(AtomParser.class);
    private int atomLength = 0;
    private byte[] atomData;
    private int currentPosition = 0;
    private byte[] remainerData;
    private static final int STYP_ATOM = 0;
    private static final int PRFT_ATOM = 1;
    private static final int EMSG_ATOM = 2;
    private static final int MOOF_ATOM = 3;
    private static final int MDAT_ATOM = 4;
    private static final int FTYP_ATOM = 5;
    private static final int MOOV_ATOM = 6;
    private int currentAtomType = 0;
    private int currentChunkedSize = 0;
    private LinkedList<byte[]> populatingChunked = new LinkedList();
    private ICMAFChunkListener chunkListener;

    public AtomParser(ICMAFChunkListener chunkListener) {
        this.chunkListener = chunkListener;
    }

    @Override
    public void parse(byte[] data, int offset, int length) {
        int remainingBytesInArray;
        if (this.atomLength == 0) {
            if (length >= offset + 3) {
                if (this.remainerData != null) {
                    byte[] tmpData = new byte[this.remainerData.length + length];
                    System.arraycopy(this.remainerData, 0, tmpData, 0, this.remainerData.length);
                    System.arraycopy(data, 0, tmpData, this.remainerData.length, length);
                    data = tmpData;
                }
                this.atomLength = (0xFF & data[offset + 0]) << 24 | (0xFF & data[offset + 1]) << 16 | (0xFF & data[offset + 2]) << 8 | 0xFF & data[offset + 3];
                this.atomData = new byte[this.atomLength];
                logger.trace("atom length:{} ", (Object)this.atomLength);
                this.setCurrentAtomType(data, offset);
            } else {
                this.remainerData = new byte[length - offset];
                System.arraycopy(data, offset, this.remainerData, 0, this.remainerData.length);
                return;
            }
        }
        if ((remainingBytesInArray = length + this.currentPosition - this.atomLength - offset) >= 0) {
            int remaining = this.atomLength - this.currentPosition;
            logger.trace("remaining offset: {} currentPosition:{} length:{} remaining:{}", new Object[]{offset, this.currentPosition, length, remaining});
            System.arraycopy(data, offset, this.atomData, this.currentPosition, remaining);
            if (this.currentAtomType == 0 || this.currentAtomType == 4 || this.currentAtomType == 6) {
                this.finalizeChunked();
            } else {
                this.populatingChunked.add(this.atomData);
                this.currentChunkedSize += this.atomData.length;
            }
            this.atomLength = 0;
            this.currentPosition = 0;
            if (remainingBytesInArray > 0) {
                this.parse(data, offset + remaining, length);
            }
        } else {
            logger.trace("offset: {} currentPosition: {} length: {}", new Object[]{offset, this.currentPosition, length});
            System.arraycopy(data, offset, this.atomData, this.currentPosition, length - offset);
            this.currentPosition += length - offset;
        }
    }

    private void setCurrentAtomType(byte[] data, int offset) {
        if (data[offset + 4] == 115) {
            this.currentAtomType = 0;
        } else if (data[offset + 4] == 112) {
            this.currentAtomType = 1;
        } else if (data[offset + 4] == 101) {
            this.currentAtomType = 2;
        } else if (data[offset + 4] == 109 && data[offset + 5] == 111 && data[offset + 6] == 111 && data[offset + 7] == 102) {
            this.currentAtomType = 3;
        } else if (data[offset + 4] == 109 && data[offset + 5] == 100 && data[offset + 6] == 97 && data[offset + 7] == 116) {
            this.currentAtomType = 4;
        } else if (data[offset + 4] == 102 && data[offset + 5] == 116 && data[offset + 6] == 121 && data[offset + 7] == 112) {
            this.currentAtomType = 5;
        } else if (data[offset + 4] == 109 && data[offset + 5] == 111 && data[offset + 6] == 111 && data[offset + 7] == 118) {
            this.currentAtomType = 6;
        } else {
            logger.error("atom type is not detected {} {} {} {}", new Object[]{data[offset + 4], data[offset + 5], data[offset + 6], data[offset + 7]});
        }
    }

    private void finalizeChunked() {
        this.populatingChunked.add(this.atomData);
        this.currentChunkedSize += this.atomData.length;
        byte[] completeChunk = new byte[this.currentChunkedSize];
        int populatingChunkPosition = 0;
        for (byte[] chunkAtom : this.populatingChunked) {
            System.arraycopy(chunkAtom, 0, completeChunk, populatingChunkPosition, chunkAtom.length);
            populatingChunkPosition += chunkAtom.length;
        }
        this.populatingChunked.clear();
        this.currentChunkedSize = 0;
        this.chunkListener.chunkCompleted(completeChunk);
    }

    public static class MockAtomParser
    implements IParser {
        @Override
        public void parse(byte[] data, int offset, int length) {
        }
    }
}

