/*
 * Decompiled with CFR 0.152.
 */
package org.red5.server.net.rtmp;

import java.beans.ConstructorProperties;
import java.lang.management.ManagementFactory;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.ArrayList;
import java.util.Collections;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.management.StandardMBean;
import org.apache.mina.core.buffer.IoBuffer;
import org.apache.mina.core.future.CloseFuture;
import org.apache.mina.core.future.IoFutureListener;
import org.apache.mina.core.session.IoSession;
import org.red5.server.api.scope.IScope;
import org.red5.server.jmx.mxbeans.RTMPMinaConnectionMXBean;
import org.red5.server.net.rtmp.Channel;
import org.red5.server.net.rtmp.RTMPConnection;
import org.red5.server.net.rtmp.codec.RTMP;
import org.red5.server.net.rtmp.event.ClientBW;
import org.red5.server.net.rtmp.event.ServerBW;
import org.red5.server.net.rtmp.message.Packet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jmx.export.annotation.ManagedResource;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;

@ManagedResource
public class RTMPMinaConnection
extends RTMPConnection
implements RTMPMinaConnectionMXBean {
    protected static Logger log = LoggerFactory.getLogger(RTMPMinaConnection.class);
    private final AtomicBoolean closing = new AtomicBoolean(false);
    private transient IoSession ioSession;
    private ObjectName oName;
    protected int defaultServerBandwidth = 10000000;
    protected int defaultClientBandwidth = 10000000;
    protected boolean bandwidthDetection = true;

    @ConstructorProperties(value={"persistent"})
    public RTMPMinaConnection() {
        super("persistent");
    }

    @Override
    public boolean connect(IScope newScope, Object[] params) {
        log.debug("Connect scope: {}", (Object)newScope);
        boolean success = super.connect(newScope, params);
        if (success) {
            Channel two = this.getChannel(2);
            two.write(new ServerBW(this.defaultServerBandwidth));
            two.write(new ClientBW(this.defaultClientBandwidth, (byte)this.limitType));
            if (this.client != null) {
                if (this.bandwidthDetection && !this.client.isBandwidthChecked()) {
                    this.client.checkBandwidth();
                }
            } else {
                log.warn("Client was null");
            }
            this.registerJMX();
        } else {
            log.debug("Connect failed");
        }
        return success;
    }

    @Override
    public void close() {
        if (this.closing.compareAndSet(false, true)) {
            super.close();
            log.debug("IO Session closing: {}", this.ioSession != null ? Boolean.valueOf(this.ioSession.isClosing()) : null);
            if (this.ioSession != null && !this.ioSession.isClosing()) {
                final RTMPMinaConnection self = this;
                CloseFuture future = this.ioSession.closeNow();
                log.debug("Connection close future: {}", (Object)future);
                IoFutureListener<CloseFuture> listener = new IoFutureListener<CloseFuture>(){

                    public void operationComplete(CloseFuture future) {
                        if (future.isClosed()) {
                            log.info("Connection is closed: {}", (Object)RTMPMinaConnection.this.getSessionId());
                            if (log.isTraceEnabled()) {
                                log.trace("Session id - local: {} session: {}", (Object)RTMPMinaConnection.this.getSessionId(), (Object)((String)RTMPMinaConnection.this.ioSession.removeAttribute((Object)"rtmp.sessionid")));
                            }
                            RTMPMinaConnection.this.handler.connectionClosed(self);
                        } else {
                            log.debug("Connection is not yet closed");
                        }
                        future.removeListener((IoFutureListener)this);
                    }
                };
                future.addListener((IoFutureListener)listener);
            }
            log.debug("Connection state: {}", (Object)this.getState());
            if (this.getStateCode() != 5) {
                this.handler.connectionClosed(this);
            }
            this.unregisterJMX();
        } else if (log.isDebugEnabled()) {
            log.debug("Close has already been called");
        }
    }

    @Override
    public IoSession getIoSession() {
        return this.ioSession;
    }

    public int getDefaultServerBandwidth() {
        return this.defaultServerBandwidth;
    }

    public void setDefaultServerBandwidth(int defaultServerBandwidth) {
        this.defaultServerBandwidth = defaultServerBandwidth;
    }

    public int getDefaultClientBandwidth() {
        return this.defaultClientBandwidth;
    }

    public void setDefaultClientBandwidth(int defaultClientBandwidth) {
        this.defaultClientBandwidth = defaultClientBandwidth;
    }

    public int getLimitType() {
        return this.limitType;
    }

    public void setLimitType(int limitType) {
        this.limitType = limitType;
    }

    @Override
    public void setExecutor(ThreadPoolTaskExecutor executor) {
        this.executor = executor;
    }

    public boolean isBandwidthDetection() {
        return this.bandwidthDetection;
    }

    public void setBandwidthDetection(boolean bandwidthDetection) {
        this.bandwidthDetection = bandwidthDetection;
    }

    @Override
    public boolean isReaderIdle() {
        if (this.ioSession != null) {
            return this.ioSession.isReaderIdle();
        }
        return true;
    }

    @Override
    public boolean isWriterIdle() {
        if (this.ioSession != null) {
            return this.ioSession.isWriterIdle();
        }
        return true;
    }

    @Override
    public long getPendingMessages() {
        if (this.ioSession != null) {
            return this.ioSession.getScheduledWriteMessages();
        }
        return 0L;
    }

    @Override
    public long getReadBytes() {
        if (this.ioSession != null) {
            return this.ioSession.getReadBytes();
        }
        return 0L;
    }

    @Override
    public long getWrittenBytes() {
        if (this.ioSession != null) {
            return this.ioSession.getWrittenBytes();
        }
        return 0L;
    }

    @Override
    public void invokeMethod(String method) {
        this.invoke(method);
    }

    @Override
    public boolean isConnected() {
        if (log.isTraceEnabled()) {
            log.trace("Connected: {}", (Object)(this.ioSession != null && this.ioSession.isConnected() ? 1 : 0));
        }
        return super.isConnected() && this.ioSession != null && this.ioSession.isConnected();
    }

    @Override
    public boolean isIdle() {
        if (this.ioSession != null) {
            if (log.isDebugEnabled()) {
                log.debug("Connection idle - read: {} write: {}", (Object)this.ioSession.isReaderIdle(), (Object)this.ioSession.isWriterIdle());
            }
            return super.isIdle() && this.ioSession.isBothIdle();
        }
        return super.isIdle();
    }

    @Override
    protected void onInactive() {
        this.close();
    }

    public void setIoSession(IoSession protocolSession) {
        SocketAddress remote = protocolSession.getRemoteAddress();
        if (remote instanceof InetSocketAddress) {
            this.remoteAddress = ((InetSocketAddress)remote).getAddress().getHostAddress();
            this.remotePort = ((InetSocketAddress)remote).getPort();
        } else {
            this.remoteAddress = remote.toString();
            this.remotePort = -1;
        }
        this.remoteAddresses = new ArrayList(1);
        this.remoteAddresses.add(this.remoteAddress);
        this.remoteAddresses = Collections.unmodifiableList(this.remoteAddresses);
        this.ioSession = protocolSession;
        if (log.isTraceEnabled()) {
            log.trace("setIoSession conn: {}", (Object)this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(Packet out) {
        if (this.ioSession != null) {
            Semaphore lock = this.getLock();
            if (log.isTraceEnabled()) {
                log.trace("Write lock wait count: {} closed: {}", (Object)lock.getQueueLength(), (Object)this.isClosed());
            }
            while (!this.isClosed()) {
                boolean acquired = false;
                try {
                    acquired = lock.tryAcquire(10L, TimeUnit.MILLISECONDS);
                    if (!acquired) continue;
                    if (log.isTraceEnabled()) {
                        log.trace("Writing message");
                    }
                    this.writingMessage(out);
                    this.ioSession.write((Object)out);
                    break;
                }
                catch (InterruptedException e) {
                    String exMsg;
                    log.warn("Interrupted while waiting for write lock. State: {}", (Object)RTMP.states[this.state.getState()], (Object)e);
                    if (log.isInfoEnabled()) {
                        log.info("Session id: {} in queue size: {} pending msgs: {} last ping/pong: {}", new Object[]{this.getSessionId(), this.currentQueueSize(), this.getPendingMessages(), this.getLastPingSentAndLastPongReceivedInterval()});
                        log.info("Available permits - decoder: {} encoder: {}", (Object)this.decoderLock.availablePermits(), (Object)this.encoderLock.availablePermits());
                    }
                    if ((exMsg = e.getMessage()) != null && exMsg.indexOf("null") < 0) continue;
                    log.debug("Exception writing to connection: {}", (Object)this);
                    break;
                }
                finally {
                    if (acquired) {
                        lock.release();
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeRaw(IoBuffer out) {
        if (this.ioSession != null) {
            Semaphore lock = this.getLock();
            while (!this.isClosed()) {
                boolean acquired = false;
                try {
                    acquired = lock.tryAcquire(10L, TimeUnit.MILLISECONDS);
                    if (!acquired) continue;
                    if (log.isTraceEnabled()) {
                        log.trace("Writing raw message");
                    }
                    this.ioSession.write((Object)out);
                    break;
                }
                catch (InterruptedException e) {
                    log.warn("Interrupted while waiting for write lock (writeRaw). State: {}", (Object)RTMP.states[this.state.getState()], (Object)e);
                    String exMsg = e.getMessage();
                    if (exMsg != null && exMsg.indexOf("null") < 0) continue;
                    log.debug("Exception writing to connection: {}", (Object)this);
                    break;
                }
                finally {
                    if (acquired) {
                        lock.release();
                    }
                }
            }
        }
    }

    protected void registerJMX() {
        MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
        try {
            String cName = this.getClass().getName();
            if (cName.indexOf(46) != -1) {
                cName = cName.substring(cName.lastIndexOf(46)).replaceFirst("[\\.]", "");
            }
            String hostStr = this.host;
            int port = 1935;
            if (this.host != null && this.host.indexOf(":") > -1) {
                String[] arr = this.host.split(":");
                hostStr = arr[0];
                port = Integer.parseInt(arr[1]);
            }
            this.oName = new ObjectName(String.format("org.red5.server:type=%s,connectionType=%s,host=%s,port=%d,clientId=%s", cName, this.type, hostStr, port, this.client.getId()));
            if (!mbs.isRegistered(this.oName)) {
                mbs.registerMBean(new StandardMBean(this, RTMPMinaConnectionMXBean.class, true), this.oName);
            } else {
                log.debug("Connection is already registered in JMX");
            }
        }
        catch (Exception e) {
            log.warn("Error on jmx registration", (Throwable)e);
        }
    }

    protected void unregisterJMX() {
        MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
        if (this.oName != null && mbs.isRegistered(this.oName)) {
            try {
                mbs.unregisterMBean(this.oName);
            }
            catch (Exception e) {
                log.warn("Exception unregistering: {}", (Object)this.oName, (Object)e);
            }
            this.oName = null;
        }
    }
}

