/*
 * Decompiled with CFR 0.152.
 */
package org.red5.server.net.rtmp;

import org.apache.mina.core.buffer.IoBuffer;
import org.red5.server.net.rtmp.message.Constants;

public class RTMPUtils
implements Constants {
    public static void writeReverseIntOld(IoBuffer out, int value) {
        byte[] bytes = new byte[4];
        IoBuffer rev = IoBuffer.allocate((int)4);
        rev.putInt(value);
        rev.flip();
        bytes[3] = rev.get();
        bytes[2] = rev.get();
        bytes[1] = rev.get();
        bytes[0] = rev.get();
        out.put(bytes);
        rev.free();
        rev = null;
    }

    public static void writeReverseInt(IoBuffer out, int value) {
        out.put((byte)(0xFF & value));
        out.put((byte)(0xFF & value >> 8));
        out.put((byte)(0xFF & value >> 16));
        out.put((byte)(0xFF & value >> 24));
    }

    public static void writeMediumInt(IoBuffer out, int value) {
        out.put((byte)(0xFF & value >> 16));
        out.put((byte)(0xFF & value >> 8));
        out.put((byte)(0xFF & value >> 0));
    }

    public static int readUnsignedMediumInt(IoBuffer in) {
        byte a = in.get();
        byte b = in.get();
        byte c = in.get();
        int val = 0;
        val += (a & 0xFF) << 16;
        val += (b & 0xFF) << 8;
        return val += c & 0xFF;
    }

    public static int readUnsignedMediumIntOld(IoBuffer in) {
        byte[] bytes = new byte[3];
        in.get(bytes);
        int val = 0;
        val += (bytes[0] & 0xFF) * 256 * 256;
        val += (bytes[1] & 0xFF) * 256;
        return val += bytes[2] & 0xFF;
    }

    public static int readMediumIntOld(IoBuffer in) {
        IoBuffer buf = IoBuffer.allocate((int)4);
        buf.put((byte)0);
        buf.put(in.get());
        buf.put(in.get());
        buf.put(in.get());
        buf.flip();
        int value = buf.getInt();
        buf.free();
        buf = null;
        return value;
    }

    public static int readMediumInt(IoBuffer in) {
        byte a = in.get();
        byte b = in.get();
        byte c = in.get();
        int val = 0;
        val += (a & 0xFF) << 16;
        val += (b & 0xFF) << 8;
        return val += c & 0xFF;
    }

    public static int readReverseInt(IoBuffer in) {
        byte a = in.get();
        byte b = in.get();
        byte c = in.get();
        byte d = in.get();
        int val = 0;
        val += (d & 0xFF) << 24;
        val += (c & 0xFF) << 16;
        val += (b & 0xFF) << 8;
        return val += a & 0xFF;
    }

    public static void encodeHeaderByte(IoBuffer out, byte headerSize, int channelId) {
        if (channelId <= 63) {
            out.put((byte)((headerSize << 6) + channelId));
        } else if (channelId <= 319) {
            out.put((byte)(headerSize << 6));
            out.put((byte)(channelId - 64));
        } else {
            out.put((byte)(headerSize << 6 | 1));
            out.put((byte)((channelId -= 64) & 0xFF));
            out.put((byte)(channelId >> 8));
        }
    }

    public static int decodeChannelId(int header, int byteCount) {
        if (byteCount == 1) {
            return header & 0x3F;
        }
        if (byteCount == 2) {
            return 64 + (header & 0xFF);
        }
        return 64 + (header >> 8 & 0xFF) + ((header & 0xFF) << 8);
    }

    public static byte decodeHeaderSize(int header, int byteCount) {
        if (byteCount == 1) {
            return (byte)(header >> 6);
        }
        if (byteCount == 2) {
            return (byte)(header >> 14);
        }
        return (byte)(header >> 22);
    }

    public static int getHeaderLength(byte headerSize) {
        switch (headerSize) {
            case 0: {
                return 12;
            }
            case 1: {
                return 8;
            }
            case 2: {
                return 4;
            }
            case 3: {
                return 1;
            }
        }
        return -1;
    }

    public static int compareTimestamps(int a, int b) {
        long diff = RTMPUtils.diffTimestamps(a, b);
        return diff < 0L ? -1 : (diff > 0L ? 1 : 0);
    }

    public static long diffTimestamps(int a, int b) {
        long unsignedA = (long)a & 0xFFFFFFFFL;
        long unsignedB = (long)b & 0xFFFFFFFFL;
        long delta = unsignedA - unsignedB;
        return delta;
    }
}

