/*
 * Decompiled with CFR 0.152.
 */
package org.red5.server.net.rtmp.codec;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.codec.binary.Hex;
import org.apache.mina.core.buffer.IoBuffer;
import org.red5.io.amf3.Input;
import org.red5.io.amf3.Output;
import org.red5.io.object.Deserializer;
import org.red5.io.object.StreamAction;
import org.red5.server.api.IConnection;
import org.red5.server.api.Red5;
import org.red5.server.net.protocol.ProtocolException;
import org.red5.server.net.protocol.RTMPDecodeState;
import org.red5.server.net.rtmp.RTMPConnection;
import org.red5.server.net.rtmp.RTMPUtils;
import org.red5.server.net.rtmp.codec.IEventDecoder;
import org.red5.server.net.rtmp.codec.RTMP;
import org.red5.server.net.rtmp.event.Abort;
import org.red5.server.net.rtmp.event.Aggregate;
import org.red5.server.net.rtmp.event.AudioData;
import org.red5.server.net.rtmp.event.BytesRead;
import org.red5.server.net.rtmp.event.ChunkSize;
import org.red5.server.net.rtmp.event.ClientBW;
import org.red5.server.net.rtmp.event.FlexMessage;
import org.red5.server.net.rtmp.event.IRTMPEvent;
import org.red5.server.net.rtmp.event.Invoke;
import org.red5.server.net.rtmp.event.Notify;
import org.red5.server.net.rtmp.event.Ping;
import org.red5.server.net.rtmp.event.SWFResponse;
import org.red5.server.net.rtmp.event.ServerBW;
import org.red5.server.net.rtmp.event.SetBuffer;
import org.red5.server.net.rtmp.event.Unknown;
import org.red5.server.net.rtmp.event.VideoData;
import org.red5.server.net.rtmp.message.ChunkHeader;
import org.red5.server.net.rtmp.message.Constants;
import org.red5.server.net.rtmp.message.Header;
import org.red5.server.net.rtmp.message.Packet;
import org.red5.server.net.rtmp.message.SharedObjectTypeMapping;
import org.red5.server.service.PendingCall;
import org.red5.server.so.FlexSharedObjectMessage;
import org.red5.server.so.ISharedObjectEvent;
import org.red5.server.so.ISharedObjectMessage;
import org.red5.server.so.SharedObjectMessage;
import org.red5.server.stream.StreamService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RTMPProtocolDecoder
implements Constants,
IEventDecoder {
    protected static final Logger log = LoggerFactory.getLogger(RTMPProtocolDecoder.class);
    protected boolean closeOnHeaderError;
    protected static int MAX_PACKET_SIZE = 0x300000;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Object> decodeBuffer(RTMPConnection conn, IoBuffer buffer) {
        int position = buffer.position();
        if (log.isTraceEnabled()) {
            log.trace("decodeBuffer: {}", (Object)Hex.encodeHexString((byte[])Arrays.copyOfRange(buffer.array(), position, buffer.limit())));
        }
        LinkedList<Object> result = null;
        if (conn != null) {
            log.trace("Decoding for connection - session id: {}", (Object)conn.getSessionId());
            try {
                int remaining;
                result = new LinkedList<Object>();
                RTMPDecodeState state = conn.getDecoderState();
                log.trace("RTMP decode state {}", (Object)state);
                if (!conn.getSessionId().equals(state.getSessionId())) {
                    log.warn("Session decode overlap: {} != {}", (Object)conn.getSessionId(), (Object)state.getSessionId());
                }
                while ((remaining = buffer.remaining()) > 0) {
                    if (!state.canStartDecoding(remaining)) {
                        log.trace("Cannot start decoding");
                    }
                    log.trace("Can start decoding");
                    state.startDecoding();
                    Object decodedObject = this.decode(conn, state, buffer);
                    if (state.hasDecodedObject()) {
                        log.trace("Has decoded object");
                        if (decodedObject != null) {
                            result.add(decodedObject);
                        }
                    } else {
                        if (state.canContinueDecoding()) {
                            log.trace("Can continue decoding");
                            continue;
                        }
                        log.trace("Cannot continue decoding");
                    }
                    if (conn.getStateCode() != 5) continue;
                    log.trace("breaking the loop because connection is disconnected");
                }
            }
            catch (Exception ex) {
                log.warn("Failed to decodeBuffer: pos {}, limit {}, chunk size {}, buffer {}", new Object[]{position, buffer.limit(), conn.getState().getReadChunkSize(), Hex.encodeHexString((byte[])Arrays.copyOfRange(buffer.array(), position, buffer.limit()))});
                log.warn("Closing connection because decoding failed: {}", (Object)conn, (Object)ex);
                buffer.clear();
                conn.close();
            }
            finally {
                if (log.isTraceEnabled()) {
                    log.trace("decodeBuffer - post decode input buffer position: {} remaining: {}", (Object)buffer.position(), (Object)buffer.remaining());
                }
                buffer.compact();
            }
        } else {
            log.error("Decoding buffer failed, no current connection!?");
        }
        return result;
    }

    public Object decode(RTMPConnection conn, RTMPDecodeState state, IoBuffer in) throws ProtocolException {
        if (log.isTraceEnabled()) {
            log.trace("Decoding for {}", (Object)conn.getSessionId());
        }
        try {
            byte connectionState = conn.getStateCode();
            switch (connectionState) {
                case 2: {
                    Packet packet = this.decodePacket(conn, state, in);
                    return packet;
                }
                case 3: 
                case 4: 
                case 5: {
                    in.clear();
                    Object var5_8 = null;
                    return var5_8;
                }
            }
            try {
                throw new IllegalStateException("Invalid RTMP state: " + connectionState);
            }
            catch (ProtocolException pe) {
                throw pe;
            }
            catch (RuntimeException e) {
                throw new ProtocolException("Error during decoding", e);
            }
        }
        finally {
            if (log.isTraceEnabled()) {
                log.trace("Decoding finished for {}", (Object)conn.getSessionId());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Packet decodePacket(RTMPConnection conn, RTMPDecodeState state, IoBuffer in) {
        int channelId;
        int position = in.position();
        if (log.isTraceEnabled()) {
            log.trace("decodePacket: position {}, limit {}", (Object)position, (Object)in.limit());
        }
        RTMP rtmp = conn.getState();
        ChunkHeader chunkHeader = ChunkHeader.read(in);
        int headerLength = RTMPUtils.getHeaderLength(chunkHeader.getFormat());
        if (in.remaining() < (headerLength += chunkHeader.getSize() - 1)) {
            state.bufferDecoding(headerLength - in.remaining());
            in.position(position);
            return null;
        }
        Header header = this.decodeHeader(chunkHeader, state, in, rtmp);
        int n = channelId = header != null ? header.getChannelId() : chunkHeader.getChannelId();
        if (header == null || header.isEmpty()) {
            if (log.isTraceEnabled()) {
                log.trace("Header was null or empty - chh: {}", (Object)chunkHeader);
            }
            in.clear();
            in.compact();
            StreamService.sendNetStreamStatus(conn, "NetStream.Failed", "Bad data on channel: " + channelId, "no-name", "error", conn.getStreamIdForChannelId(channelId));
            conn.closeChannel(channelId);
            return null;
        }
        int size = header.getSize();
        if (size > MAX_PACKET_SIZE) {
            log.warn("Packet size exceeded. size={}, max={}, connId={}", new Object[]{header.getSize(), MAX_PACKET_SIZE, conn.getSessionId()});
            StreamService.sendNetStreamStatus(conn, "NetStream.Failed", "Data exceeded maximum allowed by " + (size - MAX_PACKET_SIZE) + " bytes", "no-name", "error", conn.getStreamIdForChannelId(channelId));
            throw new ProtocolException(String.format("Packet size exceeded. size: %s", header.getSize()));
        }
        int readChunkSize = rtmp.getReadChunkSize();
        rtmp.setLastReadHeader(channelId, header);
        Packet packet = rtmp.getLastReadPacket(channelId);
        if (packet == null) {
            packet = new Packet(header.clone());
            rtmp.setLastReadPacket(channelId, packet);
        }
        IoBuffer buf = packet.getData();
        if (log.isTraceEnabled()) {
            log.trace("Source buffer position: {}, limit: {}, packet-buf.position {}, packet size: {}", new Object[]{in.position(), in.limit(), buf.position(), header.getSize()});
        }
        int length = Math.min(buf.remaining(), readChunkSize);
        if (in.remaining() < length) {
            log.debug("Chunk too small, buffering ({},{})", (Object)in.remaining(), (Object)length);
            state.bufferDecoding(in.position() - position + length);
            in.position(position);
            return null;
        }
        byte[] chunk = Arrays.copyOfRange(in.array(), in.position(), in.position() + length);
        if (log.isTraceEnabled()) {
            log.trace("Read chunkSize: {}, length: {}, chunk: {}", new Object[]{readChunkSize, length, Hex.encodeHexString((byte[])chunk)});
        }
        in.skip(length);
        buf.put(chunk);
        if (buf.hasRemaining()) {
            log.trace("Packet is incomplete ({},{})", (Object)buf.remaining(), (Object)buf.limit());
            return null;
        }
        buf.flip();
        try {
            Header lastReadHeader;
            IRTMPEvent message = this.decodeMessage(conn, packet.getHeader(), buf);
            if (log.isTraceEnabled()) {
                log.trace("Decoded message: {}", (Object)message);
            }
            if ((lastReadHeader = rtmp.getLastReadPacketHeader(channelId)) != null && (message instanceof AudioData || message instanceof VideoData) && RTMPUtils.compareTimestamps(lastReadHeader.getTimer(), packet.getHeader().getTimer()) >= 0) {
                log.trace("Non-monotonically increasing timestamps; type: {}; adjusting to {}; ts: {}; last: {}", new Object[]{header.getDataType(), lastReadHeader.getTimer() + 1, header.getTimer(), lastReadHeader.getTimer()});
                message.setTimestamp(lastReadHeader.getTimer() + 1);
            } else {
                message.setTimestamp(header.getTimer());
            }
            rtmp.setLastReadPacketHeader(channelId, packet.getHeader());
            packet.setMessage(message);
            if (message instanceof ChunkSize) {
                ChunkSize chunkSizeMsg = (ChunkSize)message;
                rtmp.setReadChunkSize(chunkSizeMsg.getSize());
            } else if (message instanceof Abort) {
                log.debug("Abort packet detected");
                Abort abort = (Abort)message;
                packet = null;
                rtmp.setLastReadPacket(abort.getChannelId(), packet);
            }
            Header lastHeader = rtmp.getLastReadHeader(channelId);
            lastHeader.setTimerBase(header.getTimer());
        }
        finally {
            rtmp.setLastReadPacket(channelId, null);
        }
        return packet;
    }

    public Header decodeHeader(ChunkHeader chh, RTMPDecodeState state, IoBuffer in, RTMP rtmp) {
        if (log.isTraceEnabled()) {
            log.trace("decodeHeader - chh: {}", (Object)chh);
        }
        int remaining = in.remaining();
        int channelId = chh.getChannelId();
        byte headerSize = chh.getFormat();
        Header lastHeader = rtmp.getLastReadHeader(channelId);
        if (log.isTraceEnabled()) {
            log.trace("lastHeader: {}", (Object)lastHeader);
        }
        if (headerSize != 0 && lastHeader == null) {
            String detail = String.format("Last header null: %s, channelId %s", new Object[]{Header.HeaderType.values()[headerSize], channelId});
            log.debug("{}", (Object)detail);
            if (this.closeOnHeaderError) {
                throw new ProtocolException(detail);
            }
            return null;
        }
        int headerLength = RTMPUtils.getHeaderLength(headerSize);
        headerLength += chh.getSize() - 1;
        if (log.isTraceEnabled()) {
            log.trace("headerLength: {}", (Object)headerLength);
        }
        if (remaining < headerLength) {
            log.trace("Header too small (hlen: {}), buffering. remaining: {}", (Object)headerLength, (Object)remaining);
            state.bufferDecoding(headerLength);
            return null;
        }
        Header header = new Header();
        header.setChannelId(channelId);
        switch (headerSize) {
            case 0: {
                int timeValue = RTMPUtils.readUnsignedMediumInt(in);
                header.setSize(RTMPUtils.readUnsignedMediumInt(in));
                header.setDataType(in.get());
                header.setStreamId(RTMPUtils.readReverseInt(in));
                if (timeValue == 0xFFFFFF) {
                    timeValue = (int)(in.getUnsignedInt() & Integer.MAX_VALUE);
                    header.setExtendedTimestamp(timeValue);
                }
                header.setTimerBase(timeValue);
                header.setTimerDelta(0);
                break;
            }
            case 1: {
                int timeValue = RTMPUtils.readUnsignedMediumInt(in);
                header.setSize(RTMPUtils.readUnsignedMediumInt(in));
                header.setDataType(in.get());
                header.setStreamId(lastHeader.getStreamId());
                if (timeValue == 0xFFFFFF) {
                    timeValue = (int)(in.getUnsignedInt() & Integer.MAX_VALUE);
                    header.setExtendedTimestamp(timeValue);
                } else if (timeValue == 0 && header.getDataType() == 8) {
                    log.trace("Audio with zero delta; ChannelId: {}; DataType: {}; HeaderSize: {}", new Object[]{header.getChannelId(), header.getDataType(), headerSize});
                }
                header.setTimerBase(lastHeader.getTimerBase());
                header.setTimerDelta(timeValue);
                break;
            }
            case 2: {
                int timeValue = RTMPUtils.readUnsignedMediumInt(in);
                header.setSize(lastHeader.getSize());
                header.setDataType(lastHeader.getDataType());
                header.setStreamId(lastHeader.getStreamId());
                if (timeValue == 0xFFFFFF) {
                    timeValue = (int)(in.getUnsignedInt() & Integer.MAX_VALUE);
                    header.setExtendedTimestamp(timeValue);
                } else if (timeValue == 0 && header.getDataType() == 8) {
                    log.trace("Audio with zero delta; ChannelId: {}; DataType: {}; HeaderSize: {}", new Object[]{header.getChannelId(), header.getDataType(), headerSize});
                }
                header.setTimerBase(lastHeader.getTimerBase());
                header.setTimerDelta(timeValue);
                break;
            }
            case 3: {
                header.setSize(lastHeader.getSize());
                header.setDataType(lastHeader.getDataType());
                header.setStreamId(lastHeader.getStreamId());
                header.setTimerBase(lastHeader.getTimerBase());
                header.setTimerDelta(lastHeader.getTimerDelta());
                if (lastHeader.getExtendedTimestamp() == 0) break;
                int timeValue = (int)(in.getUnsignedInt() & Integer.MAX_VALUE);
                header.setExtendedTimestamp(timeValue);
                log.trace("HEADER_CONTINUE with extended timestamp: {}", (Object)timeValue);
                break;
            }
            default: {
                throw new ProtocolException(String.format("Unexpected header size: %s", headerSize));
            }
        }
        log.trace("CHUNK, D, {}, {}", (Object)header, (Object)headerSize);
        return header;
    }

    public IRTMPEvent decodeMessage(RTMPConnection conn, Header header, IoBuffer in) {
        IRTMPEvent message;
        byte dataType = header.getDataType();
        switch (dataType) {
            case 8: {
                message = this.decodeAudioData(in);
                message.setSourceType((byte)1);
                break;
            }
            case 9: {
                message = this.decodeVideoData(in);
                message.setSourceType((byte)1);
                break;
            }
            case 22: {
                message = this.decodeAggregate(in);
                break;
            }
            case 16: {
                message = this.decodeFlexSharedObject(in);
                break;
            }
            case 19: {
                message = this.decodeSharedObject(in);
                break;
            }
            case 17: {
                message = this.decodeFlexMessage(in);
                break;
            }
            case 20: {
                message = this.decodeAction(conn.getEncoding(), in, header);
                break;
            }
            case 15: {
                if (log.isTraceEnabled()) {
                    log.trace("Decoding flex stream send on stream id: {}", (Object)header.getStreamId());
                }
                in.get();
                message = this.decodeStreamData(in.slice());
                break;
            }
            case 18: {
                if (log.isTraceEnabled()) {
                    log.trace("Decoding notify on stream id: {}", (Object)header.getStreamId());
                }
                if (header.getStreamId().doubleValue() != 0.0) {
                    message = this.decodeStreamData(in);
                    break;
                }
                message = this.decodeAction(conn.getEncoding(), in, header);
                break;
            }
            case 4: {
                message = this.decodePing(in);
                break;
            }
            case 3: {
                message = this.decodeBytesRead(in);
                break;
            }
            case 1: {
                message = this.decodeChunkSize(in);
                break;
            }
            case 5: {
                message = this.decodeServerBW(in);
                break;
            }
            case 6: {
                message = this.decodeClientBW(in);
                break;
            }
            case 2: {
                message = this.decodeAbort(in);
                break;
            }
            default: {
                log.warn("Unknown object type: {}", (Object)dataType);
                message = this.decodeUnknown(dataType, in);
            }
        }
        message.setHeader(header);
        return message;
    }

    public IRTMPEvent decodeAbort(IoBuffer in) {
        return new Abort(in.getInt());
    }

    private IRTMPEvent decodeServerBW(IoBuffer in) {
        return new ServerBW(in.getInt());
    }

    private IRTMPEvent decodeClientBW(IoBuffer in) {
        return new ClientBW(in.getInt(), in.get());
    }

    @Override
    public Unknown decodeUnknown(byte dataType, IoBuffer in) {
        if (log.isDebugEnabled()) {
            log.debug("decodeUnknown: {}", (Object)dataType);
        }
        return new Unknown(dataType, in);
    }

    @Override
    public Aggregate decodeAggregate(IoBuffer in) {
        return new Aggregate(in);
    }

    @Override
    public ChunkSize decodeChunkSize(IoBuffer in) {
        int chunkSize = in.getInt();
        log.debug("Decoded chunk size: {}", (Object)chunkSize);
        return new ChunkSize(chunkSize);
    }

    @Override
    public ISharedObjectMessage decodeFlexSharedObject(IoBuffer in) {
        org.red5.io.amf.Input input;
        byte encoding = in.get();
        if (encoding == 0) {
            input = new org.red5.io.amf.Input(in);
        } else if (encoding == 3) {
            input = new Input(in);
        } else {
            throw new RuntimeException("Unknown SO encoding: " + encoding);
        }
        String name = input.getString();
        int version = in.getInt();
        boolean persistent = in.getInt() == 2;
        in.skip(4);
        FlexSharedObjectMessage so = new FlexSharedObjectMessage(null, name, version, persistent);
        this.doDecodeSharedObject(so, in, (org.red5.io.object.Input)input);
        return so;
    }

    @Override
    public ISharedObjectMessage decodeSharedObject(IoBuffer in) {
        org.red5.io.amf.Input input = new org.red5.io.amf.Input(in);
        String name = input.getString();
        int version = in.getInt();
        boolean persistent = in.getInt() == 2;
        in.skip(4);
        SharedObjectMessage so = new SharedObjectMessage(null, name, version, persistent);
        this.doDecodeSharedObject(so, in, (org.red5.io.object.Input)input);
        return so;
    }

    protected void doDecodeSharedObject(SharedObjectMessage so, IoBuffer in, org.red5.io.object.Input input) {
        Input amf3Input = new Input(in);
        while (in.hasRemaining()) {
            ISharedObjectEvent.Type type = SharedObjectTypeMapping.toType(in.get());
            if (type == null) {
                in.skip(in.remaining());
                return;
            }
            String key = null;
            Object value = null;
            int length = in.getInt();
            if (type == ISharedObjectEvent.Type.CLIENT_STATUS) {
                key = input.getString();
                value = input.getString();
            } else if (type == ISharedObjectEvent.Type.CLIENT_UPDATE_DATA) {
                key = null;
                HashMap<String, Object> map = new HashMap<String, Object>();
                int start = in.position();
                while (in.position() - start < length) {
                    String tmp = input.getString();
                    map.put(tmp, Deserializer.deserialize((org.red5.io.object.Input)input, Object.class));
                }
                value = map;
            } else if (type != ISharedObjectEvent.Type.SERVER_SEND_MESSAGE && type != ISharedObjectEvent.Type.CLIENT_SEND_MESSAGE) {
                if (length > 0 && length > (key = input.getString()).length() + 2) {
                    byte objType = in.get();
                    in.position(in.position() - 1);
                    Object propertyInput = objType == 17 && !(input instanceof Input) ? amf3Input : input;
                    value = Deserializer.deserialize((org.red5.io.object.Input)propertyInput, Object.class);
                }
            } else {
                int start = in.position();
                key = (String)Deserializer.deserialize((org.red5.io.object.Input)input, String.class);
                LinkedList<Object> list = new LinkedList<Object>();
                while (in.position() - start < length) {
                    byte objType = in.get();
                    in.position(in.position() - 1);
                    Object propertyInput = objType == 17 && !(input instanceof Input) ? amf3Input : input;
                    Object tmp = Deserializer.deserialize((org.red5.io.object.Input)propertyInput, Object.class);
                    list.add(tmp);
                }
                value = list;
            }
            so.addEvent(type, key, value);
        }
    }

    private Invoke decodeAction(IConnection.Encoding encoding, IoBuffer in, Header header) {
        String serviceMethod;
        String serviceName;
        org.red5.io.amf.Input input;
        in.mark();
        byte tmp = in.get();
        in.reset();
        if (encoding == IConnection.Encoding.AMF3 && tmp == 17) {
            input = new Input(in);
            ((Input)input).enforceAMF3();
        } else {
            input = new org.red5.io.amf.Input(in);
        }
        String action = (String)Deserializer.deserialize((org.red5.io.object.Input)input, String.class);
        if (action == null) {
            throw new RuntimeException("Action was null");
        }
        if (log.isTraceEnabled()) {
            log.trace("Action: {}", (Object)action);
        }
        Invoke invoke = new Invoke();
        invoke.setTransactionId(((Number)Deserializer.deserialize((org.red5.io.object.Input)input, Number.class)).intValue());
        input.reset();
        Object[] params = in.hasRemaining() ? this.handleParameters(in, invoke, (org.red5.io.object.Input)input) : new Object[]{};
        int dotIndex = action.lastIndexOf(46);
        String string = serviceName = dotIndex == -1 ? null : action.substring(0, dotIndex);
        if (serviceName != null && (serviceName.startsWith("@") || serviceName.startsWith("|"))) {
            serviceName = serviceName.substring(1);
        }
        String string2 = serviceMethod = dotIndex == -1 ? action : action.substring(dotIndex + 1, action.length());
        if (serviceMethod.startsWith("@") || serviceMethod.startsWith("|")) {
            serviceMethod = serviceMethod.substring(1);
        }
        PendingCall call = new PendingCall(serviceName, serviceMethod, params);
        invoke.setCall(call);
        return invoke;
    }

    @Override
    public Ping decodePing(IoBuffer in) {
        Ping ping = null;
        if (log.isTraceEnabled()) {
            String hexDump = in.getHexDump();
            log.trace("Ping dump: {}", (Object)hexDump);
        }
        short type = in.getShort();
        switch (type) {
            case 3: {
                ping = new SetBuffer(in.getInt(), in.getInt());
                break;
            }
            case 26: {
                ping = new Ping(type);
                break;
            }
            case 27: {
                byte[] bytes = new byte[42];
                in.get(bytes);
                ping = new SWFResponse(bytes);
                break;
            }
            default: {
                ping = new Ping(type, in.getInt());
            }
        }
        return ping;
    }

    @Override
    public BytesRead decodeBytesRead(IoBuffer in) {
        return new BytesRead(in.getInt());
    }

    @Override
    public AudioData decodeAudioData(IoBuffer in) {
        return new AudioData(in.asReadOnlyBuffer());
    }

    @Override
    public VideoData decodeVideoData(IoBuffer in) {
        return new VideoData(in.asReadOnlyBuffer());
    }

    public Notify decodeStreamData(IoBuffer in) {
        if (log.isDebugEnabled()) {
            log.debug("decodeStreamData");
        }
        Notify ret = null;
        IConnection.Encoding encoding = ((RTMPConnection)Red5.getConnectionLocal()).getEncoding();
        log.trace("Encoding: {}", (Object)encoding);
        in.mark();
        org.red5.io.amf.Input input = new org.red5.io.amf.Input(in);
        if (encoding == IConnection.Encoding.AMF3) {
            log.trace("Client indicates its using AMF3");
        }
        byte dataType = input.readDataType();
        log.debug("Data type: {}", (Object)dataType);
        if (dataType == 4) {
            String action = input.readString();
            if ("@setDataFrame".equals(action)) {
                byte dataType2 = input.readDataType();
                log.debug("Dataframe method type: {}", (Object)dataType2);
                String onCueOrOnMeta = input.readString();
                byte object = input.readDataType();
                if (object == -17) {
                    log.trace("Switching decoding to AMF3");
                    input = new Input(in);
                    ((Input)input).enforceAMF3();
                    object = input.readDataType();
                }
                log.debug("Dataframe params type: {}", (Object)object);
                HashMap<String, String> params = Collections.EMPTY_MAP;
                if (object == 7) {
                    params = (Map)input.readMap();
                } else if (object == 6) {
                    params = (Map)input.readArray(Object[].class);
                } else if (object == 4) {
                    String str = input.readString();
                    log.debug("String params: {}", (Object)str);
                    params = new HashMap<String, String>();
                    params.put("0", str);
                } else {
                    try {
                        params = (Map)input.readObject();
                    }
                    catch (Exception e) {
                        log.warn("Dataframe decode error", (Throwable)e);
                        params = Collections.EMPTY_MAP;
                    }
                }
                if (log.isDebugEnabled()) {
                    log.debug("Dataframe: {} params: {}", (Object)onCueOrOnMeta, (Object)((Object)params).toString());
                }
                IoBuffer buf = IoBuffer.allocate((int)64);
                buf.setAutoExpand(true);
                org.red5.io.amf.Output out = new org.red5.io.amf.Output(buf);
                out.writeString(onCueOrOnMeta);
                out.writeMap(params);
                buf.flip();
                ret = new Notify(buf, onCueOrOnMeta);
            } else {
                byte object = input.readDataType();
                if (object == -17) {
                    log.trace("Switching decoding to AMF3");
                    input = new Input(in);
                    ((Input)input).enforceAMF3();
                    object = input.readDataType();
                }
                log.info("Stream send: {}", (Object)action);
                HashMap<String, String> params = Collections.EMPTY_MAP;
                log.debug("Params type: {}", (Object)object);
                if (object == 7) {
                    params = (Map)input.readMap();
                    if (log.isDebugEnabled()) {
                        log.debug("Map params: {}", (Object)((Object)params).toString());
                    }
                } else if (object == 6) {
                    params = (Map)input.readArray(Object[].class);
                    if (log.isDebugEnabled()) {
                        log.debug("Array params: {}", (Object)params);
                    }
                } else if (object == 4) {
                    String str = input.readString();
                    if (log.isDebugEnabled()) {
                        log.debug("String params: {}", (Object)str);
                    }
                    params = new HashMap<String, String>();
                    params.put("0", str);
                } else if (object == 9) {
                    params = (Map)input.readObject();
                    if (log.isDebugEnabled()) {
                        log.debug("Object params: {}", params);
                    }
                } else if (log.isDebugEnabled()) {
                    log.debug("Stream send did not provide a parameter map");
                }
                if ("onFI".equals(action)) {
                    IoBuffer buf = IoBuffer.allocate((int)64);
                    buf.setAutoExpand(true);
                    Object out = null;
                    out = encoding == IConnection.Encoding.AMF3 ? new Output(buf) : new org.red5.io.amf.Output(buf);
                    out.writeString(action);
                    out.writeMap(params);
                    buf.flip();
                    ret = new Notify(buf, action);
                } else {
                    in.reset();
                    ret = new Notify(in.asReadOnlyBuffer(), action);
                }
            }
        } else {
            in.reset();
            ret = new Notify(in.asReadOnlyBuffer());
        }
        return ret;
    }

    @Override
    public FlexMessage decodeFlexMessage(IoBuffer in) {
        int dotIndex;
        if (log.isDebugEnabled()) {
            log.debug("decodeFlexMessage");
        }
        byte flexByte = in.get();
        log.trace("Flex byte: {}", (Object)flexByte);
        Input.RefStorage refStorage = new Input.RefStorage();
        org.red5.io.amf.Input input = new org.red5.io.amf.Input(in);
        String action = (String)Deserializer.deserialize((org.red5.io.object.Input)input, String.class);
        int transactionId = ((Number)Deserializer.deserialize((org.red5.io.object.Input)input, Number.class)).intValue();
        FlexMessage msg = new FlexMessage();
        msg.setTransactionId(transactionId);
        Object[] params = new Object[]{};
        if (in.hasRemaining()) {
            ArrayList<Object> paramList = new ArrayList<Object>();
            Object obj = Deserializer.deserialize((org.red5.io.object.Input)input, Object.class);
            if (obj != null) {
                paramList.add(obj);
            }
            while (in.hasRemaining()) {
                byte objectEncodingType = in.get();
                log.debug("Object encoding: {}", (Object)objectEncodingType);
                in.position(in.position() - 1);
                switch (objectEncodingType) {
                    case 15: 
                    case 16: 
                    case 17: {
                        input = new Input(in, refStorage);
                        ((Input)input).enforceAMF3();
                        break;
                    }
                    case 13: 
                    case 14: {
                        input = new Input(in, refStorage);
                        break;
                    }
                    default: {
                        input = new org.red5.io.amf.Input(in);
                    }
                }
                paramList.add(Deserializer.deserialize((org.red5.io.object.Input)input, Object.class));
            }
            params = paramList.toArray();
            if (log.isTraceEnabled()) {
                log.trace("Parameter count: {}", (Object)paramList.size());
                for (int i = 0; i < params.length; ++i) {
                    log.trace(" > {}: {}", (Object)i, params[i]);
                }
            }
        }
        String serviceName = (dotIndex = action.lastIndexOf(46)) == -1 ? null : action.substring(0, dotIndex);
        String serviceMethod = dotIndex == -1 ? action : action.substring(dotIndex + 1, action.length());
        log.debug("Service name: {} method: {}", (Object)serviceName, (Object)serviceMethod);
        PendingCall call = new PendingCall(serviceName, serviceMethod, params);
        msg.setCall(call);
        return msg;
    }

    public void setCloseOnHeaderError(boolean closeOnHeaderError) {
        this.closeOnHeaderError = closeOnHeaderError;
    }

    private boolean isStreamCommand(String action) {
        switch (StreamAction.getEnum((String)action)) {
            case CREATE_STREAM: 
            case DELETE_STREAM: 
            case RELEASE_STREAM: 
            case PUBLISH: 
            case PLAY: 
            case PLAY2: 
            case SEEK: 
            case PAUSE: 
            case PAUSE_RAW: 
            case CLOSE_STREAM: 
            case RECEIVE_VIDEO: 
            case RECEIVE_AUDIO: {
                return true;
            }
        }
        log.debug("Stream action {} is not a recognized command", (Object)action);
        return false;
    }

    private Object[] handleParameters(IoBuffer in, Notify notify, org.red5.io.object.Input input) {
        Object[] params = new Object[]{};
        ArrayList<Object> paramList = new ArrayList<Object>();
        Object obj = Deserializer.deserialize((org.red5.io.object.Input)input, Object.class);
        if (obj instanceof Map) {
            Map connParams = (Map)obj;
            notify.setConnectionParams(connParams);
        } else if (obj != null) {
            paramList.add(obj);
        }
        while (in.hasRemaining()) {
            paramList.add(Deserializer.deserialize((org.red5.io.object.Input)input, Object.class));
        }
        params = paramList.toArray();
        if (log.isDebugEnabled()) {
            log.debug("Num params: {}", (Object)paramList.size());
            for (int i = 0; i < params.length; ++i) {
                log.debug(" > {}: {}", (Object)i, params[i]);
            }
        }
        return params;
    }

    public static void setMaxPacketSize(int maxPacketSize) {
        MAX_PACKET_SIZE = maxPacketSize;
        if (log.isDebugEnabled()) {
            log.debug("Max packet size: {}", (Object)MAX_PACKET_SIZE);
        }
    }
}

