/*
 * Decompiled with CFR 0.152.
 */
package org.red5.server.net.rtmpt;

import java.util.concurrent.atomic.AtomicLong;
import javax.servlet.http.HttpServletRequest;
import org.apache.mina.core.buffer.IoBuffer;
import org.apache.mina.core.session.DummySession;
import org.apache.mina.core.session.IoSession;
import org.red5.logging.Red5LoggerFactory;
import org.red5.server.net.rtmp.codec.RTMP;
import org.red5.server.net.rtmp.message.Packet;
import org.red5.server.net.rtmpt.BaseRTMPTConnection;
import org.red5.server.net.rtmpt.RTMPTServlet;
import org.red5.server.net.servlet.ServletUtils;
import org.slf4j.Logger;

public class RTMPTConnection
extends BaseRTMPTConnection {
    private static final Logger log = Red5LoggerFactory.getLogger(RTMPTConnection.class);
    private static final long INCREASE_POLLING_DELAY_COUNT = 10L;
    private static final byte INITIAL_POLLING_DELAY = 0;
    private static final byte MAX_POLLING_DELAY = 32;
    private volatile byte pollingDelay = 0;
    private volatile long noPendingMessages;
    private transient RTMPTServlet servlet;
    private long tsLastDataReceived = 0L;
    private AtomicLong lastBytesRead = new AtomicLong(0L);
    private AtomicLong lastBytesWritten = new AtomicLong(0L);
    private transient IoSession ioSession = new DummySession();

    RTMPTConnection() {
        super("polling");
        this.ioSession.setAttribute((Object)"rtmp.sessionid", (Object)this.sessionId);
    }

    @Override
    public IoSession getIoSession() {
        return this.ioSession;
    }

    @Override
    protected void onInactive() {
        this.close();
    }

    @Override
    public void close() {
        if (log.isDebugEnabled()) {
            log.debug("close {} state: {}", (Object)this.getSessionId(), (Object)RTMP.states[this.state.getState()]);
        }
        if (!this.isClosing()) {
            if (!this.pendingOutMessages.isEmpty()) {
                try {
                    log.debug("Going to sleep to allow pending queue a chance to clear");
                    Thread.sleep(256L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                    Thread.currentThread().interrupt();
                }
            }
            super.close();
            if (this.servlet != null) {
                this.servlet = null;
            }
            if (this.handler != null) {
                this.handler.connectionClosed(this);
            }
        }
    }

    public void handleMessageReceived(Object message) {
        if (message instanceof Packet) {
            this.handleMessageReceived((Packet)message);
        } else {
            log.warn("Incoming type: {} cannot be handled here", (Object)message.getClass().getName());
        }
    }

    @Override
    public boolean isIdle() {
        boolean inActivityExceeded = false;
        long lastTS = this.getLastDataReceived();
        long now = System.currentTimeMillis();
        long tsDelta = now - lastTS;
        if (lastTS > 0L && tsDelta > (long)this.maxInactivity) {
            inActivityExceeded = true;
        }
        return inActivityExceeded || this.isReaderIdle() && this.isWriterIdle();
    }

    @Override
    public boolean isReaderIdle() {
        long previousBytes;
        long currentBytes = this.getReadBytes();
        if (currentBytes > (previousBytes = this.lastBytesRead.get())) {
            log.trace("Client (read) is not idle");
            if (this.lastBytesRead.compareAndSet(previousBytes, currentBytes)) {
                return false;
            }
        }
        return true;
    }

    @Override
    public boolean isWriterIdle() {
        long previousBytes;
        long currentBytes = this.getWrittenBytes();
        if (currentBytes > (previousBytes = this.lastBytesWritten.get())) {
            log.trace("Client (write) is not idle");
            if (this.lastBytesWritten.compareAndSet(previousBytes, currentBytes)) {
                return false;
            }
        }
        return true;
    }

    public void setRemoteAddress(String remoteAddress) {
        this.remoteAddress = remoteAddress;
    }

    public void setRemotePort(int remotePort) {
        this.remotePort = remotePort;
    }

    protected void setServlet(RTMPTServlet servlet) {
        this.servlet = servlet;
    }

    public void setServletRequest(HttpServletRequest request) {
        this.host = request.getLocalPort() == 80 ? request.getLocalName() : String.format("%s:%d", request.getLocalName(), request.getLocalPort());
        this.remoteAddress = request.getRemoteAddr();
        this.remoteAddresses = ServletUtils.getRemoteAddresses(request);
        this.remotePort = request.getRemotePort();
    }

    public byte getPollingDelay() {
        if (log.isTraceEnabled()) {
            log.trace("getPollingDelay {}", (Object)this.pollingDelay);
            log.trace("Polling delay: {} loops without messages: {}", (Object)this.pollingDelay, (Object)this.noPendingMessages);
        }
        return (byte)(this.pollingDelay + 1);
    }

    @Override
    public IoBuffer getPendingMessages(int targetSize) {
        if (log.isTraceEnabled()) {
            log.trace("Pending messages out: {}", (Object)this.pendingOutMessages.size());
        }
        if (!this.pendingOutMessages.isEmpty()) {
            this.pollingDelay = 0;
            this.noPendingMessages = 0L;
        } else {
            ++this.noPendingMessages;
            if (this.noPendingMessages > 10L) {
                if (this.pollingDelay == 0) {
                    this.pollingDelay = 1;
                }
                this.pollingDelay = (byte)(this.pollingDelay * 2);
                if (this.pollingDelay > 32) {
                    this.pollingDelay = (byte)32;
                }
            }
        }
        return this.foldPendingMessages(targetSize);
    }

    public void dataReceived() {
        this.tsLastDataReceived = System.currentTimeMillis();
    }

    public Long getLastDataReceived() {
        return this.tsLastDataReceived;
    }

    @Override
    public String getProtocol() {
        return "rtmpt";
    }
}

