/*
 * Decompiled with CFR 0.152.
 */
package org.red5.server.service;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.util.UUID;
import javax.management.JMX;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.servlet.ServletException;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.HttpHostConnectException;
import org.apache.http.util.EntityUtils;
import org.red5.compatibility.flex.messaging.messages.AcknowledgeMessage;
import org.red5.compatibility.flex.messaging.messages.AsyncMessage;
import org.red5.logging.Red5LoggerFactory;
import org.red5.server.api.IConnection;
import org.red5.server.api.Red5;
import org.red5.server.api.service.ServiceUtils;
import org.red5.server.jmx.mxbeans.LoaderMXBean;
import org.red5.server.util.FileUtil;
import org.red5.server.util.HttpConnectionUtil;
import org.slf4j.Logger;

public final class Installer {
    private static Logger log = Red5LoggerFactory.getLogger(Installer.class);
    private String applicationRepositoryUrl;

    public Installer() {
        log.info("Installer service created");
    }

    public String getApplicationRepositoryUrl() {
        return this.applicationRepositoryUrl;
    }

    public void setApplicationRepositoryUrl(String applicationRepositoryUrl) {
        this.applicationRepositoryUrl = applicationRepositoryUrl;
    }

    public LoaderMXBean getLoader() {
        MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
        LoaderMXBean proxy = null;
        try {
            ObjectName oName = new ObjectName("org.red5.server:type=TomcatLoader");
            if (mbs.isRegistered(oName)) {
                proxy = JMX.newMXBeanProxy(mbs, oName, LoaderMXBean.class, true);
                log.debug("Loader was found");
            } else {
                log.warn("Loader not found");
            }
        }
        catch (Exception e) {
            log.error("Exception getting loader", (Throwable)e);
        }
        return proxy;
    }

    public AsyncMessage getApplicationList() {
        AcknowledgeMessage result;
        block10: {
            result = new AcknowledgeMessage();
            HttpClient client = HttpConnectionUtil.getClient();
            HttpGet method = null;
            try {
                method = new HttpGet(this.applicationRepositoryUrl + "registry.xml");
                HttpResponse response = client.execute((HttpUriRequest)method);
                int code = response.getStatusLine().getStatusCode();
                log.debug("HTTP response code: {}", (Object)code);
                if (code == 200) {
                    HttpEntity entity = response.getEntity();
                    if (entity != null) {
                        String responseText = EntityUtils.toString((HttpEntity)entity);
                        log.debug("Response: {}", (Object)responseText);
                        result.body = responseText;
                        IConnection conn = Red5.getConnectionLocal();
                        result.clientId = conn.getClient().getId();
                        result.messageId = UUID.randomUUID().toString();
                        result.timestamp = System.currentTimeMillis();
                        String javaVersion = System.getProperty("java.version").substring(0, 3);
                        log.info("JRE version detected: {}", (Object)javaVersion);
                        if (Double.valueOf(javaVersion) > 1.5) {
                            javaVersion = "1.6";
                        }
                        if (!ServiceUtils.invokeOnConnection(conn, "onJavaVersion", new Object[]{javaVersion})) {
                            log.warn("Client call to onJavaVersion failed");
                        }
                    }
                } else {
                    log.warn("Service returned an error");
                    if (log.isDebugEnabled()) {
                        HttpConnectionUtil.handleError(response);
                    }
                }
            }
            catch (HttpHostConnectException he) {
                log.error("Http error connecting to {}", (Object)this.applicationRepositoryUrl, (Object)he);
                if (method != null) {
                    method.abort();
                }
            }
            catch (IOException ioe) {
                log.error("Unable to connect to {}", (Object)this.applicationRepositoryUrl, (Object)ioe);
                if (method == null) break block10;
                method.abort();
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean install(String applicationWarName) {
        IConnection conn = Red5.getConnectionLocal();
        boolean result = false;
        String application = applicationWarName.substring(0, applicationWarName.indexOf(45));
        log.debug("Application name: {}", (Object)application);
        String webappsDir = System.getProperty("red5.webapp.root");
        log.debug("Webapp folder: {}", (Object)webappsDir);
        String contextPath = "/" + application;
        String contextDir = webappsDir + contextPath;
        File appDir = new File(webappsDir, application);
        if (appDir.exists()) {
            if (appDir.isDirectory()) {
                log.debug("Application directory exists");
            } else {
                log.warn("Application destination is not a directory");
            }
            ServiceUtils.invokeOnConnection(conn, "onAlert", new Object[]{String.format("Application %s already installed, please un-install before attempting another install", application)});
        } else {
            File[] files;
            String srcDir = System.getProperty("java.io.tmpdir");
            log.debug("Source directory: {}", (Object)srcDir);
            File dir = new File(srcDir);
            if (!dir.exists()) {
                log.warn("Source directory not found");
                dir = new File(System.getProperty("red5.root"), "/webapps/installer/WEB-INF/cache");
                if (!dir.exists() && dir.mkdirs()) {
                    log.info("Installer cache directory created");
                }
            } else if (!dir.isDirectory()) {
                log.warn("Source directory is not a directory");
            }
            for (File f : files = dir.listFiles()) {
                String fileName = f.getName();
                if (!fileName.equals(applicationWarName)) continue;
                log.debug("File found matching application name");
                result = true;
                break;
            }
            dir = null;
            if (!result) {
                HttpClient client = HttpConnectionUtil.getClient();
                HttpGet method = null;
                FileOutputStream fos = null;
                try {
                    HttpEntity entity;
                    method = new HttpGet(this.applicationRepositoryUrl + applicationWarName);
                    method.addHeader("Accept-Encoding", "identity");
                    HttpResponse response = client.execute((HttpUriRequest)method);
                    int code = response.getStatusLine().getStatusCode();
                    log.debug("HTTP response code: {}", (Object)code);
                    if (code == 200 && (entity = response.getEntity()) != null) {
                        fos = new FileOutputStream(srcDir + "/" + applicationWarName);
                        log.debug("Writing response to {}/{}", (Object)srcDir, (Object)applicationWarName);
                        byte[] buf = EntityUtils.toByteArray((HttpEntity)entity);
                        fos.write(buf);
                        fos.flush();
                        result = true;
                    }
                }
                catch (HttpHostConnectException he) {
                    log.error("Http error connecting to {}", (Object)this.applicationRepositoryUrl, (Object)he);
                    if (method != null) {
                        method.abort();
                    }
                }
                catch (IOException ioe) {
                    log.error("Unable to connect to {}", (Object)this.applicationRepositoryUrl, (Object)ioe);
                    if (method != null) {
                        method.abort();
                    }
                }
                finally {
                    if (fos != null) {
                        try {
                            fos.close();
                        }
                        catch (IOException he) {}
                    }
                }
            }
            if (result) {
                LoaderMXBean loader = this.getLoader();
                if (loader != null) {
                    FileUtil.unzip(srcDir + "/" + applicationWarName, contextDir);
                    try {
                        loader.startWebApplication(application);
                    }
                    catch (ServletException e) {
                        log.error("Unexpected error while staring web application...", (Throwable)e);
                    }
                } else {
                    try {
                        FileUtil.moveFile(srcDir + "/" + applicationWarName, webappsDir + "/" + application + ".war");
                        ServiceUtils.invokeOnConnection(conn, "onAlert", new Object[]{String.format("Application %s will not be available until container is restarted", application)});
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
            }
            ServiceUtils.invokeOnConnection(conn, "onAlert", new Object[]{String.format("Application %s was %s", application, result ? "installed" : "not installed")});
        }
        appDir = null;
        return result;
    }

    public boolean uninstall(String applicationName) {
        ServiceUtils.invokeOnConnection(Red5.getConnectionLocal(), "onAlert", new Object[]{"Uninstall function not available"});
        return false;
    }
}

