/*
 * Decompiled with CFR 0.152.
 */
package org.red5.server.so;

import java.lang.reflect.Method;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.locks.ReentrantLock;
import org.red5.server.BaseConnection;
import org.red5.server.api.IAttributeStore;
import org.red5.server.api.IContext;
import org.red5.server.api.event.IEvent;
import org.red5.server.api.event.IEventListener;
import org.red5.server.api.persistence.IPersistenceStore;
import org.red5.server.api.scheduling.IScheduledJob;
import org.red5.server.api.scheduling.ISchedulingService;
import org.red5.server.api.scope.IScope;
import org.red5.server.api.scope.ScopeType;
import org.red5.server.api.so.ISharedObject;
import org.red5.server.api.so.ISharedObjectBase;
import org.red5.server.api.so.ISharedObjectListener;
import org.red5.server.api.so.ISharedObjectSecurity;
import org.red5.server.api.so.ISharedObjectSecurityService;
import org.red5.server.api.statistics.ISharedObjectStatistics;
import org.red5.server.net.rtmp.status.StatusCodes;
import org.red5.server.scheduling.QuartzSchedulingService;
import org.red5.server.scope.BasicScope;
import org.red5.server.service.ReflectionUtils;
import org.red5.server.so.ISharedObjectEvent;
import org.red5.server.so.ISharedObjectMessage;
import org.red5.server.so.SharedObject;
import org.red5.server.util.ScopeUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SharedObjectScope
extends BasicScope
implements ISharedObject,
StatusCodes {
    private Logger log = LoggerFactory.getLogger(SharedObjectScope.class);
    private final transient ReentrantLock lock = new ReentrantLock();
    private transient CopyOnWriteArraySet<ISharedObjectListener> serverListeners = new CopyOnWriteArraySet();
    private transient ConcurrentMap<String, Object> handlers = new ConcurrentHashMap<String, Object>(1, 0.9f, 1);
    private transient CopyOnWriteArraySet<ISharedObjectSecurity> securityHandlers = new CopyOnWriteArraySet();
    protected volatile SharedObject so;
    private long lingerPeriod = 5000L;
    private String lingerJobName;

    public SharedObjectScope(IScope parent, String name, boolean persistent, IPersistenceStore store) {
        super(parent, ScopeType.SHARED_OBJECT, name, persistent);
        Object path = parent.getContextPath();
        if ("".equals(path) || ((String)path).charAt(0) != '/') {
            path = "/" + (String)path;
        }
        this.log.trace("Path+name: {}/{}", path, (Object)name);
        this.so = (SharedObject)store.load(ScopeType.SHARED_OBJECT + (String)path + "/" + name);
        if (this.so == null) {
            this.so = new SharedObject(name, (String)path, persistent, store);
            store.save(this.so);
        } else {
            this.so.setPath((String)path);
        }
    }

    @Override
    public void registerSharedObjectSecurity(ISharedObjectSecurity handler) {
        this.securityHandlers.add(handler);
    }

    @Override
    public void unregisterSharedObjectSecurity(ISharedObjectSecurity handler) {
        this.securityHandlers.remove(handler);
    }

    @Override
    public Set<ISharedObjectSecurity> getSharedObjectSecurity() {
        return Collections.unmodifiableSet(this.securityHandlers);
    }

    @Override
    public IPersistenceStore getStore() {
        return this.so.getStore();
    }

    @Override
    public String getName() {
        return this.so.getName();
    }

    @Override
    public String getPath() {
        return this.so.getPath();
    }

    public void setPath(String path) {
        this.so.setPath(path);
    }

    @Override
    public boolean isPersistent() {
        return this.so.isPersistent();
    }

    @Override
    public void beginUpdate() {
        if (this.log.isTraceEnabled()) {
            this.log.trace("beginUpdate - locked: {} owner: {}", (Object)this.lock.isLocked(), (Object)this.lock.isHeldByCurrentThread());
        }
        this.lock.lock();
        this.so.beginUpdate();
    }

    @Override
    public void beginUpdate(IEventListener listener) {
        if (this.log.isTraceEnabled()) {
            this.log.trace("beginUpdate with listener - locked: {} owner: {} listener: {}", new Object[]{this.lock.isLocked(), this.lock.isHeldByCurrentThread(), listener});
        }
        this.lock.lock();
        this.so.beginUpdate(listener);
    }

    @Override
    public void endUpdate() {
        if (this.log.isTraceEnabled()) {
            this.log.trace("endUpdate - locked: {} owner: {}", (Object)this.lock.isLocked(), (Object)this.lock.isHeldByCurrentThread());
        }
        try {
            this.so.endUpdate();
        }
        catch (Exception ex) {
            this.log.warn("Exception on so.endUpdate", (Throwable)ex);
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public int getVersion() {
        return this.so.getVersion();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void sendMessage(String handler, List<?> arguments) {
        if (this.so != null) {
            String serviceMethod;
            String serviceName;
            this.beginUpdate();
            try {
                this.so.sendMessage(handler, arguments);
            }
            catch (Exception ex) {
                this.log.warn("Exception on so.sendMessage", (Throwable)ex);
            }
            finally {
                this.endUpdate();
            }
            int dotPos = handler.lastIndexOf(46);
            if (dotPos != -1) {
                serviceName = handler.substring(0, dotPos);
                serviceMethod = handler.substring(dotPos + 1);
            } else {
                serviceName = "";
                serviceMethod = handler;
            }
            Object soHandler = this.getServiceHandler(serviceName);
            if (soHandler == null && this.hasParent()) {
                IContext context = this.getParent().getContext();
                String serviceId = null;
                try {
                    serviceId = this.so.getName() + "." + serviceName + ".soservice";
                    if (context.hasBean(serviceId)) {
                        soHandler = context.getBean(serviceId);
                    }
                }
                catch (Exception err) {
                    this.log.debug("No such bean: {}", (Object)serviceId);
                }
            }
            if (soHandler != null) {
                Object[] methodResult = ReflectionUtils.findMethodWithExactParameters(soHandler, serviceMethod, arguments);
                if (methodResult.length == 0 || methodResult[0] == null) {
                    methodResult = ReflectionUtils.findMethodWithListParameters(soHandler, serviceMethod, arguments);
                }
                if (methodResult.length > 0 && methodResult[0] != null) {
                    Method method = (Method)methodResult[0];
                    Object[] params = (Object[])methodResult[1];
                    try {
                        method.invoke(soHandler, params);
                    }
                    catch (Exception err) {
                        this.log.error("Error while invoking method {} on shared object handler {}", (Object)new Object[]{serviceMethod, handler}, (Object)err);
                    }
                }
            }
            for (ISharedObjectListener listener : this.serverListeners) {
                listener.onSharedObjectSend(this, handler, arguments);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean removeAttribute(String name) {
        boolean success = false;
        this.beginUpdate();
        try {
            success = this.so.removeAttribute(name);
        }
        catch (Exception ex) {
            this.log.warn("Exception on so.removeAttribute", (Throwable)ex);
        }
        finally {
            this.endUpdate();
        }
        if (success) {
            for (ISharedObjectListener listener : this.serverListeners) {
                listener.onSharedObjectDelete(this, name);
            }
        }
        return success;
    }

    @Override
    public void removeAttributes() {
        this.beginUpdate();
        try {
            this.so.removeAttributes();
        }
        catch (Exception ex) {
            this.log.warn("Exception on so.removeAttributes", (Throwable)ex);
        }
        finally {
            this.endUpdate();
        }
        for (ISharedObjectListener listener : this.serverListeners) {
            listener.onSharedObjectClear(this);
        }
    }

    @Override
    public int size() {
        return this.so != null ? this.so.getAttributeNames().size() : 0;
    }

    @Override
    public boolean addEventListener(IEventListener listener) {
        boolean result = super.addEventListener(listener) && this.so.register(listener);
        for (ISharedObjectListener soListener : this.serverListeners) {
            soListener.onSharedObjectConnect(this);
        }
        return result;
    }

    @Override
    public boolean removeEventListener(IEventListener listener) {
        this.so.unregister(listener);
        if (this.so.isAcquired()) {
            this.log.debug("Shared object has been aquired so setting keep on disconnect");
            this.keepOnDisconnect = true;
        }
        boolean result = super.removeEventListener(listener);
        for (ISharedObjectListener soListener : this.serverListeners) {
            soListener.onSharedObjectDisconnect(this);
        }
        if (this.lingerJobName == null) {
            QuartzSchedulingService scheduler = (QuartzSchedulingService)this.getParent().getContext().getBean("schedulingService");
            IScheduledJob job = new IScheduledJob(){

                @Override
                public void execute(ISchedulingService service) {
                    if (SharedObjectScope.this.so != null && !SharedObjectScope.this.so.isClosed()) {
                        SharedObjectScope.this.so.checkRelease();
                    }
                }
            };
            this.lingerJobName = scheduler.addScheduledOnceJob(this.lingerPeriod, job);
        }
        if (this.so.isClosed()) {
            this.log.debug("Removing scope: {}", (Object)this);
            this.getParent().removeChildScope(this);
        }
        return result;
    }

    @Override
    public boolean hasAttribute(String name) {
        return this.so.hasAttribute(name);
    }

    @Override
    public Object getAttribute(String name) {
        return this.so.getAttribute(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object getAttribute(String name, Object value) {
        this.beginUpdate();
        try {
            Object object = this.so.getAttribute(name, value);
            return object;
        }
        catch (Exception ex) {
            this.log.warn("Exception on so.getAttribute", (Throwable)ex);
        }
        finally {
            this.endUpdate();
        }
        return null;
    }

    @Override
    public Map<String, Object> getAttributes() {
        return this.so.getAttributes();
    }

    @Override
    public Set<String> getAttributeNames() {
        return this.so.getAttributeNames();
    }

    @Override
    public Boolean getBoolAttribute(String name) {
        return this.so.getBoolAttribute(name);
    }

    @Override
    public Byte getByteAttribute(String name) {
        return this.so.getByteAttribute(name);
    }

    @Override
    public Double getDoubleAttribute(String name) {
        return this.so.getDoubleAttribute(name);
    }

    @Override
    public Integer getIntAttribute(String name) {
        return this.so.getIntAttribute(name);
    }

    @Override
    public List<?> getListAttribute(String name) {
        return this.so.getListAttribute(name);
    }

    @Override
    public Long getLongAttribute(String name) {
        return this.so.getLongAttribute(name);
    }

    @Override
    public Map<?, ?> getMapAttribute(String name) {
        return this.so.getMapAttribute(name);
    }

    @Override
    public Set<?> getSetAttribute(String name) {
        return this.so.getSetAttribute(name);
    }

    @Override
    public Short getShortAttribute(String name) {
        return this.so.getShortAttribute(name);
    }

    @Override
    public String getStringAttribute(String name) {
        return this.so.getStringAttribute(name);
    }

    @Override
    public Map<String, Object> getData() {
        return this.so.getData();
    }

    private Set<ISharedObjectSecurity> getSecurityHandlers() {
        ISharedObjectSecurityService security = (ISharedObjectSecurityService)ScopeUtils.getScopeService(this.getParent(), ISharedObjectSecurityService.class);
        if (security == null) {
            return null;
        }
        return security.getSharedObjectSecurity();
    }

    protected boolean isConnectionAllowed() {
        for (ISharedObjectSecurity handler : this.securityHandlers) {
            if (handler.isConnectionAllowed(this)) continue;
            return false;
        }
        Set<ISharedObjectSecurity> handlers = this.getSecurityHandlers();
        if (handlers == null) {
            return true;
        }
        for (ISharedObjectSecurity handler : handlers) {
            if (handler.isConnectionAllowed(this)) continue;
            return false;
        }
        return true;
    }

    protected boolean isWriteAllowed(String key, Object value) {
        for (ISharedObjectSecurity handler : this.securityHandlers) {
            if (handler.isWriteAllowed(this, key, value)) continue;
            return false;
        }
        Set<ISharedObjectSecurity> handlers = this.getSecurityHandlers();
        if (handlers == null) {
            return true;
        }
        for (ISharedObjectSecurity handler : handlers) {
            if (handler.isWriteAllowed(this, key, value)) continue;
            return false;
        }
        return true;
    }

    protected boolean isDeleteAllowed(String key) {
        for (ISharedObjectSecurity handler : this.securityHandlers) {
            if (handler.isDeleteAllowed(this, key)) continue;
            return false;
        }
        Set<ISharedObjectSecurity> handlers = this.getSecurityHandlers();
        if (handlers == null) {
            return true;
        }
        for (ISharedObjectSecurity handler : handlers) {
            if (handler.isDeleteAllowed(this, key)) continue;
            return false;
        }
        return true;
    }

    protected boolean isSendAllowed(String message, List<?> arguments) {
        for (ISharedObjectSecurity handler : this.securityHandlers) {
            if (handler.isSendAllowed(this, message, arguments)) continue;
            return false;
        }
        Set<ISharedObjectSecurity> handlers = this.getSecurityHandlers();
        if (handlers == null) {
            return true;
        }
        for (ISharedObjectSecurity handler : handlers) {
            if (handler.isSendAllowed(this, message, arguments)) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dispatchEvent(IEvent e) {
        if (e instanceof ISharedObjectMessage || e.getType() == IEvent.Type.SHARED_OBJECT) {
            ISharedObjectMessage msg = (ISharedObjectMessage)e;
            if (msg.hasSource()) {
                this.beginUpdate(msg.getSource());
            } else {
                this.beginUpdate();
            }
            try {
                block12: for (ISharedObjectEvent event : msg.getEvents()) {
                    String key = event.getKey();
                    switch (event.getType()) {
                        case SERVER_CONNECT: {
                            if (!this.isConnectionAllowed()) {
                                this.so.returnError("SharedObject.NoReadAccess");
                                break;
                            }
                            if (!msg.hasSource()) continue block12;
                            IEventListener source = msg.getSource();
                            if (source instanceof BaseConnection) {
                                ((BaseConnection)source).registerBasicScope(this);
                                break;
                            }
                            this.addEventListener(source);
                            break;
                        }
                        case SERVER_DISCONNECT: {
                            if (!msg.hasSource()) continue block12;
                            IEventListener source = msg.getSource();
                            if (source instanceof BaseConnection) {
                                ((BaseConnection)source).unregisterBasicScope(this);
                                break;
                            }
                            this.removeEventListener(source);
                            break;
                        }
                        case SERVER_SET_ATTRIBUTE: {
                            Object value = event.getValue();
                            if (!this.isWriteAllowed(key, value)) {
                                this.so.returnAttributeValue(key);
                                this.so.returnError("SharedObject.NoWriteAccess");
                                break;
                            }
                            this.setAttribute(key, value);
                            break;
                        }
                        case SERVER_DELETE_ATTRIBUTE: {
                            if (!this.isDeleteAllowed(key)) {
                                this.so.returnAttributeValue(key);
                                this.so.returnError("SharedObject.NoWriteAccess");
                                break;
                            }
                            this.removeAttribute(key);
                            break;
                        }
                        case SERVER_SEND_MESSAGE: {
                            List arguments = (List)event.getValue();
                            if (this.isSendAllowed(key, arguments)) {
                                this.sendMessage(key, arguments);
                                break;
                            }
                            this.log.debug("Send is not allowed for {}", (Object)key);
                            break;
                        }
                        default: {
                            this.log.warn("Unknown SO event: {}", (Object)event.getType());
                        }
                    }
                }
            }
            catch (Exception ex) {
                this.log.warn("Exception on dispatchEvent", (Throwable)ex);
            }
            finally {
                this.endUpdate();
            }
        } else {
            super.dispatchEvent(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean setAttribute(String name, Object value) {
        boolean success = false;
        this.beginUpdate();
        try {
            success = this.so.setAttribute(name, value);
        }
        catch (Exception ex) {
            this.log.warn("Exception on so.setAttribute", (Throwable)ex);
        }
        finally {
            this.endUpdate();
        }
        if (success) {
            for (ISharedObjectListener listener : this.serverListeners) {
                listener.onSharedObjectUpdate(this, name, value);
            }
        }
        return success;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean setAttributes(IAttributeStore values) {
        boolean success = false;
        this.beginUpdate();
        try {
            success = this.so.setAttributes(values);
        }
        catch (Exception ex) {
            this.log.warn("Exception on so.setAttributes", (Throwable)ex);
        }
        finally {
            this.endUpdate();
        }
        if (success) {
            for (ISharedObjectListener listener : this.serverListeners) {
                listener.onSharedObjectUpdate((ISharedObjectBase)this, values);
            }
        }
        return success;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean setAttributes(Map<String, Object> values) {
        boolean success = false;
        this.beginUpdate();
        try {
            success = this.so.setAttributes(values);
        }
        catch (Exception ex) {
            this.log.warn("Exception on so.setAttributes", (Throwable)ex);
        }
        finally {
            this.endUpdate();
        }
        if (success) {
            for (ISharedObjectListener listener : this.serverListeners) {
                listener.onSharedObjectUpdate((ISharedObjectBase)this, values);
            }
        }
        return success;
    }

    public String toString() {
        return "SharedObjectScope: " + this.getName();
    }

    @Override
    public void addSharedObjectListener(ISharedObjectListener listener) {
        this.serverListeners.add(listener);
    }

    @Override
    public void removeSharedObjectListener(ISharedObjectListener listener) {
        this.serverListeners.remove(listener);
    }

    @Override
    public void registerServiceHandler(Object handler) {
        this.registerServiceHandler("", handler);
    }

    @Override
    public void registerServiceHandler(String name, Object handler) {
        if (name == null) {
            name = "";
        }
        this.handlers.put(name, handler);
    }

    public void unregisterServiceHandler() {
        this.unregisterServiceHandler("");
    }

    @Override
    public void unregisterServiceHandler(String name) {
        if (name == null) {
            name = "";
        }
        this.handlers.remove(name);
    }

    @Override
    public Object getServiceHandler(String name) {
        if (name == null) {
            name = "";
        }
        return this.handlers.get(name);
    }

    @Override
    public Set<String> getServiceHandlerNames() {
        return Collections.unmodifiableSet(this.handlers.keySet());
    }

    @Override
    public void lock() {
        this.lock.lock();
    }

    @Override
    public void unlock() {
        this.lock.unlock();
    }

    @Override
    public boolean isLocked() {
        return this.lock.isLocked();
    }

    @Override
    public boolean clear() {
        boolean success = false;
        this.beginUpdate();
        try {
            success = this.so.clear();
        }
        catch (Exception ex) {
            this.log.warn("Exception on so.clear", (Throwable)ex);
        }
        finally {
            this.endUpdate();
        }
        if (success) {
            for (ISharedObjectListener listener : this.serverListeners) {
                listener.onSharedObjectClear(this);
            }
        }
        return success;
    }

    @Override
    public void close() {
        this.so.close();
        this.parent.removeChildScope(this);
        this.so = null;
    }

    @Override
    public void acquire() {
        this.so.acquire();
    }

    @Override
    public boolean isAcquired() {
        return this.so.isAcquired();
    }

    @Override
    public void release() {
        this.so.release();
    }

    @Override
    public ISharedObjectStatistics getStatistics() {
        return this.so;
    }

    @Override
    public void setDirty(boolean dirty) {
        this.so.setDirty(dirty);
    }
}

