/*
 * Decompiled with CFR 0.152.
 */
package org.red5.server.so;

import java.util.Set;
import org.red5.server.api.persistence.IPersistenceStore;
import org.red5.server.api.persistence.PersistenceUtils;
import org.red5.server.api.scope.IScope;
import org.red5.server.api.scope.ScopeType;
import org.red5.server.api.so.ISharedObject;
import org.red5.server.api.so.ISharedObjectService;
import org.red5.server.persistence.RamPersistence;
import org.red5.server.so.SharedObjectScope;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.scheduling.concurrent.ThreadPoolTaskScheduler;

public class SharedObjectService
implements ISharedObjectService {
    private Logger log = LoggerFactory.getLogger(SharedObjectService.class);
    private static final String SO_PERSISTENCE_STORE = "_transient_SO_PERSISTENCE_STORE_";
    private static final String SO_TRANSIENT_STORE = "_transient_SO_TRANSIENT_STORE_";
    private static ThreadPoolTaskScheduler scheduler;
    public static int MAXIMUM_EVENTS_PER_UPDATE;
    private String persistenceClassName = "org.red5.server.persistence.RamPersistence";

    public static void submitTask(Runnable task) {
        scheduler.execute(task);
    }

    public void setMaximumEventsPerUpdate(int maximumEventsPerUpdate) {
        MAXIMUM_EVENTS_PER_UPDATE = maximumEventsPerUpdate;
    }

    public void setPersistenceClassName(String name) {
        this.persistenceClassName = name;
    }

    public static void setScheduler(ThreadPoolTaskScheduler scheduler) {
        SharedObjectService.scheduler = scheduler;
    }

    private IPersistenceStore getStore(IScope scope, boolean persistent) {
        if (!persistent) {
            if (!scope.hasAttribute(SO_TRANSIENT_STORE)) {
                RamPersistence store = new RamPersistence(scope);
                scope.setAttribute(SO_TRANSIENT_STORE, store);
                return store;
            }
            return (IPersistenceStore)scope.getAttribute(SO_TRANSIENT_STORE);
        }
        if (!scope.hasAttribute(SO_PERSISTENCE_STORE)) {
            IPersistenceStore store;
            try {
                store = PersistenceUtils.getPersistenceStore(scope, this.persistenceClassName);
                this.log.info("Created persistence store {} for shared objects", (Object)store);
            }
            catch (Exception err) {
                this.log.warn("Could not create persistence store ({}) for shared objects, falling back to Ram persistence", (Object)this.persistenceClassName, (Object)err);
                store = new RamPersistence(scope);
            }
            scope.setAttribute(SO_PERSISTENCE_STORE, store);
            return store;
        }
        return (IPersistenceStore)scope.getAttribute(SO_PERSISTENCE_STORE);
    }

    @Override
    public boolean createSharedObject(IScope scope, String name, boolean persistent) {
        boolean added = this.hasSharedObject(scope, name);
        if (!added) {
            this.log.debug("Attempting to add shared object: {} to {}", (Object)name, (Object)scope.getName());
            added = scope.addChildScope(new SharedObjectScope(scope, name, persistent, this.getStore(scope, persistent)));
            if (!added) {
                added = this.hasSharedObject(scope, name);
                this.log.debug("Add failed on create, shared object already exists: {}", (Object)added);
            }
        } else {
            this.log.trace("Shared object ({}) already exists. Persistent: {}", (Object)name, (Object)persistent);
        }
        return added;
    }

    @Override
    public ISharedObject getSharedObject(IScope scope, String name) {
        return (ISharedObject)scope.getBasicScope(ScopeType.SHARED_OBJECT, name);
    }

    @Override
    public ISharedObject getSharedObject(IScope scope, String name, boolean persistent) {
        if (!this.hasSharedObject(scope, name)) {
            this.createSharedObject(scope, name, persistent);
        }
        return this.getSharedObject(scope, name);
    }

    @Override
    public Set<String> getSharedObjectNames(IScope scope) {
        return scope.getBasicScopeNames(ScopeType.SHARED_OBJECT);
    }

    @Override
    public boolean hasSharedObject(IScope scope, String name) {
        return scope.hasChildScope(ScopeType.SHARED_OBJECT, name);
    }

    @Override
    public boolean clearSharedObjects(IScope scope, String name) {
        boolean result = false;
        if (this.hasSharedObject(scope, name)) {
            result = ((ISharedObject)scope.getBasicScope(ScopeType.SHARED_OBJECT, name)).clear();
        }
        return result;
    }

    static {
        MAXIMUM_EVENTS_PER_UPDATE = 16;
    }
}

