/*
 * Decompiled with CFR 0.152.
 */
package org.red5.server.tomcat.rtmps;

import java.io.File;
import javax.servlet.ServletException;
import org.apache.catalina.Container;
import org.apache.catalina.Context;
import org.apache.catalina.Engine;
import org.apache.catalina.Loader;
import org.apache.catalina.Service;
import org.apache.catalina.Valve;
import org.apache.catalina.connector.Connector;
import org.apache.catalina.core.StandardEngine;
import org.apache.catalina.core.StandardHost;
import org.apache.catalina.core.StandardService;
import org.apache.catalina.core.StandardWrapper;
import org.apache.catalina.loader.WebappLoader;
import org.red5.logging.Red5LoggerFactory;
import org.red5.server.api.IServer;
import org.red5.server.tomcat.TomcatConnector;
import org.red5.server.tomcat.rtmpt.RTMPTLoader;
import org.red5.server.util.FileUtil;
import org.slf4j.Logger;

public class RTMPSLoader
extends RTMPTLoader {
    private Logger log = Red5LoggerFactory.getLogger(RTMPSLoader.class);
    protected Engine rtmpsEngine;

    @Override
    public void setServer(IServer server) {
        this.log.debug("RTMPS setServer");
        this.server = server;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void start() throws ServletException {
        this.log.info("Loading RTMPS context");
        this.rtmpsEngine = new StandardEngine();
        this.rtmpsEngine.setName("red5RTMPSEngine");
        this.rtmpsEngine.setDefaultHost(this.host.getName());
        this.rtmpsEngine.setRealm(embedded.getEngine().getRealm());
        StandardService service = new StandardService();
        service.setName("red5RTMPSEngine");
        service.setContainer(this.rtmpsEngine);
        for (Valve valve : this.valves) {
            this.log.debug("Adding host valve: {}", (Object)valve);
            ((StandardHost)this.host).addValve(valve);
        }
        File appDirBase = new File(this.webappFolder);
        String webappContextDir = FileUtil.formatPath(appDirBase.getAbsolutePath(), "/root");
        Context ctx = embedded.addWebapp("/", webappContextDir);
        ctx.setReloadable(false);
        this.log.debug("Context name: {}", (Object)ctx.getName());
        Loader ldr = ctx.getLoader();
        this.log.trace("Context loader (null if the context has not been started): {}", (Object)ldr);
        if (ldr == null) {
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            ctx.setParentClassLoader(classLoader);
            WebappLoader wldr = new WebappLoader(classLoader);
            ctx.setLoader((Loader)wldr);
        }
        appDirBase = null;
        webappContextDir = null;
        this.host.addChild((Container)ctx);
        StandardWrapper wrapper = new StandardWrapper();
        wrapper.setServletName("RTMPTServlet");
        wrapper.setServletClass("org.red5.server.net.rtmpt.RTMPTServlet");
        ctx.addChild((Container)wrapper);
        ctx.addServletMapping("/open/*", "RTMPTServlet");
        ctx.addServletMapping("/close/*", "RTMPTServlet");
        ctx.addServletMapping("/send/*", "RTMPTServlet");
        ctx.addServletMapping("/idle/*", "RTMPTServlet");
        this.rtmpsEngine.addChild((Container)this.host);
        embedded.getServer().addService((Service)service);
        try {
            for (TomcatConnector tomcatConnector : this.connectors) {
                Connector connector = tomcatConnector.getConnector();
                service.addConnector(connector);
                this.log.trace("Connector oName: {}", (Object)connector.getObjectName());
                this.log.info("Starting RTMPS engine");
                connector.start();
            }
        }
        catch (Exception e) {
            this.log.error("Error initializing RTMPS server instance", (Throwable)e);
        }
        finally {
            this.registerJMX();
        }
    }
}

