/*
 * Decompiled with CFR 0.152.
 */
package org.webrtc;

import java.nio.ByteBuffer;
import org.webrtc.AudioDecoderFactoryFactory;
import org.webrtc.CalledByNative;

public class BuiltinAudioDecoderFactoryFactory
implements AudioDecoderFactoryFactory {
    private AudioPacketListener audioPacketListener;
    private boolean customDecoder = false;
    private long audioDecoderFactory = -1L;
    private static final int BUFFER_LIMIT = 4096;
    ByteBuffer buffer = ByteBuffer.allocateDirect(4096);

    @Override
    public long createNativeAudioDecoderFactory() {
        this.audioDecoderFactory = BuiltinAudioDecoderFactoryFactory.nativeCreateBuiltinAudioDecoderFactory(this, this.customDecoder, this.buffer);
        return this.audioDecoderFactory;
    }

    @CalledByNative
    public synchronized void onAudioPacket(int size, long timestamp) {
        this.buffer.rewind();
        this.buffer.limit(size);
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(size);
        byteBuffer.put(this.buffer);
        byteBuffer.limit(size);
        byteBuffer.rewind();
        this.buffer.rewind();
        this.buffer.limit(4096);
        this.audioPacketListener.onAudioPacketData(byteBuffer, timestamp);
    }

    public void setAudioPacketListener(AudioPacketListener audioPacketListener) {
        this.audioPacketListener = audioPacketListener;
    }

    private static native long nativeCreateBuiltinAudioDecoderFactory(BuiltinAudioDecoderFactoryFactory var0, boolean var1, ByteBuffer var2);

    public void setCustomDecoder(boolean customDecoder) {
        this.customDecoder = customDecoder;
    }

    public static interface AudioPacketListener {
        public void onAudioPacketData(ByteBuffer var1, long var2);
    }
}

