/*
 * Decompiled with CFR 0.152.
 */
package org.webrtc.audio;

import io.antmedia.webrtc.api.IAudioRecordListener;
import java.nio.ByteBuffer;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.webrtc.CalledByNative;
import org.webrtc.Logging;
import org.webrtc.audio.JavaAudioDeviceModule;

public class WebRtcAudioRecord {
    private static Logger logger = LoggerFactory.getLogger(WebRtcAudioRecord.class);
    private static final String TAG = "WebRtcAudioRecordExternal";
    private static final int CALLBACK_BUFFER_SIZE_MS = 10;
    private static final int BUFFERS_PER_SECOND = 100;
    private static final int BUFFER_SIZE_FACTOR = 2;
    private static final long AUDIO_RECORD_THREAD_JOIN_TIMEOUT_MS = 2000L;
    public static final int DEFAULT_AUDIO_SOURCE = 0;
    public static final int DEFAULT_AUDIO_FORMAT = 0;
    private static final int AUDIO_RECORD_START = 0;
    private static final int AUDIO_RECORD_STOP = 1;
    private static final int CHECK_REC_STATUS_DELAY_MS = 100;
    private final int audioSource;
    private final int audioFormat;
    private long nativeAudioRecord;
    @Nullable
    private ByteBuffer byteBuffer;
    @Nullable
    private ScheduledExecutorService executor;
    @Nullable
    private ScheduledFuture<String> future;
    private volatile boolean microphoneMute;
    private boolean audioSourceMatchesRecordingSession;
    private boolean isAudioConfigVerified;
    private byte[] emptyBytes;
    @Nullable
    private final JavaAudioDeviceModule.AudioRecordErrorCallback errorCallback;
    @Nullable
    private final JavaAudioDeviceModule.AudioRecordStateCallback stateCallback;
    @Nullable
    private final JavaAudioDeviceModule.SamplesReadyCallback audioSamplesReadyCallback;
    private final boolean isAcousticEchoCancelerSupported;
    private final boolean isNoiseSuppressorSupported;
    private IAudioRecordListener audioRecordListener;
    private ByteBuffer encodedByteBuffer;

    @CalledByNative
    WebRtcAudioRecord(Object context, Object audioManager) {
        this(context, audioManager, 0, 0, null, null, null, false, false, null);
    }

    public WebRtcAudioRecord(Object context, Object audioManager, int audioSource, int audioFormat, @Nullable JavaAudioDeviceModule.AudioRecordErrorCallback errorCallback, @Nullable JavaAudioDeviceModule.AudioRecordStateCallback stateCallback, @Nullable JavaAudioDeviceModule.SamplesReadyCallback audioSamplesReadyCallback, boolean isAcousticEchoCancelerSupported, boolean isNoiseSuppressorSupported, IAudioRecordListener audioRecordListener) {
        this.audioSource = audioSource;
        this.audioFormat = audioFormat;
        this.errorCallback = errorCallback;
        this.stateCallback = stateCallback;
        this.audioSamplesReadyCallback = audioSamplesReadyCallback;
        this.isAcousticEchoCancelerSupported = isAcousticEchoCancelerSupported;
        this.isNoiseSuppressorSupported = isNoiseSuppressorSupported;
        this.audioRecordListener = audioRecordListener;
    }

    @CalledByNative
    public void setNativeAudioRecord(long nativeAudioRecord) {
        this.nativeAudioRecord = nativeAudioRecord;
    }

    @CalledByNative
    boolean isAcousticEchoCancelerSupported() {
        return this.isAcousticEchoCancelerSupported;
    }

    @CalledByNative
    boolean isNoiseSuppressorSupported() {
        return this.isNoiseSuppressorSupported;
    }

    @CalledByNative
    boolean isAudioConfigVerified() {
        return this.isAudioConfigVerified;
    }

    @CalledByNative
    boolean isAudioSourceMatchingRecordingSession() {
        if (!this.isAudioConfigVerified) {
            Logging.w(TAG, "Audio configuration has not yet been verified");
            return false;
        }
        return this.audioSourceMatchesRecordingSession;
    }

    @CalledByNative
    private boolean enableBuiltInAEC(boolean enable) {
        Logging.d(TAG, "enableBuiltInAEC(" + enable + ")");
        return false;
    }

    @CalledByNative
    private boolean enableBuiltInNS(boolean enable) {
        Logging.d(TAG, "enableBuiltInNS(" + enable + ")");
        return false;
    }

    @CalledByNative
    private int initRecording(int sampleRate, int channels) {
        System.out.println("initRecording(sampleRate=" + sampleRate + ", channels=" + channels + ")");
        int bytesPerFrame = channels * 2;
        int framesPerBuffer = sampleRate / 100;
        this.byteBuffer = ByteBuffer.allocateDirect(bytesPerFrame * framesPerBuffer);
        System.out.println("byteBuffer.capacity: " + this.byteBuffer.capacity());
        this.emptyBytes = new byte[this.byteBuffer.capacity()];
        this.nativeCacheDirectBufferAddress(this.nativeAudioRecord, this.byteBuffer);
        this.encodedByteBuffer = ByteBuffer.allocateDirect(this.byteBuffer.capacity() * 10);
        this.nativeCacheDirectBufferAddressForEncodedAudio(this.nativeAudioRecord, this.encodedByteBuffer);
        return framesPerBuffer;
    }

    @CalledByNative
    private boolean startRecording() {
        Logging.d(TAG, "startRecording");
        if (this.audioRecordListener != null) {
            this.audioRecordListener.audioRecordStarted();
        }
        return true;
    }

    @CalledByNative
    private boolean stopRecording() {
        Logging.d(TAG, "stopRecording");
        if (this.audioRecordListener != null) {
            this.audioRecordListener.audioRecordStoppped();
            this.audioRecordListener = null;
        }
        return true;
    }

    private static void assertTrue(boolean condition) {
        if (!condition) {
            throw new AssertionError((Object)"Expected condition to be true");
        }
    }

    private native void nativeCacheDirectBufferAddress(long var1, ByteBuffer var3);

    private native void nativeDataIsRecorded(long var1, int var3);

    private native void nativeCacheDirectBufferAddressForEncodedAudio(long var1, ByteBuffer var3);

    private native void nativeEncodedDataIsReady(long var1, int var3);

    public void setMicrophoneMute(boolean mute) {
        Logging.w(TAG, "setMicrophoneMute(" + mute + ")");
        this.microphoneMute = mute;
    }

    private void reportWebRtcAudioRecordInitError(String errorMessage) {
        Logging.e(TAG, "Init recording error: " + errorMessage);
        if (this.errorCallback != null) {
            this.errorCallback.onWebRtcAudioRecordInitError(errorMessage);
        }
    }

    private void reportWebRtcAudioRecordStartError(JavaAudioDeviceModule.AudioRecordStartErrorCode errorCode, String errorMessage) {
        Logging.e(TAG, "Start recording error: " + errorCode + ". " + errorMessage);
        if (this.errorCallback != null) {
            this.errorCallback.onWebRtcAudioRecordStartError(errorCode, errorMessage);
        }
    }

    private void reportWebRtcAudioRecordError(String errorMessage) {
        Logging.e(TAG, "Run-time recording error: " + errorMessage);
        if (this.errorCallback != null) {
            this.errorCallback.onWebRtcAudioRecordError(errorMessage);
        }
    }

    private void doAudioRecordStateCallback(int audioState) {
        Logging.d(TAG, "doAudioRecordStateCallback: " + WebRtcAudioRecord.audioStateToString(audioState));
        if (this.stateCallback != null) {
            if (audioState == 0) {
                this.stateCallback.onWebRtcAudioRecordStart();
            } else if (audioState == 1) {
                this.stateCallback.onWebRtcAudioRecordStop();
            } else {
                Logging.e(TAG, "Invalid audio state");
            }
        }
    }

    private static String audioStateToString(int state) {
        switch (state) {
            case 0: {
                return "START";
            }
            case 1: {
                return "STOP";
            }
        }
        return "INVALID";
    }

    public void notifyEncodedData(ByteBuffer audio) {
        if (audio.limit() <= this.encodedByteBuffer.capacity()) {
            this.encodedByteBuffer.clear();
            audio.rewind();
            this.encodedByteBuffer.put(audio);
            this.nativeEncodedDataIsReady(this.nativeAudioRecord, audio.limit());
        } else {
            logger.warn("Discarding audio packet because audio packet size({}) is bigger than buffer capacity{} and limit {}", new Object[]{audio.limit(), this.encodedByteBuffer.capacity(), this.encodedByteBuffer.limit()});
        }
    }
}

