/*
 * Decompiled with CFR 0.152.
 */
package io.antmedia.cluster;

import dev.morphia.annotations.Entity;
import dev.morphia.annotations.Field;
import dev.morphia.annotations.Id;
import dev.morphia.annotations.Index;
import dev.morphia.annotations.Indexes;
import dev.morphia.annotations.NotSaved;

@Entity(value="clusternode")
@Indexes(value={@Index(fields={@Field(value="id")})})
public class ClusterNode {
    public static final String ALIVE = "alive";
    public static final String DEAD = "dead";
    public static final long NODE_UPDATE_PERIOD = 5000L;
    @Id
    private String id;
    private String ip;
    private long lastUpdateTime;
    private String memory;
    private String cpu;
    @NotSaved
    private String status;

    public ClusterNode() {
    }

    public ClusterNode(String ip, String id) {
        this.ip = ip;
        this.id = id;
        this.lastUpdateTime = System.currentTimeMillis();
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getIp() {
        return this.ip;
    }

    public void setIp(String ip) {
        this.ip = ip;
    }

    public String getStatus() {
        this.status = System.currentTimeMillis() - this.lastUpdateTime > 10000L ? DEAD : ALIVE;
        return this.status;
    }

    public long getLastUpdateTime() {
        return this.lastUpdateTime;
    }

    public void setLastUpdateTime(long lastUpdateTime) {
        this.lastUpdateTime = lastUpdateTime;
    }

    public String getMemory() {
        return this.memory;
    }

    public void setMemory(String memory) {
        this.memory = memory;
    }

    public String getCpu() {
        return this.cpu;
    }

    public void setCpu(String cpu) {
        this.cpu = cpu;
    }
}

