/*
 * Decompiled with CFR 0.152.
 */
package io.antmedia.console.datastore;

import io.antmedia.datastore.db.types.User;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public abstract class AbstractConsoleDataStore {
    public static final String SERVER_STORAGE_FILE = "server.db";
    public static final String SERVER_STORAGE_MAP_NAME = "serverdb";
    private Map<String, Integer> invalidLoginCountMap = new HashMap<String, Integer>();
    private Map<String, Long> blockTimeMap = new HashMap<String, Long>();
    private Map<String, Boolean> isBlockedMap = new HashMap<String, Boolean>();

    public abstract boolean addUser(User var1);

    public abstract boolean editUser(User var1);

    public abstract boolean deleteUser(String var1);

    public abstract boolean doesUsernameExist(String var1);

    public abstract boolean doesUserExist(String var1, String var2);

    public abstract List<User> getUserList();

    public abstract User getUser(String var1);

    public abstract void clear();

    public abstract void close();

    public abstract int getNumberOfUserRecords();

    public abstract boolean isAvailable();

    public long getBlockTime(String usermail) {
        return this.blockTimeMap.containsKey(usermail) ? this.blockTimeMap.get(usermail) : 0L;
    }

    public int getInvalidLoginCount(String usermail) {
        return this.getInvalidLoginCountMap().containsKey(usermail) ? this.getInvalidLoginCountMap().get(usermail) : 0;
    }

    public boolean isUserBlocked(String usermail) {
        return this.getIsBlockedMap().containsKey(usermail);
    }

    public void setBlockTime(String usermail, long blockTime) {
        this.blockTimeMap.put(usermail, blockTime);
    }

    public void incrementInvalidLoginCount(String usermail) {
        this.getInvalidLoginCountMap().put(usermail, this.getInvalidLoginCount(usermail) + 1);
    }

    public void resetInvalidLoginCount(String usermail) {
        this.getInvalidLoginCountMap().remove(usermail);
    }

    public void setBlocked(String usermail) {
        this.getIsBlockedMap().put(usermail, true);
    }

    public void setUnBlocked(String usermail) {
        this.getIsBlockedMap().remove(usermail);
    }

    public Map<String, Boolean> getIsBlockedMap() {
        return this.isBlockedMap;
    }

    public Map<String, Integer> getInvalidLoginCountMap() {
        return this.invalidLoginCountMap;
    }
}

