/*
 * Decompiled with CFR 0.152.
 */
package io.antmedia.console.datastore;

import com.google.gson.Gson;
import io.antmedia.console.datastore.AbstractConsoleDataStore;
import io.antmedia.datastore.db.types.User;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.mapdb.DB;
import org.mapdb.DBMaker;
import org.mapdb.HTreeMap;
import org.mapdb.Serializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MapDBStore
extends AbstractConsoleDataStore {
    private DB db = DBMaker.fileDB((String)"server.db").fileMmapEnableIfSupported().checksumHeaderBypass().make();
    private HTreeMap<String, String> userMap = this.db.hashMap("serverdb").keySerializer((Serializer)Serializer.STRING).valueSerializer((Serializer)Serializer.STRING).counterEnable().createOrOpen();
    private Gson gson = new Gson();
    protected volatile boolean available = true;
    protected static Logger logger = LoggerFactory.getLogger(MapDBStore.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean addUser(User user) {
        MapDBStore mapDBStore = this;
        synchronized (mapDBStore) {
            boolean result = false;
            try {
                if (!this.userMap.containsKey((Object)user.getEmail())) {
                    this.userMap.put((Object)user.getEmail(), (Object)this.gson.toJson((Object)user));
                    this.db.commit();
                    result = true;
                } else {
                    logger.warn("user with {} already exist", (Object)user.getEmail());
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                result = false;
            }
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean editUser(User user) {
        MapDBStore mapDBStore = this;
        synchronized (mapDBStore) {
            boolean result = false;
            try {
                String username = user.getEmail();
                if (this.userMap.containsKey((Object)username)) {
                    this.userMap.put((Object)username, (Object)this.gson.toJson((Object)user));
                    this.db.commit();
                    result = true;
                }
            }
            catch (Exception e) {
                result = false;
            }
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean deleteUser(String username) {
        MapDBStore mapDBStore = this;
        synchronized (mapDBStore) {
            boolean result = false;
            if (username != null) {
                try {
                    if (this.userMap.containsKey((Object)username)) {
                        this.userMap.remove((Object)username);
                        this.db.commit();
                        result = true;
                    }
                }
                catch (Exception e) {
                    result = false;
                }
            }
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean doesUsernameExist(String username) {
        MapDBStore mapDBStore = this;
        synchronized (mapDBStore) {
            return this.userMap.containsKey((Object)username);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean doesUserExist(String username, String password) {
        MapDBStore mapDBStore = this;
        synchronized (mapDBStore) {
            boolean result = false;
            if (username != null && password != null) {
                try {
                    String value;
                    User user;
                    if (this.userMap.containsKey((Object)username) && (user = (User)this.gson.fromJson(value = (String)this.userMap.get((Object)username), User.class)).getPassword().equals(password)) {
                        result = true;
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<User> getUserList() {
        ArrayList<User> list = new ArrayList<User>();
        MapDBStore mapDBStore = this;
        synchronized (mapDBStore) {
            Collection users = this.userMap.getValues();
            for (String userString : users) {
                User user = (User)this.gson.fromJson(userString, User.class);
                list.add(user);
            }
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public User getUser(String username) {
        MapDBStore mapDBStore = this;
        synchronized (mapDBStore) {
            if (username != null) {
                try {
                    if (this.userMap.containsKey((Object)username)) {
                        String value = (String)this.userMap.get((Object)username);
                        return (User)this.gson.fromJson(value, User.class);
                    }
                }
                catch (Exception e) {
                    logger.error(ExceptionUtils.getStackTrace((Throwable)e));
                }
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() {
        MapDBStore mapDBStore = this;
        synchronized (mapDBStore) {
            this.userMap.clear();
            this.db.commit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        MapDBStore mapDBStore = this;
        synchronized (mapDBStore) {
            this.available = false;
            this.db.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getNumberOfUserRecords() {
        MapDBStore mapDBStore = this;
        synchronized (mapDBStore) {
            return this.userMap.size();
        }
    }

    @Override
    public boolean isAvailable() {
        return this.available;
    }
}

