/*
 * Decompiled with CFR 0.152.
 */
package io.antmedia.console.rest;

import io.antmedia.console.datastore.AbstractConsoleDataStore;
import io.antmedia.console.datastore.ConsoleDataStoreFactory;
import io.antmedia.console.rest.CommonRestService;
import io.antmedia.datastore.db.types.User;
import io.antmedia.filter.AbstractFilter;
import io.antmedia.rest.model.UserType;
import java.io.IOException;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.web.context.ConfigurableWebApplicationContext;

public class AuthenticationFilter
extends AbstractFilter {
    public static final String DISPATCH_PATH_URL = "_path";

    public AbstractConsoleDataStore getDataStore() {
        Object dataStoreFactory;
        AbstractConsoleDataStore dataStore = null;
        ConfigurableWebApplicationContext appContext = this.getWebApplicationContext();
        if (appContext != null && appContext.isRunning() && (dataStoreFactory = appContext.getBean("dataStoreFactory")) instanceof ConsoleDataStoreFactory) {
            AbstractConsoleDataStore dataStoreTemp = ((ConsoleDataStoreFactory)dataStoreFactory).getDataStore();
            if (dataStoreTemp.isAvailable()) {
                dataStore = dataStoreTemp;
            } else {
                logger.warn("DataStore is not available. It may be closed or not initialized");
            }
        }
        return dataStore;
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        String path = ((HttpServletRequest)request).getRequestURI();
        if (path.equals("/rest/isAuthenticated") || path.equals("/rest/authenticateUser") || path.equals("/rest/addInitialUser") || path.equals("/rest/isFirstLogin") || path.equals("/rest/v2/authentication-status") || path.equals("/rest/v2/users/initial") || path.equals("/rest/v2/first-login-status") || path.equals("/rest/v2/users/authenticate") || path.startsWith("/rest/v2/users/") && path.endsWith("/blocked")) {
            chain.doFilter(request, response);
        } else if (CommonRestService.isAuthenticated(((HttpServletRequest)request).getSession())) {
            HttpServletRequest httpRequest = (HttpServletRequest)request;
            String method = httpRequest.getMethod();
            String userEmail = (String)httpRequest.getSession().getAttribute("user.email");
            AbstractConsoleDataStore store = this.getDataStore();
            if (store != null) {
                User currentUser = store.getUser(userEmail);
                if (currentUser != null) {
                    String userScope = currentUser.getScope();
                    String dispatchURL = httpRequest.getParameter(DISPATCH_PATH_URL);
                    boolean scopeAccess = this.scopeAccessGranted(userScope, dispatchURL);
                    if ("GET".equals(method)) {
                        if (scopeAccess || path.equals("/rest/v2/applications/settings/" + userScope) || path.equals("/rest/v2/version") || path.equals("/rest/v2/enterprise-edition") || path.equals("/rest/v2/admin-status")) {
                            chain.doFilter(request, response);
                        } else {
                            ((HttpServletResponse)response).sendError(403, "Not allowed to access this resource. Contact system admin");
                        }
                    } else if (path.equals("/rest/v2/users/password") || path.startsWith("/rest/v2/support/request")) {
                        chain.doFilter(request, response);
                    } else if (scopeAccess) {
                        if (UserType.ADMIN.equals((Object)currentUser.getUserType()) || currentUser.getUserType() == null) {
                            chain.doFilter(request, response);
                        } else if (UserType.USER.equals((Object)currentUser.getUserType()) && !currentUser.getScope().equals("system")) {
                            chain.doFilter(request, response);
                        } else {
                            ((HttpServletResponse)response).sendError(403, "Not allowed to access this resource. Contact system admin");
                        }
                    } else if (UserType.ADMIN.equals((Object)currentUser.getUserType()) && path.startsWith("/rest/v2/applications/settings/" + userScope)) {
                        chain.doFilter(request, response);
                    } else {
                        ((HttpServletResponse)response).sendError(403, "Not allowed to access this resource. Contact system admin");
                    }
                } else {
                    ((HttpServletResponse)response).sendError(403, "No user in this session");
                }
            } else {
                ((HttpServletResponse)response).sendError(500, "Database is not available. Please try again");
            }
        } else {
            ((HttpServletResponse)response).sendError(403, "Not authenticated user");
        }
    }

    private boolean scopeAccessGranted(String userScope, String dispatchUrl) {
        boolean granted = false;
        if (userScope == null || userScope.equals("system")) {
            granted = true;
        } else if (dispatchUrl != null && (dispatchUrl.startsWith(userScope) || dispatchUrl.startsWith(userScope, 1))) {
            granted = true;
        }
        return granted;
    }

    @Override
    public void destroy() {
    }
}

