/*
 * Decompiled with CFR 0.152.
 */
package io.antmedia.datastore.db;

import io.antmedia.datastore.db.types.Broadcast;
import io.antmedia.datastore.db.types.ConferenceRoom;
import io.antmedia.datastore.db.types.ConnectionEvent;
import io.antmedia.datastore.db.types.Endpoint;
import io.antmedia.datastore.db.types.P2PConnection;
import io.antmedia.datastore.db.types.StreamInfo;
import io.antmedia.datastore.db.types.Subscriber;
import io.antmedia.datastore.db.types.SubscriberStats;
import io.antmedia.datastore.db.types.TensorFlowObject;
import io.antmedia.datastore.db.types.Token;
import io.antmedia.datastore.db.types.VoD;
import io.antmedia.datastore.db.types.WebRTCViewerInfo;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class DataStore {
    public static final int MAX_ITEM_IN_ONE_LIST = 250;
    private boolean writeStatsToDatastore = true;
    protected volatile boolean available = false;
    protected static Logger logger = LoggerFactory.getLogger(DataStore.class);
    public static final long TOTAL_WEBRTC_VIEWER_COUNT_CACHE_TIME = 5000L;
    protected int totalWebRTCViewerCount = 0;
    protected long totalWebRTCViewerCountLastUpdateTime = 0L;

    public abstract String save(Broadcast var1);

    public abstract Broadcast get(String var1);

    public abstract VoD getVoD(String var1);

    public abstract boolean updateStatus(String var1, String var2);

    public boolean updateSourceQualityParameters(String id, String quality, double speed, int pendingPacketQueue) {
        if (this.writeStatsToDatastore) {
            return this.updateSourceQualityParametersLocal(id, quality, speed, pendingPacketQueue);
        }
        return false;
    }

    protected abstract boolean updateSourceQualityParametersLocal(String var1, String var2, double var3, int var5);

    public abstract boolean updateDuration(String var1, long var2);

    public abstract long getPartialVodNumber(String var1);

    public abstract long getPartialBroadcastNumber(String var1);

    public abstract boolean addEndpoint(String var1, Endpoint var2);

    public abstract String addVod(VoD var1);

    public abstract long getBroadcastCount();

    public abstract boolean delete(String var1);

    public abstract boolean deleteVod(String var1);

    public abstract List<Broadcast> getBroadcastList(int var1, int var2, String var3, String var4, String var5, String var6);

    public abstract List<ConferenceRoom> getConferenceRoomList(int var1, int var2, String var3, String var4, String var5);

    public abstract boolean removeEndpoint(String var1, Endpoint var2, boolean var3);

    public abstract List<Broadcast> getExternalStreamsList();

    public abstract void close(boolean var1);

    public abstract List<VoD> getVodList(int var1, int var2, String var3, String var4, String var5, String var6);

    public abstract boolean removeAllEndpoints(String var1);

    public abstract long getTotalVodNumber();

    public abstract long getTotalBroadcastNumber();

    public abstract void saveDetection(String var1, long var2, List<TensorFlowObject> var4);

    public abstract List<TensorFlowObject> getDetectionList(String var1, int var2, int var3);

    public abstract List<TensorFlowObject> getDetection(String var1);

    public abstract boolean saveToken(Token var1);

    public abstract List<Token> listAllTokens(String var1, int var2, int var3);

    public abstract Token validateToken(Token var1);

    public abstract boolean revokeTokens(String var1);

    public abstract boolean deleteToken(String var1);

    public abstract Token getToken(String var1);

    public abstract List<Subscriber> listAllSubscribers(String var1, int var2, int var3);

    public List<SubscriberStats> listAllSubscriberStats(String streamId, int offset, int size) {
        List<Subscriber> subscribers = this.listAllSubscribers(streamId, offset, size);
        ArrayList<SubscriberStats> subscriberStats = new ArrayList<SubscriberStats>();
        for (Subscriber subscriber : subscribers) {
            subscriberStats.add(subscriber.getStats());
        }
        return subscriberStats;
    }

    public abstract boolean addSubscriber(String var1, Subscriber var2);

    public abstract boolean deleteSubscriber(String var1, String var2);

    public abstract boolean revokeSubscribers(String var1);

    public abstract Subscriber getSubscriber(String var1, String var2);

    public boolean isSubscriberConnected(String streamId, String subscriberId) {
        Subscriber subscriber = this.getSubscriber(streamId, subscriberId);
        if (subscriber != null) {
            return subscriber.isConnected();
        }
        return false;
    }

    public boolean addSubscriberConnectionEvent(String streamId, String subscriberId, ConnectionEvent event) {
        boolean result = false;
        Subscriber subscriber = this.getSubscriber(streamId, subscriberId);
        if (subscriber != null) {
            this.handleConnectionEvent(subscriber, event);
            this.addSubscriber(streamId, subscriber);
            result = true;
        }
        return result;
    }

    protected void handleConnectionEvent(Subscriber subscriber, ConnectionEvent event) {
        if ("connected".equals(event.getEventType())) {
            subscriber.setConnected(true);
        } else if ("disconnected".equals(event.getEventType())) {
            subscriber.setConnected(false);
        }
        subscriber.getStats().addConnectionEvent(event);
    }

    public boolean updateSubscriberBitrateEvent(String streamId, String subscriberId, long avgVideoBitrate, long avgAudioBitrate) {
        boolean result = false;
        Subscriber subscriber = this.getSubscriber(streamId, subscriberId);
        if (subscriber != null) {
            subscriber.getStats().setAvgVideoBitrate(avgVideoBitrate);
            subscriber.getStats().setAvgAudioBitrate(avgAudioBitrate);
            this.addSubscriber(streamId, subscriber);
            result = true;
        }
        return result;
    }

    public abstract boolean resetSubscribersConnectedStatus();

    public abstract boolean setMp4Muxing(String var1, int var2);

    public abstract boolean setWebMMuxing(String var1, int var2);

    public abstract int fetchUserVodList(File var1);

    public abstract long getActiveBroadcastCount();

    public abstract boolean updateBroadcastFields(String var1, Broadcast var2);

    public boolean updateHLSViewerCount(String streamId, int diffCount) {
        if (this.writeStatsToDatastore) {
            return this.updateHLSViewerCountLocal(streamId, diffCount);
        }
        return false;
    }

    protected abstract boolean updateHLSViewerCountLocal(String var1, int var2);

    public abstract long getObjectDetectedTotal(String var1);

    public boolean updateWebRTCViewerCount(String streamId, boolean increment) {
        if (this.writeStatsToDatastore) {
            return this.updateWebRTCViewerCountLocal(streamId, increment);
        }
        return false;
    }

    protected abstract boolean updateWebRTCViewerCountLocal(String var1, boolean var2);

    public boolean updateRtmpViewerCount(String streamId, boolean increment) {
        if (this.writeStatsToDatastore) {
            return this.updateRtmpViewerCountLocal(streamId, increment);
        }
        return false;
    }

    protected abstract boolean updateRtmpViewerCountLocal(String var1, boolean var2);

    public abstract void saveStreamInfo(StreamInfo var1);

    public abstract void addStreamInfoList(List<StreamInfo> var1);

    public abstract List<StreamInfo> getStreamInfoList(String var1);

    public abstract void clearStreamInfoList(String var1);

    public boolean isWriteStatsToDatastore() {
        return this.writeStatsToDatastore;
    }

    public void setWriteStatsToDatastore(boolean writeStatsToDatastore) {
        this.writeStatsToDatastore = writeStatsToDatastore;
    }

    public abstract boolean createConferenceRoom(ConferenceRoom var1);

    public abstract boolean editConferenceRoom(String var1, ConferenceRoom var2);

    public abstract boolean deleteConferenceRoom(String var1);

    public abstract ConferenceRoom getConferenceRoom(String var1);

    protected void updateStreamInfo(Broadcast broadcast, Broadcast newBroadcast) {
        if (newBroadcast.getName() != null) {
            broadcast.setName(newBroadcast.getName());
        }
        if (newBroadcast.getDescription() != null) {
            broadcast.setDescription(newBroadcast.getDescription());
        }
        if (newBroadcast.getUsername() != null) {
            broadcast.setUsername(newBroadcast.getUsername());
        }
        if (newBroadcast.getPassword() != null) {
            broadcast.setPassword(newBroadcast.getPassword());
        }
        if (newBroadcast.getIpAddr() != null) {
            broadcast.setIpAddr(newBroadcast.getIpAddr());
        }
        if (newBroadcast.getStreamUrl() != null) {
            broadcast.setStreamUrl(newBroadcast.getStreamUrl());
        }
        if (newBroadcast.getLatitude() != null) {
            broadcast.setLatitude(newBroadcast.getLatitude());
        }
        if (newBroadcast.getLongitude() != null) {
            broadcast.setLongitude(newBroadcast.getLongitude());
        }
        if (newBroadcast.getAltitude() != null) {
            broadcast.setAltitude(newBroadcast.getAltitude());
        }
        if (newBroadcast.getMainTrackStreamId() != null) {
            broadcast.setMainTrackStreamId(newBroadcast.getMainTrackStreamId());
        }
        if (newBroadcast.getStartTime() != 0L) {
            broadcast.setStartTime(newBroadcast.getStartTime());
        }
        if (newBroadcast.getOriginAdress() != null) {
            broadcast.setOriginAdress(newBroadcast.getOriginAdress());
        }
        if (newBroadcast.getStatus() != null) {
            broadcast.setStatus(newBroadcast.getStatus());
        }
        if (newBroadcast.getAbsoluteStartTimeMs() != 0L) {
            broadcast.setAbsoluteStartTimeMs(newBroadcast.getAbsoluteStartTimeMs());
        }
        if (newBroadcast.getPlayListItemList() != null) {
            broadcast.setPlayListItemList(newBroadcast.getPlayListItemList());
        }
        if (newBroadcast.getPlayListStatus() != null) {
            broadcast.setPlayListStatus(newBroadcast.getPlayListStatus());
        }
        if (newBroadcast.getEndPointList() != null) {
            broadcast.setEndPointList(newBroadcast.getEndPointList());
        }
        if (newBroadcast.getSubFolder() != null) {
            broadcast.setSubFolder(newBroadcast.getSubFolder());
        }
        broadcast.setCurrentPlayIndex(newBroadcast.getCurrentPlayIndex());
        broadcast.setReceivedBytes(newBroadcast.getReceivedBytes());
        broadcast.setDuration(newBroadcast.getDuration());
        broadcast.setBitrate(newBroadcast.getBitrate());
        broadcast.setUserAgent(newBroadcast.getUserAgent());
        broadcast.setWebRTCViewerLimit(newBroadcast.getWebRTCViewerLimit());
        broadcast.setHlsViewerLimit(newBroadcast.getHlsViewerLimit());
        broadcast.setSubTrackStreamIds(newBroadcast.getSubTrackStreamIds());
    }

    public long getLocalLiveBroadcastCount(String hostAddress) {
        return this.getActiveBroadcastCount();
    }

    protected ArrayList<VoD> searchOnServerVod(ArrayList<VoD> broadcastList, String search) {
        if (search != null && !search.isEmpty()) {
            Iterator<VoD> i = broadcastList.iterator();
            while (i.hasNext()) {
                VoD item = i.next();
                if (item.getVodName() != null && item.getStreamName() != null && item.getStreamId() != null && item.getVodId() != null) {
                    if (item.getVodName().toLowerCase().contains(search.toLowerCase()) || item.getStreamId().toLowerCase().contains(search.toLowerCase()) || item.getStreamName().toLowerCase().contains(search.toLowerCase()) || item.getVodId().toLowerCase().contains(search.toLowerCase())) continue;
                    i.remove();
                    continue;
                }
                if (item.getVodName() != null && item.getVodId() != null) {
                    if (item.getVodName().toLowerCase().contains(search.toLowerCase()) || item.getVodId().toLowerCase().contains(search.toLowerCase())) continue;
                    i.remove();
                    continue;
                }
                if (item.getVodId() == null || item.getVodId().toLowerCase().contains(search.toLowerCase())) continue;
                i.remove();
            }
        }
        return broadcastList;
    }

    protected List<VoD> sortAndCropVodList(List<VoD> vodList, int offset, int size, String sortBy, String orderBy) {
        int toIndex;
        if (("name".equals(sortBy) || "date".equals(sortBy)) && orderBy != null) {
            Collections.sort(vodList, (vod1, vod2) -> {
                Object c1 = null;
                Object c2 = null;
                if (sortBy.contentEquals("name")) {
                    c1 = vod1.getVodName().toLowerCase();
                    c2 = vod2.getVodName().toLowerCase();
                } else if (sortBy.contentEquals("date")) {
                    c1 = vod1.getCreationDate();
                    c2 = vod2.getCreationDate();
                }
                int result = 0;
                if (c1 != null && c2 != null) {
                    result = orderBy.contentEquals("desc") ? c2.compareTo(c1) : c1.compareTo(c2);
                }
                return result;
            });
        }
        if (size > 250) {
            size = 250;
        }
        if (offset < 0) {
            offset = 0;
        }
        if (offset >= (toIndex = Math.min(offset + size, vodList.size()))) {
            return new ArrayList<VoD>();
        }
        return vodList.subList(offset, Math.min(offset + size, vodList.size()));
    }

    protected ArrayList<Broadcast> searchOnServer(ArrayList<Broadcast> broadcastList, String search) {
        if (search != null && !search.isEmpty()) {
            Iterator<Broadcast> i = broadcastList.iterator();
            while (i.hasNext()) {
                Broadcast item = i.next();
                if (item.getName() != null && item.getStreamId() != null) {
                    if (item.getName().toLowerCase().contains(search.toLowerCase()) || item.getStreamId().toLowerCase().contains(search.toLowerCase())) continue;
                    i.remove();
                    continue;
                }
                if (item.getStreamId().toLowerCase().contains(search.toLowerCase())) continue;
                i.remove();
            }
        }
        return broadcastList;
    }

    protected List<Broadcast> sortAndCropBroadcastList(List<Broadcast> broadcastList, int offset, int size, final String sortBy, final String orderBy) {
        int toIndex;
        if (("name".equals(sortBy) || "date".equals(sortBy) || "status".equals(sortBy)) && orderBy != null) {
            Collections.sort(broadcastList, new Comparator<Broadcast>(){

                @Override
                public int compare(Broadcast broadcast1, Broadcast broadcast2) {
                    Object c1 = null;
                    Object c2 = null;
                    if (sortBy.equals("name")) {
                        c1 = broadcast1.getName().toLowerCase();
                        c2 = broadcast2.getName().toLowerCase();
                    } else if (sortBy.equals("date")) {
                        c1 = broadcast1.getDate();
                        c2 = broadcast2.getDate();
                    } else if (sortBy.equals("status")) {
                        c1 = broadcast1.getStatus();
                        c2 = broadcast2.getStatus();
                    }
                    int result = 0;
                    if (c1 != null && c2 != null) {
                        result = orderBy.equals("desc") ? c2.compareTo(c1) : c1.compareTo(c2);
                    }
                    return result;
                }
            });
        }
        if (size > 250) {
            size = 250;
        }
        if (offset < 0) {
            offset = 0;
        }
        if (offset >= (toIndex = Math.min(offset + size, broadcastList.size()))) {
            return new ArrayList<Broadcast>();
        }
        return broadcastList.subList(offset, toIndex);
    }

    protected ArrayList<ConferenceRoom> searchOnServerConferenceRoom(ArrayList<ConferenceRoom> roomList, String search) {
        if (search != null && !search.isEmpty()) {
            Iterator<ConferenceRoom> i = roomList.iterator();
            while (i.hasNext()) {
                ConferenceRoom item = i.next();
                if (item.getRoomId() == null || item.getRoomId().toLowerCase().contains(search.toLowerCase())) continue;
                i.remove();
            }
        }
        return roomList;
    }

    protected List<ConferenceRoom> sortAndCropConferenceRoomList(List<ConferenceRoom> roomList, int offset, int size, String sortBy, String orderBy) {
        int toIndex;
        if ("roomId".equals(sortBy) || "startDate".equals(sortBy) || "endDate".equals(sortBy)) {
            Collections.sort(roomList, (room1, room2) -> {
                Object c1 = null;
                Object c2 = null;
                if (sortBy.equals("roomId")) {
                    c1 = room1.getRoomId().toLowerCase();
                    c2 = room2.getRoomId().toLowerCase();
                } else if (sortBy.equals("startDate")) {
                    c1 = room1.getStartDate();
                    c2 = room2.getStartDate();
                } else if (sortBy.equals("endDate")) {
                    c1 = room1.getEndDate();
                    c2 = room2.getEndDate();
                }
                int result = 0;
                if (c1 != null && c2 != null) {
                    result = "desc".equals(orderBy) ? c2.compareTo(c1) : c1.compareTo(c2);
                }
                return result;
            });
        }
        if (size > 250) {
            size = 250;
        }
        if (offset < 0) {
            offset = 0;
        }
        if (offset >= (toIndex = Math.min(offset + size, roomList.size()))) {
            return new ArrayList<ConferenceRoom>();
        }
        return roomList.subList(offset, toIndex);
    }

    public abstract boolean createP2PConnection(P2PConnection var1);

    public abstract P2PConnection getP2PConnection(String var1);

    public abstract boolean deleteP2PConnection(String var1);

    public abstract boolean addSubTrack(String var1, String var2);

    public abstract int resetBroadcasts(String var1);

    public boolean isAvailable() {
        return this.available;
    }

    public abstract int getTotalWebRTCViewersCount();

    protected ArrayList<WebRTCViewerInfo> searchOnWebRTCViewerInfo(ArrayList<WebRTCViewerInfo> list, String search) {
        if (search != null && !search.isEmpty()) {
            Iterator<WebRTCViewerInfo> i = list.iterator();
            while (i.hasNext()) {
                WebRTCViewerInfo item = i.next();
                if (item.getViewerId() == null || item.getViewerId().toLowerCase().contains(search.toLowerCase())) continue;
                i.remove();
            }
        }
        return list;
    }

    protected List<WebRTCViewerInfo> sortAndCropWebRTCViewerInfoList(List<WebRTCViewerInfo> list, int offset, int size, String sortBy, String orderBy) {
        int toIndex;
        if ("viewerId".equals(sortBy)) {
            Collections.sort(list, (viewer1, viewer2) -> {
                String c1 = viewer1.getViewerId();
                String c2 = viewer2.getViewerId();
                return "desc".equals(orderBy) ? c2.compareTo(c1) : c1.compareTo(c2);
            });
        }
        if (size > 250) {
            size = 250;
        }
        if (offset < 0) {
            offset = 0;
        }
        if (offset >= (toIndex = Math.min(offset + size, list.size()))) {
            return new ArrayList<WebRTCViewerInfo>();
        }
        return list.subList(offset, toIndex);
    }

    public abstract void saveViewerInfo(WebRTCViewerInfo var1);

    public abstract List<WebRTCViewerInfo> getWebRTCViewerList(int var1, int var2, String var3, String var4, String var5);

    public abstract boolean deleteWebRTCViewerInfo(String var1);

    public abstract boolean updateStreamMetaData(String var1, String var2);
}

