/*
 * Decompiled with CFR 0.152.
 */
package io.antmedia.datastore.db.types;

import com.fasterxml.jackson.annotation.JsonIgnore;
import dev.morphia.annotations.Entity;
import dev.morphia.annotations.Field;
import dev.morphia.annotations.Id;
import dev.morphia.annotations.Index;
import dev.morphia.annotations.Indexes;
import io.antmedia.datastore.db.types.Endpoint;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import org.bson.types.ObjectId;

@ApiModel(value="Broadcast", description="The basic broadcast class")
@Entity(value="broadcast")
@Indexes(value={@Index(fields={@Field(value="name")}), @Index(fields={@Field(value="streamId")})})
public class Broadcast {
    @JsonIgnore
    @Id
    private ObjectId dbId;
    @ApiModelProperty(value="the id of the stream")
    private String streamId;
    @ApiModelProperty(value="the status of the stream", allowableValues="finished, broadcasting,created")
    private String status;
    @ApiModelProperty(value="The status of the playlist. It's usable if type is playlist", allowableValues="finished, broadcasting,created")
    private String playListStatus;
    @ApiModelProperty(value="the type of the stream", allowableValues="liveStream, ipCamera,streamSource,VoD,playlist")
    private String type;
    @ApiModelProperty(value="the publish type of the stream", allowableValues="WebRTC, RTMP, Pull")
    private String publishType;
    @ApiModelProperty(value="the name of the stream")
    private String name;
    @ApiModelProperty(value="the description of the stream")
    private String description;
    @ApiModelProperty(value="it is a video filter for the service, this value is controlled by the user, default value is true in the db")
    private boolean publish = true;
    @ApiModelProperty(value="the date when record is created in milliseconds")
    private long date;
    @ApiModelProperty(value="the planned start date")
    private long plannedStartDate;
    @ApiModelProperty(value="the planned end date")
    private long plannedEndDate;
    @ApiModelProperty(value="the duration of the stream in milliseconds")
    private long duration;
    @ApiModelProperty(value="the list of endpoints such as Facebook, Twitter or custom RTMP endpoints  ")
    private List<Endpoint> endPointList;
    @ApiModelProperty(value="the list broadcasts of Playlist Items. This list has values when the broadcast type is playlist")
    private List<PlayListItem> playListItemList;
    @ApiModelProperty(value="the identifier of whether stream is public or not")
    private boolean publicStream = true;
    @ApiModelProperty(value="the identifier of whether stream is 360 or not")
    private boolean is360 = false;
    @ApiModelProperty(value="the url that will be notified when stream is published, ended and muxing finished")
    private String listenerHookURL;
    @ApiModelProperty(value="the category of the stream")
    private String category;
    @ApiModelProperty(value="the IP Address of the IP Camera or publisher")
    private String ipAddr;
    @ApiModelProperty(value="the user name of the IP Camera")
    private String username;
    @ApiModelProperty(value="the password of the IP Camera")
    private String password;
    @ApiModelProperty(value="the quality of the incoming stream during publishing")
    private String quality;
    @ApiModelProperty(value="the speed of the incoming stream, for better quality and performance it should be around 1.00")
    private double speed;
    @ApiModelProperty(value="the stream URL for fetching stream, especially should be defined for IP Cameras or Cloud streams")
    private String streamUrl;
    @ApiModelProperty(value="the origin address server broadcasting")
    private String originAdress;
    @ApiModelProperty(value="MP4 muxing whether enabled or not for the stream, 1 means enabled, -1 means disabled, 0 means no settings for the stream")
    private int mp4Enabled = 0;
    @ApiModelProperty(value="WebM muxing whether enabled or not for the stream, 1 means enabled, -1 means disabled, 0 means no settings for the stream")
    private int webMEnabled = 0;
    @ApiModelProperty(value="the expire time in milliseconds For instance if this value is 10000 then broadcast should be started in 10 seconds after it is created.If expire duration is 0, then stream will never expire")
    private int expireDurationMS;
    @ApiModelProperty(value="the RTMP URL where to publish live stream to")
    private String rtmpURL;
    @ApiModelProperty(value="is true, if a broadcast that is not added to data store through rest service or management console It is false by default")
    private boolean zombi = false;
    @ApiModelProperty(value="the number of audio and video packets that is being pending to be encoded in the queue ")
    private int pendingPacketSize = 0;
    @ApiModelProperty(value="the number of HLS viewers of the stream")
    private int hlsViewerCount = 0;
    @ApiModelProperty(value="the number of WebRTC viewers of the stream")
    private int webRTCViewerCount = 0;
    @ApiModelProperty(value="the number of RTMP viewers of the stream")
    private int rtmpViewerCount = 0;
    @ApiModelProperty(value="the publishing start time of the stream")
    private long startTime = 0L;
    @ApiModelProperty(value="the received bytes until now")
    private long receivedBytes = 0L;
    @ApiModelProperty(value="the received bytes / duration")
    private long bitrate = 0L;
    @ApiModelProperty(value="User - Agent")
    private String userAgent = "N/A";
    @ApiModelProperty(value="latitude of the broadcasting location")
    private String latitude;
    @ApiModelProperty(value="longitude of the broadcasting location")
    private String longitude;
    @ApiModelProperty(value="altitude of the broadcasting location")
    private String altitude;
    @ApiModelProperty(value="If this broadcast is a track of a WebRTC stream. This variable is Id of that stream.")
    private String mainTrackStreamId;
    @ApiModelProperty(value="If this broadcast is main track. This variable hold sub track ids.")
    private List<String> subTrackStreamIds = new ArrayList<String>();
    @ApiModelProperty(value="Absolute start time in milliseconds - unix timestamp. It's used for measuring the absolute latency")
    private long absoluteStartTimeMs;
    @ApiModelProperty(value="Number of the allowed maximum WebRTC viewers for the broadcast")
    private int webRTCViewerLimit = -1;
    @ApiModelProperty(value="Number of the allowed maximum HLS viewers for the broadcast")
    private int hlsViewerLimit = -1;
    @ApiModelProperty(value="Name of the subfolder that will contain stream files")
    private String subFolder;
    @ApiModelProperty(value="Current playing index for playlist types")
    private int currentPlayIndex = 0;
    @ApiModelProperty(value="Meta data filed for the custom usage")
    private String metaData = "";

    public Broadcast() {
        this.type = "liveStream";
    }

    public Broadcast(String status, String name) {
        this.setStatus(status);
        this.setName(name);
        this.type = "liveStream";
    }

    public Broadcast(String name) {
        this.name = name;
        this.type = "liveStream";
    }

    public Broadcast(String name, String ipAddr, String username, String password, String streamUrl, String type) {
        this.name = name;
        this.ipAddr = ipAddr;
        this.username = username;
        this.password = password;
        this.streamUrl = streamUrl;
        this.type = type;
    }

    public String getStreamId() {
        if (this.streamId != null) {
            return this.streamId;
        }
        if (this.dbId == null) {
            return null;
        }
        return this.dbId.toString();
    }

    public void setStreamId(String id) throws Exception {
        if (id == null) {
            throw new Exception("stream id cannot be null");
        }
        this.streamId = id;
    }

    public double getSpeed() {
        return this.speed;
    }

    public void setSpeed(double speed) {
        this.speed = speed;
    }

    public String getQuality() {
        return this.quality;
    }

    public void setQuality(String quality) {
        this.quality = quality;
    }

    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public boolean isPublish() {
        return this.publish;
    }

    public void setPublish(boolean publish) {
        this.publish = publish;
    }

    public long getDate() {
        return this.date;
    }

    public void setDate(long date) {
        this.date = date;
    }

    public long getPlannedStartDate() {
        return this.plannedStartDate;
    }

    public void setPlannedStartDate(long plannedStartDate) {
        this.plannedStartDate = plannedStartDate;
    }

    public long getPlannedEndDate() {
        return this.plannedEndDate;
    }

    public void setPlannedEndDate(long plannedEndDate) {
        this.plannedEndDate = plannedEndDate;
    }

    public long getDuration() {
        return this.duration;
    }

    public void setDuration(Long duration) {
        this.duration = duration;
    }

    public List<Endpoint> getEndPointList() {
        return this.endPointList;
    }

    public void setEndPointList(List<Endpoint> endPointList) {
        this.endPointList = endPointList;
    }

    public boolean isIs360() {
        return this.is360;
    }

    public void setIs360(boolean is360) {
        this.is360 = is360;
    }

    public boolean isPublicStream() {
        return this.publicStream;
    }

    public void setPublicStream(boolean publicStream) {
        this.publicStream = publicStream;
    }

    public String getListenerHookURL() {
        return this.listenerHookURL;
    }

    public void setListenerHookURL(String listenerHookURL) {
        this.listenerHookURL = listenerHookURL;
    }

    public String getCategory() {
        return this.category;
    }

    public void setCategory(String category) {
        this.category = category;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getIpAddr() {
        return this.ipAddr;
    }

    public void setIpAddr(String ipAddr) {
        this.ipAddr = ipAddr;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public int getExpireDurationMS() {
        return this.expireDurationMS;
    }

    public void setExpireDurationMS(int expireDurationMS) {
        this.expireDurationMS = expireDurationMS;
    }

    public String getRtmpURL() {
        return this.rtmpURL;
    }

    public void setRtmpURL(String rtmpURL) {
        this.rtmpURL = rtmpURL;
    }

    public ObjectId getDbId() {
        return this.dbId;
    }

    public void setDbId(ObjectId dbId) {
        this.dbId = dbId;
    }

    public boolean isZombi() {
        return this.zombi;
    }

    public void setZombi(boolean zombi) {
        this.zombi = zombi;
    }

    public void resetStreamId() {
        this.streamId = null;
    }

    public String getStreamUrl() {
        return this.streamUrl;
    }

    public void setStreamUrl(String streamUrl) {
        this.streamUrl = streamUrl;
    }

    public int getHlsViewerCount() {
        return this.hlsViewerCount;
    }

    public void setHlsViewerCount(int hlsViewerCount) {
        this.hlsViewerCount = hlsViewerCount;
    }

    public int getWebRTCViewerCount() {
        return this.webRTCViewerCount;
    }

    public void setWebRTCViewerCount(int webRTCViewerCount) {
        this.webRTCViewerCount = webRTCViewerCount;
    }

    public int getRtmpViewerCount() {
        return this.rtmpViewerCount;
    }

    public void setRtmpViewerCount(int rtmpViewerCount) {
        this.rtmpViewerCount = rtmpViewerCount;
    }

    public int getPendingPacketSize() {
        return this.pendingPacketSize;
    }

    public void setPendingPacketSize(int pendingPacketSize) {
        this.pendingPacketSize = pendingPacketSize;
    }

    public String getOriginAdress() {
        return this.originAdress;
    }

    public void setOriginAdress(String originAdress) {
        this.originAdress = originAdress;
    }

    public int getMp4Enabled() {
        return this.mp4Enabled;
    }

    public void setMp4Enabled(int mp4Enabled) {
        this.mp4Enabled = mp4Enabled;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public void setStartTime(long startTime) {
        this.startTime = startTime;
    }

    public long getReceivedBytes() {
        return this.receivedBytes;
    }

    public void setReceivedBytes(long receivedBytes) {
        this.receivedBytes = receivedBytes;
    }

    public long getBitrate() {
        return this.bitrate;
    }

    public void setBitrate(long bitrate) {
        this.bitrate = bitrate;
    }

    public String getUserAgent() {
        return this.userAgent;
    }

    public void setUserAgent(String userAgent) {
        this.userAgent = userAgent;
    }

    public String getLatitude() {
        return this.latitude;
    }

    public void setLatitude(String latitude) {
        this.latitude = latitude;
    }

    public String getLongitude() {
        return this.longitude;
    }

    public void setLongitude(String longitude) {
        this.longitude = longitude;
    }

    public String getAltitude() {
        return this.altitude;
    }

    public void setAltitude(String altitude) {
        this.altitude = altitude;
    }

    public String getMainTrackStreamId() {
        return this.mainTrackStreamId;
    }

    public void setMainTrackStreamId(String mainTrackStreamId) {
        this.mainTrackStreamId = mainTrackStreamId;
    }

    public List<String> getSubTrackStreamIds() {
        return this.subTrackStreamIds;
    }

    public void setSubTrackStreamIds(List<String> subTrackStreamIds) {
        this.subTrackStreamIds = subTrackStreamIds;
    }

    public void setAbsoluteStartTimeMs(long absoluteStartTimeMs) {
        this.absoluteStartTimeMs = absoluteStartTimeMs;
    }

    public long getAbsoluteStartTimeMs() {
        return this.absoluteStartTimeMs;
    }

    public int getWebMEnabled() {
        return this.webMEnabled;
    }

    public void setWebMEnabled(int webMEnabled) {
        this.webMEnabled = webMEnabled;
    }

    public int getWebRTCViewerLimit() {
        return this.webRTCViewerLimit;
    }

    public void setWebRTCViewerLimit(int webRTCViewerLimit) {
        this.webRTCViewerLimit = webRTCViewerLimit;
    }

    public int getHlsViewerLimit() {
        return this.hlsViewerLimit;
    }

    public void setHlsViewerLimit(int hlsViewerLimit) {
        this.hlsViewerLimit = hlsViewerLimit;
    }

    public List<PlayListItem> getPlayListItemList() {
        return this.playListItemList;
    }

    public void setPlayListItemList(List<PlayListItem> playListItemList) {
        this.playListItemList = playListItemList;
    }

    public int getCurrentPlayIndex() {
        return this.currentPlayIndex;
    }

    public void setCurrentPlayIndex(int currentPlayIndex) {
        this.currentPlayIndex = currentPlayIndex;
    }

    public void setPlayListStatus(String playListStatus) {
        this.playListStatus = playListStatus;
    }

    public String getPlayListStatus() {
        return this.playListStatus;
    }

    public void setSubFolder(String subFolder) {
        this.subFolder = subFolder;
    }

    public String getSubFolder() {
        return this.subFolder;
    }

    public String getPublishType() {
        return this.publishType;
    }

    public void setPublishType(String publishType) {
        this.publishType = publishType;
    }

    public String getMetaData() {
        return this.metaData;
    }

    public void setMetaData(String metaData) {
        this.metaData = metaData;
    }

    @Entity
    public static class PlayListItem {
        String streamUrl;
        String type;

        public PlayListItem() {
        }

        public PlayListItem(String streamUrl, String type) {
            this.streamUrl = streamUrl;
            this.type = type;
        }

        public String getStreamUrl() {
            return this.streamUrl;
        }

        public void setStreamUrl(String streamUrl) {
            this.streamUrl = streamUrl;
        }

        public String getType() {
            return this.type;
        }

        public void setType(String type) {
            this.type = type;
        }
    }
}

