/*
 * Decompiled with CFR 0.152.
 */
package io.antmedia.datastore.db.types;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import dev.morphia.annotations.Entity;
import dev.morphia.annotations.Field;
import dev.morphia.annotations.Id;
import dev.morphia.annotations.Index;
import dev.morphia.annotations.Indexes;
import io.antmedia.rest.model.UserType;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import org.bson.types.ObjectId;

@ApiModel(value="User", description="The basic user class")
@Entity(value="user")
@Indexes(value={@Index(fields={@Field(value="email")}), @Index(fields={@Field(value="fullName")})})
public class User {
    @ApiModelProperty(value="the email of the user")
    private String email;
    @ApiModelProperty(value="the password of the user")
    @JsonProperty(access=JsonProperty.Access.WRITE_ONLY)
    private String password;
    @ApiModelProperty(value="the type of the user", allowableValues="ADMIN, READ-ONLY, USER")
    private UserType userType;
    @ApiModelProperty(value="Scope can be 'system' or name of the application. Scope of the user. If it's scope is system, it can access the stuff in system-level. If it's scope is an application, it can access the stuff in application-levelIt makes more sense with UserType")
    private String scope;
    @ApiModelProperty(value="the new password of the user")
    @JsonProperty(access=JsonProperty.Access.WRITE_ONLY)
    private String newPassword;
    @ApiModelProperty(value="the name of the user")
    private String fullName;
    @ApiModelProperty(value="the URL of the user picture")
    private String picture;
    @ApiModelProperty(value="the id of the user")
    @JsonIgnore
    @Id
    private ObjectId id;

    public User(String email, String password, UserType userType, String scope) {
        this.email = email;
        this.password = password;
        this.userType = userType;
        this.scope = scope;
    }

    public User() {
    }

    public String getEmail() {
        return this.email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public String getScope() {
        return this.scope;
    }

    public void setScope(String scope) {
        this.scope = scope;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public UserType getUserType() {
        return this.userType;
    }

    public void setUserType(UserType userType) {
        this.userType = userType;
    }

    public String getNewPassword() {
        return this.newPassword;
    }

    public void setNewPassword(String newPassword) {
        this.newPassword = newPassword;
    }

    public String getFullName() {
        return this.fullName;
    }

    public void setFullName(String fullName) {
        this.fullName = fullName;
    }

    public String getPicture() {
        return this.picture;
    }

    public void setPicture(String picture) {
        this.picture = picture;
    }
}

