/*
 * Decompiled with CFR 0.152.
 */
package io.antmedia.muxer;

import io.vertx.core.Vertx;
import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.bytedeco.ffmpeg.avcodec.AVCodec;
import org.bytedeco.ffmpeg.avcodec.AVCodecContext;
import org.bytedeco.ffmpeg.avcodec.AVCodecParameters;
import org.bytedeco.ffmpeg.avcodec.AVPacket;
import org.bytedeco.ffmpeg.avformat.AVFormatContext;
import org.bytedeco.ffmpeg.avformat.AVStream;
import org.bytedeco.ffmpeg.avutil.AVRational;
import org.bytedeco.ffmpeg.global.avcodec;
import org.red5.server.api.scope.IScope;
import org.red5.server.api.stream.IStreamFilenameGenerator;
import org.red5.server.stream.DefaultStreamFilenameGenerator;
import org.red5.server.util.ScopeUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.Resource;

public abstract class Muxer {
    protected String extension;
    protected String format;
    protected boolean isInitialized = false;
    protected Map<String, String> options = new HashMap<String, String>();
    private static Logger logger = LoggerFactory.getLogger(Muxer.class);
    protected AVFormatContext outputFormatContext;
    public static final String DATE_TIME_PATTERN = "yyyy-MM-dd_HH-mm-ss.SSS";
    protected File file;
    protected boolean isRecording;
    protected Vertx vertx;
    protected IScope scope;
    private boolean addDateTimeToResourceName = false;
    protected AtomicBoolean isRunning = new AtomicBoolean(false);
    public static final String TEMP_EXTENSION = ".tmp_extension";
    protected int time2log = 0;
    protected AVPacket audioPkt;
    protected List<Integer> registeredStreamIndexList = new ArrayList<Integer>();
    protected String bsfName = null;
    protected String streamId = null;
    protected String initialResourceNameWithoutExtension;

    protected Muxer(Vertx vertx) {
        this.vertx = vertx;
    }

    public static File getPreviewFile(IScope scope, String name, String extension) {
        String appScopeName = ScopeUtils.findApplication(scope).getName();
        return new File(String.format("%s/webapps/%s/%s", System.getProperty("red5.root"), appScopeName, "previews/" + name + extension));
    }

    public static File getRecordFile(IScope scope, String name, String extension, String subFolder) {
        IStreamFilenameGenerator generator = (IStreamFilenameGenerator)ScopeUtils.getScopeService(scope, IStreamFilenameGenerator.class, DefaultStreamFilenameGenerator.class);
        String fileName = generator.generateFilename(scope, name, extension, IStreamFilenameGenerator.GenerationType.RECORD, subFolder);
        File file = null;
        if (generator.resolvesToAbsolutePath()) {
            file = new File(fileName);
        } else {
            Resource resource = scope.getContext().getResource(fileName);
            if (resource.exists()) {
                try {
                    file = resource.getFile();
                    logger.debug("File exists: {} writable: {}", (Object)file.exists(), (Object)file.canWrite());
                }
                catch (IOException ioe) {
                    logger.error("File error: {}", (Object)ExceptionUtils.getStackTrace((Throwable)ioe));
                }
            } else {
                String appScopeName = ScopeUtils.findApplication(scope).getName();
                file = new File(String.format("%s/webapps/%s/%s", System.getProperty("red5.root"), appScopeName, fileName));
            }
        }
        return file;
    }

    public static File getUserRecordFile(IScope scope, String userVoDFolder, String name) {
        String appScopeName = ScopeUtils.findApplication(scope).getName();
        return new File(String.format("%s/webapps/%s/%s", System.getProperty("red5.root"), appScopeName, "streams/" + userVoDFolder + "/" + name));
    }

    public abstract boolean addStream(AVCodec var1, AVCodecContext var2, int var3);

    public abstract boolean prepareIO();

    public abstract void writeTrailer();

    public abstract void writePacket(AVPacket var1, AVStream var2);

    public abstract void writePacket(AVPacket var1, AVCodecContext var2);

    public void setBitstreamFilter(String bsfName) {
        this.bsfName = bsfName;
    }

    public File getFile() {
        return this.file;
    }

    public String getFileName() {
        if (this.file != null) {
            return this.file.getName();
        }
        return null;
    }

    public String getFormat() {
        return this.format;
    }

    public void init(IScope scope, String name, int resolution, String subFolder, int bitrate) {
        this.streamId = name;
        this.init(scope, name, resolution, true, subFolder, bitrate);
    }

    public void init(IScope scope, String name, int resolution, boolean overrideIfExist, String subFolder, int bitrate) {
        if (!this.isInitialized) {
            this.isInitialized = true;
            this.scope = scope;
            this.initialResourceNameWithoutExtension = this.getExtendedName(name, resolution, bitrate);
            this.file = this.getResourceFile(scope, this.initialResourceNameWithoutExtension, this.extension, subFolder);
            File parentFile = this.file.getParentFile();
            if (!parentFile.exists()) {
                parentFile.mkdirs();
            } else {
                File tempFile = this.getResourceFile(scope, this.initialResourceNameWithoutExtension, this.extension + TEMP_EXTENSION, subFolder);
                if (!overrideIfExist && (this.file.exists() || tempFile.exists())) {
                    Object tmpName = this.initialResourceNameWithoutExtension;
                    int i = 1;
                    do {
                        tempFile = this.getResourceFile(scope, (String)tmpName, this.extension + TEMP_EXTENSION, subFolder);
                        this.file = this.getResourceFile(scope, (String)tmpName, this.extension, subFolder);
                        tmpName = this.initialResourceNameWithoutExtension + "_" + i;
                        ++i;
                    } while (this.file.exists() || tempFile.exists());
                }
            }
            this.audioPkt = avcodec.av_packet_alloc();
            avcodec.av_init_packet((AVPacket)this.audioPkt);
        }
    }

    public String getExtendedName(String name, int resolution, int bitrate) {
        Object resourceName = name;
        int bitrateKbps = bitrate / 1000;
        if (this.addDateTimeToResourceName) {
            LocalDateTime ldt = LocalDateTime.now();
            resourceName = name + "-" + ldt.format(DateTimeFormatter.ofPattern(DATE_TIME_PATTERN));
            if (logger.isInfoEnabled()) {
                logger.info("Date time resource name: {} local date time: {}", resourceName, (Object)ldt.format(DateTimeFormatter.ofPattern(DATE_TIME_PATTERN)));
            }
        }
        if (resolution != 0) {
            resourceName = (String)resourceName + "_" + resolution + "p";
            if (bitrate != 0) {
                resourceName = (String)resourceName + bitrateKbps + "kbps";
            }
        }
        return resourceName;
    }

    public File getResourceFile(IScope scope, String name, String extension, String subFolder) {
        return Muxer.getRecordFile(scope, name, extension, subFolder);
    }

    public boolean isAddDateTimeToSourceName() {
        return this.addDateTimeToResourceName;
    }

    public void setAddDateTimeToSourceName(boolean addDateTimeToSourceName) {
        this.addDateTimeToResourceName = addDateTimeToSourceName;
    }

    public void writeVideoBuffer(ByteBuffer encodedVideoFrame, long dts, int frameRotation, int streamIndex, boolean isKeyFrame, long firstFrameTimeStamp, long pts) {
    }

    public boolean addVideoStream(int width, int height, AVRational videoTimebase, int codecId, int streamIndex, boolean isAVC, AVCodecParameters codecpar) {
        return false;
    }

    public boolean addAudioStream(int sampleRate, int channelLayout, int codecId, int streamIndex) {
        return false;
    }

    public abstract boolean addStream(AVCodecParameters var1, AVRational var2, int var3);

    public void writeAudioBuffer(ByteBuffer byteBuffer, int i, long timestamp) {
    }

    public List<Integer> getRegisteredStreamIndexList() {
        return this.registeredStreamIndexList;
    }

    public void setIsRunning(AtomicBoolean isRunning) {
        this.isRunning = isRunning;
    }
}

