/*
 * Decompiled with CFR 0.152.
 */
package io.antmedia.muxer;

import io.antmedia.muxer.IEndpointStatusListener;
import io.antmedia.muxer.Muxer;
import io.vertx.core.Vertx;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import org.bytedeco.ffmpeg.avcodec.AVBSFContext;
import org.bytedeco.ffmpeg.avcodec.AVBitStreamFilter;
import org.bytedeco.ffmpeg.avcodec.AVCodec;
import org.bytedeco.ffmpeg.avcodec.AVCodecContext;
import org.bytedeco.ffmpeg.avcodec.AVCodecParameters;
import org.bytedeco.ffmpeg.avcodec.AVPacket;
import org.bytedeco.ffmpeg.avformat.AVFormatContext;
import org.bytedeco.ffmpeg.avformat.AVIOContext;
import org.bytedeco.ffmpeg.avformat.AVStream;
import org.bytedeco.ffmpeg.avutil.AVDictionary;
import org.bytedeco.ffmpeg.avutil.AVRational;
import org.bytedeco.ffmpeg.global.avcodec;
import org.bytedeco.ffmpeg.global.avformat;
import org.bytedeco.ffmpeg.global.avutil;
import org.bytedeco.javacpp.BytePointer;
import org.bytedeco.javacpp.IntPointer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RtmpMuxer
extends Muxer {
    protected static Logger logger = LoggerFactory.getLogger(RtmpMuxer.class);
    private String url;
    private AVPacket videoPkt;
    private Map<Integer, AVRational> codecTimeBaseMap = new HashMap<Integer, AVRational>();
    private AVBSFContext bsfExtractdataContext = null;
    private AVPacket tmpPacket;
    private volatile boolean headerWritten = false;
    private volatile boolean trailerWritten = false;
    private IEndpointStatusListener statusListener;
    private BytePointer allocatedExtraDataPointer = null;
    private String status = "created";
    boolean keyFrameReceived = false;
    private int audioIndex;
    private int videoIndex;
    private AtomicBoolean preparedIO = new AtomicBoolean(false);

    public RtmpMuxer(String url, Vertx vertx) {
        super(vertx);
        this.format = "flv";
        this.url = url;
        this.videoPkt = avcodec.av_packet_alloc();
        avcodec.av_init_packet((AVPacket)this.videoPkt);
        this.tmpPacket = avcodec.av_packet_alloc();
        avcodec.av_init_packet((AVPacket)this.tmpPacket);
    }

    public String getURL() {
        return this.url;
    }

    @Override
    public synchronized boolean addStream(AVCodec codec, AVCodecContext codecContext, int streamIndex) {
        AVFormatContext outputContext = this.getOutputFormatContext();
        if (outputContext == null) {
            this.setStatus("failed");
            return false;
        }
        this.registeredStreamIndexList.add(streamIndex);
        AVStream outStream = avformat.avformat_new_stream((AVFormatContext)outputContext, (AVCodec)codec);
        outStream.time_base(codecContext.time_base());
        int ret = avcodec.avcodec_parameters_from_context((AVCodecParameters)outStream.codecpar(), (AVCodecContext)codecContext);
        if (ret < 0) {
            this.setStatus("failed");
            logger.info("codec context cannot be copied for url: {}", (Object)this.url);
        }
        outStream.codecpar().codec_tag(0);
        this.codecTimeBaseMap.put(streamIndex, codecContext.time_base());
        logger.info("Adding stream index:{} for stream:{} codec type:{}", new Object[]{streamIndex, this.url, codecContext.codec_type()});
        this.setStatus("preparing");
        return true;
    }

    public void setStatusListener(IEndpointStatusListener listener) {
        this.statusListener = listener;
    }

    private AVFormatContext getOutputFormatContext() {
        if (this.outputFormatContext == null) {
            logger.info("Creating outputFormatContext");
            this.outputFormatContext = new AVFormatContext(null);
            int ret = avformat.avformat_alloc_output_context2((AVFormatContext)this.outputFormatContext, null, (String)this.format, null);
            if (ret < 0) {
                this.setStatus("failed");
                logger.info("Could not create output context for url {}", (Object)this.url);
                return null;
            }
        }
        return this.outputFormatContext;
    }

    public void setStatus(String status) {
        if (!this.status.equals(status) && this.statusListener != null) {
            this.statusListener.endpointStatusUpdated(this.url, status);
        }
        this.status = status;
    }

    public String getStatus() {
        return this.status;
    }

    public boolean initializeOutputFormatContextIO() {
        AVFormatContext context = this.getOutputFormatContext();
        boolean result = false;
        if (context != null && context.pb() == null) {
            AVIOContext pb = new AVIOContext(null);
            long startTime = System.currentTimeMillis();
            logger.info("rtmp muxer opening: {} time:{}", (Object)this.url, (Object)System.currentTimeMillis());
            int ret = avformat.avio_open((AVIOContext)pb, (String)this.url, (int)2);
            if (ret >= 0) {
                context.pb(pb);
                long diff = System.currentTimeMillis() - startTime;
                logger.info("avio open takes {}", (Object)diff);
                result = true;
            } else {
                logger.error("Could not open output file for rtmp url {}", (Object)this.url);
                this.clearResource();
                this.setStatus("failed");
            }
        }
        return result;
    }

    @Override
    public boolean prepareIO() {
        if (this.preparedIO.get()) {
            return true;
        }
        this.preparedIO.set(true);
        this.vertx.executeBlocking(b -> {
            if (this.initializeOutputFormatContextIO()) {
                if (this.bsfExtractdataContext == null) {
                    this.writeHeader();
                    return;
                }
                this.isRunning.set(true);
                this.setStatus("broadcasting");
            } else {
                logger.error("Cannot initializeOutputFormatContextIO for rtmp endpoint:{}", (Object)this.url);
            }
        }, null);
        return true;
    }

    public synchronized boolean writeHeader() {
        if (!this.trailerWritten) {
            long startTime = System.currentTimeMillis();
            AVDictionary optionsDictionary = null;
            if (!this.options.isEmpty()) {
                optionsDictionary = new AVDictionary();
                Set keySet = this.options.keySet();
                for (String key : keySet) {
                    avutil.av_dict_set((AVDictionary)optionsDictionary, (String)key, (String)((String)this.options.get(key)), (int)0);
                }
            }
            logger.info("before writing rtmp muxer header to {}", (Object)this.url);
            int ret = avformat.avformat_write_header((AVFormatContext)this.getOutputFormatContext(), (AVDictionary)optionsDictionary);
            if (ret < 0) {
                this.setStatus("failed");
                logger.warn("could not write header to rtmp url {}", (Object)this.url);
                this.clearResource();
                return false;
            }
            if (optionsDictionary != null) {
                avutil.av_dict_free((AVDictionary)optionsDictionary);
                optionsDictionary = null;
            }
            long diff = System.currentTimeMillis() - startTime;
            logger.info("write header takes {}", (Object)diff);
            this.headerWritten = true;
            this.isRunning.set(true);
            this.setStatus("broadcasting");
            return true;
        }
        logger.warn("Trying to write header after writing trailer");
        return false;
    }

    @Override
    public synchronized void writeTrailer() {
        if (!this.isRunning.get() || this.outputFormatContext == null || this.outputFormatContext.pb() == null) {
            logger.info("RTMPMuxer is not running or output context is null for stream: {}", (Object)this.url);
            this.setStatus("failed");
            return;
        }
        if (this.headerWritten) {
            logger.info("Writing trailer for stream id: {}", (Object)this.url);
            this.isRunning.set(false);
            avformat.av_write_trailer((AVFormatContext)this.outputFormatContext);
            this.clearResource();
            this.trailerWritten = true;
        } else {
            logger.info("Not writing trailer because header is not written yet");
        }
        this.setStatus("finished");
        this.isRecording = false;
    }

    private synchronized void clearResource() {
        this.isRunning.set(false);
        if ((this.outputFormatContext.flags() & 1) == 0 && this.outputFormatContext.pb() != null) {
            avformat.avio_closep((AVIOContext)this.outputFormatContext.pb());
        }
        if (this.videoPkt != null) {
            avcodec.av_packet_free((AVPacket)this.videoPkt);
            this.videoPkt = null;
        }
        if (this.tmpPacket != null) {
            avcodec.av_packet_free((AVPacket)this.tmpPacket);
            this.tmpPacket = null;
        }
        if (this.audioPkt != null) {
            avcodec.av_packet_free((AVPacket)this.audioPkt);
            this.audioPkt = null;
        }
        if (this.bsfExtractdataContext != null) {
            avcodec.av_bsf_free((AVBSFContext)this.bsfExtractdataContext);
            this.bsfExtractdataContext = null;
        }
        avformat.avformat_free_context((AVFormatContext)this.outputFormatContext);
        this.outputFormatContext.close();
        this.outputFormatContext = null;
    }

    @Override
    public boolean addVideoStream(int width, int height, AVRational timebase, int codecId, int streamIndex, boolean isAVC, AVCodecParameters codecpar) {
        boolean result = false;
        AVFormatContext outputContext = this.getOutputFormatContext();
        if (outputContext != null) {
            this.registeredStreamIndexList.add(streamIndex);
            AVStream outStream = avformat.avformat_new_stream((AVFormatContext)outputContext, null);
            outStream.codecpar().width(width);
            outStream.codecpar().height(height);
            outStream.codecpar().codec_id(codecId);
            outStream.codecpar().codec_type(0);
            outStream.codecpar().format(0);
            outStream.codecpar().codec_tag(0);
            outStream.codec().codec_tag(0);
            AVRational timeBase = new AVRational();
            timeBase.num(1).den(1000);
            AVBitStreamFilter h264bsfc = avcodec.av_bsf_get_by_name((String)"extract_extradata");
            this.bsfExtractdataContext = new AVBSFContext(null);
            int ret = avcodec.av_bsf_alloc((AVBitStreamFilter)h264bsfc, (AVBSFContext)this.bsfExtractdataContext);
            if (ret < 0) {
                logger.info("cannot allocate bsf context for {}", (Object)this.file.getName());
                this.setStatus("failed");
                outStream.close();
                timeBase.close();
                return false;
            }
            ret = avcodec.avcodec_parameters_copy((AVCodecParameters)this.bsfExtractdataContext.par_in(), (AVCodecParameters)outStream.codecpar());
            if (ret < 0) {
                logger.info("cannot copy input codec parameters for {}", (Object)this.file.getName());
                this.setStatus("failed");
                outStream.close();
                timeBase.close();
                h264bsfc.close();
                return false;
            }
            this.bsfExtractdataContext.time_base_in(timeBase);
            ret = avcodec.av_bsf_init((AVBSFContext)this.bsfExtractdataContext);
            if (ret < 0) {
                logger.info("cannot init bit stream filter context for {}", (Object)this.file.getName());
                this.setStatus("failed");
                outStream.close();
                timeBase.close();
                h264bsfc.close();
                return false;
            }
            ret = avcodec.avcodec_parameters_copy((AVCodecParameters)outStream.codecpar(), (AVCodecParameters)this.bsfExtractdataContext.par_out());
            if (ret < 0) {
                logger.info("cannot copy codec parameters to output for {}", (Object)this.file.getName());
                this.setStatus("failed");
                outStream.close();
                timeBase.close();
                h264bsfc.close();
                return false;
            }
            outStream.time_base(this.bsfExtractdataContext.time_base_out());
            this.codecTimeBaseMap.put(streamIndex, timeBase);
            logger.info("Adding video stream index:{} for stream:{}", (Object)streamIndex, (Object)this.url);
            result = true;
        }
        return result;
    }

    @Override
    public synchronized void writePacket(AVPacket pkt, AVStream stream) {
        int streamIndex;
        if (!this.isRunning.get() || !this.registeredStreamIndexList.contains(pkt.stream_index())) {
            if (this.time2log % 100 == 0) {
                logger.warn("not registered stream index {}", (Object)this.file.getName());
                this.time2log = 0;
            }
            ++this.time2log;
            return;
        }
        if (stream.codecpar().codec_type() == 0) {
            streamIndex = this.videoIndex;
        } else if (stream.codecpar().codec_type() == 1) {
            streamIndex = this.audioIndex;
        } else {
            logger.error("Undefined codec type for stream: {} ", (Object)this.url);
            return;
        }
        AVStream outStream = this.outputFormatContext.streams(streamIndex);
        int index = pkt.stream_index();
        pkt.stream_index(streamIndex);
        this.writePacket(pkt, stream.time_base(), outStream.time_base(), outStream.codecpar().codec_type());
        pkt.stream_index(index);
    }

    @Override
    public synchronized void writePacket(AVPacket pkt, AVCodecContext codecContext) {
        if (!this.isRunning.get() || !this.registeredStreamIndexList.contains(pkt.stream_index())) {
            if (this.time2log % 100 == 0) {
                logger.warn("not registered stream index {}", (Object)this.file.getName());
                this.time2log = 0;
            }
            ++this.time2log;
            return;
        }
        AVStream outStream = this.outputFormatContext.streams(pkt.stream_index());
        AVRational codecTimebase = this.codecTimeBaseMap.get(pkt.stream_index());
        this.writePacket(pkt, codecTimebase, outStream.time_base(), outStream.codecpar().codec_type());
    }

    private void writePacket(AVPacket pkt, AVRational inputTimebase, AVRational outputTimebase, int codecType) {
        AVFormatContext context = this.getOutputFormatContext();
        if (context.streams(pkt.stream_index()).codecpar().codec_type() == 1 && !this.headerWritten) {
            logger.info("Not writing audio packet to muxer because header is not written yet for {}", (Object)this.url);
            return;
        }
        this.writeFrameInternal(pkt, inputTimebase, outputTimebase, context, codecType);
    }

    private synchronized void writeFrameInternal(AVPacket pkt, AVRational inputTimebase, AVRational outputTimebase, AVFormatContext context, int codecType) {
        long pts = pkt.pts();
        long dts = pkt.dts();
        long duration = pkt.duration();
        long pos = pkt.pos();
        pkt.pts(avutil.av_rescale_q_rnd((long)pkt.pts(), (AVRational)inputTimebase, (AVRational)outputTimebase, (int)8197));
        pkt.dts(avutil.av_rescale_q_rnd((long)pkt.dts(), (AVRational)inputTimebase, (AVRational)outputTimebase, (int)8197));
        pkt.duration(avutil.av_rescale_q((long)pkt.duration(), (AVRational)inputTimebase, (AVRational)outputTimebase));
        pkt.pos(-1L);
        int ret = 0;
        if (codecType == 0) {
            ret = avcodec.av_packet_ref((AVPacket)this.tmpPacket, (AVPacket)pkt);
            if (ret < 0) {
                this.setStatus("error");
                logger.error("Cannot copy packet for {}", (Object)this.file.getName());
                return;
            }
            if (this.bsfExtractdataContext != null) {
                ret = avcodec.av_bsf_send_packet((AVBSFContext)this.bsfExtractdataContext, (AVPacket)this.tmpPacket);
                if (ret < 0) {
                    this.setStatus("error");
                    logger.warn("cannot send packet to the filter");
                    return;
                }
                while (avcodec.av_bsf_receive_packet((AVBSFContext)this.bsfExtractdataContext, (AVPacket)this.tmpPacket) == 0) {
                    if (!this.headerWritten) {
                        IntPointer size = new IntPointer(1L);
                        BytePointer extradataBytePointer = avcodec.av_packet_get_side_data((AVPacket)this.tmpPacket, (int)1, (IntPointer)size);
                        if (size.get() != 0) {
                            this.allocatedExtraDataPointer = new BytePointer(avutil.av_malloc((long)(size.get() + 64))).capacity((long)(size.get() + 64));
                            byte[] extraDataArray = new byte[size.get()];
                            extradataBytePointer.get(extraDataArray, 0, extraDataArray.length);
                            this.allocatedExtraDataPointer.put(extraDataArray, 0, extraDataArray.length);
                            logger.info("extradata size:{} extradata: {} allocated pointer: {}", new Object[]{size.get(), extradataBytePointer, this.allocatedExtraDataPointer});
                            context.streams(pkt.stream_index()).codecpar().extradata(this.allocatedExtraDataPointer);
                            context.streams(pkt.stream_index()).codecpar().extradata_size(size.get());
                            this.writeHeader();
                            this.setStatus("broadcasting");
                        }
                    }
                    if (this.headerWritten) {
                        ret = avformat.av_write_frame((AVFormatContext)context, (AVPacket)this.tmpPacket);
                        if (ret < 0 && logger.isInfoEnabled()) {
                            byte[] data = new byte[128];
                            avutil.av_strerror((int)ret, (byte[])data, (long)data.length);
                            this.setStatus("error");
                            this.logIntervals("video", data);
                            continue;
                        }
                        this.setStatus("broadcasting");
                        continue;
                    }
                    this.setStatus("error");
                    logger.warn("Header is not written yet for writing video packet for stream: {}", (Object)this.file.getName());
                }
            } else {
                ret = avformat.av_write_frame((AVFormatContext)context, (AVPacket)this.tmpPacket);
                if (ret < 0 && logger.isInfoEnabled()) {
                    byte[] data = new byte[128];
                    avutil.av_strerror((int)ret, (byte[])data, (long)data.length);
                    this.setStatus("error");
                    this.logIntervals("video", data);
                } else {
                    this.setStatus("broadcasting");
                }
            }
            avcodec.av_packet_unref((AVPacket)this.tmpPacket);
        } else if (codecType == 1 && this.headerWritten) {
            ret = avformat.av_write_frame((AVFormatContext)context, (AVPacket)pkt);
            if (ret < 0 && logger.isInfoEnabled()) {
                byte[] data = new byte[128];
                avutil.av_strerror((int)ret, (byte[])data, (long)data.length);
                this.setStatus("error");
                this.logIntervals("audio", data);
            } else {
                this.setStatus("broadcasting");
            }
        }
        pkt.pts(pts);
        pkt.dts(dts);
        pkt.duration(duration);
        pkt.pos(pos);
    }

    public void logIntervals(String type, byte[] data) {
        ++this.time2log;
        if (this.time2log % 100 == 0) {
            logger.error("couldn't write {} {} frame to muxer. Error: {} stream: {} pkt.dts: {}", new Object[]{this.time2log, type, new String(data, 0, data.length), this.file != null ? this.file.getName() : " no name", this.tmpPacket.dts()});
            this.time2log = 0;
        }
    }

    @Override
    public synchronized void writeVideoBuffer(ByteBuffer encodedVideoFrame, long dts, int frameRotation, int streamIndex, boolean isKeyFrame, long firstFrameTimeStamp, long pts) {
        if (!this.isRunning.get() || !this.registeredStreamIndexList.contains(streamIndex)) {
            if (this.time2log % 100 == 0) {
                logger.warn("Not writing to RTMP muxer because it's not started for {}", (Object)this.url);
                this.time2log = 0;
            }
            ++this.time2log;
            return;
        }
        if (!this.keyFrameReceived && isKeyFrame) {
            this.keyFrameReceived = true;
            logger.info("Key frame is received to start");
        }
        if (this.keyFrameReceived) {
            this.videoPkt.stream_index(streamIndex);
            this.videoPkt.pts(pts);
            this.videoPkt.dts(dts);
            encodedVideoFrame.rewind();
            if (isKeyFrame) {
                this.videoPkt.flags(this.videoPkt.flags() | 1);
            }
            this.videoPkt.data(new BytePointer(encodedVideoFrame));
            this.videoPkt.size(encodedVideoFrame.limit());
            this.videoPkt.position(0L);
            AVStream outStream = this.outputFormatContext.streams(this.videoPkt.stream_index());
            AVRational codecTimebase = this.codecTimeBaseMap.get(this.videoPkt.stream_index());
            this.writePacket(this.videoPkt, codecTimebase, outStream.time_base(), outStream.codecpar().codec_type());
            avcodec.av_packet_unref((AVPacket)this.videoPkt);
        }
    }

    @Override
    public boolean addStream(AVCodecParameters codecParameters, AVRational timebase, int streamIndex) {
        boolean result = false;
        AVFormatContext outputContext = this.getOutputFormatContext();
        if (outputContext != null && (codecParameters.codec_type() == 1 || codecParameters.codec_type() == 0)) {
            AVStream outStream = avformat.avformat_new_stream((AVFormatContext)outputContext, null);
            avcodec.avcodec_parameters_copy((AVCodecParameters)outStream.codecpar(), (AVCodecParameters)codecParameters);
            outStream.time_base(timebase);
            this.codecTimeBaseMap.put(outStream.index(), timebase);
            this.registeredStreamIndexList.add(streamIndex);
            if (codecParameters.codec_type() == 1) {
                this.audioIndex = outStream.index();
            } else {
                this.videoIndex = outStream.index();
            }
            outStream.codecpar().codec_tag(0);
            result = true;
        } else if (codecParameters.codec_type() == 2) {
            result = true;
        }
        return result;
    }

    @Override
    public void writeAudioBuffer(ByteBuffer audioFrame, int streamIndex, long timestamp) {
        if (!this.isRunning.get()) {
            if (this.time2log % 100 == 0) {
                logger.warn("Not writing AudioBuffer for {} because Is running:{}", (Object)this.url, (Object)this.isRunning.get());
                this.time2log = 0;
            }
            ++this.time2log;
            return;
        }
        this.audioPkt.stream_index(streamIndex);
        this.audioPkt.pts(timestamp);
        this.audioPkt.dts(timestamp);
        audioFrame.rewind();
        this.audioPkt.flags(this.audioPkt.flags() | 1);
        this.audioPkt.data(new BytePointer(audioFrame));
        this.audioPkt.size(audioFrame.limit());
        this.audioPkt.position(0L);
        this.writePacket(this.audioPkt, (AVCodecContext)null);
        avcodec.av_packet_unref((AVPacket)this.audioPkt);
    }
}

