/*
 * Decompiled with CFR 0.152.
 */
package io.antmedia.security;

import com.google.common.primitives.Longs;
import java.lang.reflect.UndeclaredThrowableException;
import java.security.GeneralSecurityException;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;

public class TOTPGenerator {
    private static final long[] DIGITS_POWER = new long[]{1L, 10L, 100L, 1000L, 10000L, 100000L, 1000000L, 10000000L, 100000000L, 1000000000L, 10000000000L};

    private static byte[] hmac_sha(String crypto, byte[] keyBytes, byte[] text) {
        try {
            Mac hmac = Mac.getInstance(crypto);
            SecretKeySpec macKey = new SecretKeySpec(keyBytes, "RAW");
            hmac.init(macKey);
            return hmac.doFinal(text);
        }
        catch (GeneralSecurityException gse) {
            throw new UndeclaredThrowableException(gse);
        }
    }

    public static String generateTOTP(byte[] secretBytes, int duration, int codeDigits, String crypto) {
        Object result = null;
        long T = System.currentTimeMillis() / (long)(duration * 1000);
        byte[] msg = Longs.toByteArray((long)T);
        byte[] k = secretBytes;
        byte[] hash = TOTPGenerator.hmac_sha(crypto, k, msg);
        int offset = hash[hash.length - 1] & 0xF;
        int binary = (hash[offset] & 0x7F) << 24 | (hash[offset + 1] & 0xFF) << 16 | (hash[offset + 2] & 0xFF) << 8 | hash[offset + 3] & 0xFF;
        long otp = (long)binary % DIGITS_POWER[codeDigits];
        result = Long.toString(otp);
        while (((String)result).length() < codeDigits) {
            result = "0" + (String)result;
        }
        return result;
    }
}

