/*
 * Decompiled with CFR 0.152.
 */
package io.antmedia.webrtc.adaptor;

import io.antmedia.recorder.FFmpegFrameRecorder;
import io.antmedia.recorder.Frame;
import io.antmedia.recorder.FrameRecorder;
import io.antmedia.webrtc.VideoFrameContext;
import io.antmedia.webrtc.adaptor.Adaptor;
import io.antmedia.webrtc.api.IAudioTrackListener;
import io.antmedia.websocket.WebSocketCommunityHandler;
import java.nio.ByteBuffer;
import java.nio.ShortBuffer;
import java.util.ArrayList;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.webrtc.BuiltinAudioDecoderFactoryFactory;
import org.webrtc.IceCandidate;
import org.webrtc.MediaConstraints;
import org.webrtc.MediaStream;
import org.webrtc.PeerConnection;
import org.webrtc.PeerConnectionFactory;
import org.webrtc.SessionDescription;
import org.webrtc.VideoDecoderFactory;
import org.webrtc.VideoEncoderFactory;
import org.webrtc.VideoFrame;
import org.webrtc.VideoSink;
import org.webrtc.VideoTrack;
import org.webrtc.WrappedNativeI420Buffer;
import org.webrtc.audio.JavaAudioDeviceModule;
import org.webrtc.audio.WebRtcAudioTrack;

public class RTMPAdaptor
extends Adaptor {
    public static final String AUDIO_ECHO_CANCELLATION_CONSTRAINT = "googEchoCancellation";
    public static final String AUDIO_AUTO_GAIN_CONTROL_CONSTRAINT = "googAutoGainControl";
    public static final String AUDIO_HIGH_PASS_FILTER_CONSTRAINT = "googHighpassFilter";
    public static final String AUDIO_NOISE_SUPPRESSION_CONSTRAINT = "googNoiseSuppression";
    FFmpegFrameRecorder recorder;
    private volatile long startTime;
    private static Logger logger = LoggerFactory.getLogger(RTMPAdaptor.class);
    private ScheduledExecutorService videoEncoderExecutor;
    private ScheduledExecutorService audioEncoderExecutor;
    private AtomicBoolean isStopped = new AtomicBoolean(false);
    private ScheduledExecutorService signallingExecutor;
    private boolean enableAudio = false;
    private boolean enableVideo = true;
    private volatile int audioFrameCount = 0;
    private boolean started = false;
    private ScheduledFuture<?> audioDataSchedulerFuture;
    private WebRtcAudioTrack webRtcAudioTrack;
    public static final String DTLS_SRTP_KEY_AGREEMENT_CONSTRAINT = "DtlsSrtpKeyAgreement";
    private String stunServerUri = "stun:stun1.l.google.com:19302";
    private int portRangeMin = 0;
    private int portRangeMax = 0;
    private boolean tcpCandidatesEnabled = true;
    private int height;
    private String outputURL;
    private int errorLoopCount = 0;
    private String format = "flv";
    private ConcurrentLinkedQueue<VideoFrameContext> videoFrameQueue = new ConcurrentLinkedQueue();
    private ConcurrentLinkedQueue<AudioFrame> audioFrameQueue = new ConcurrentLinkedQueue();
    private int lastFrameNumber = -1;
    private int dropFrameCount = 0;
    private ScheduledFuture<?> videoEncoderFuture = null;
    private ScheduledFuture<?> audioEncoderFuture = null;
    private int videoFrameCount = 0;
    private long videoFrameLastTimestampMs;

    public static FFmpegFrameRecorder initRecorder(String outputURL, int width, int height, String format) {
        FFmpegFrameRecorder recorder = new FFmpegFrameRecorder(outputURL, width, height, 1);
        recorder.setFormat(format);
        recorder.setSampleRate(44100);
        recorder.setFrameRate(20.0);
        recorder.setPixelFormat(0);
        recorder.setVideoCodec(27);
        recorder.setAudioCodec(86018);
        recorder.setAudioChannels(2);
        recorder.setGopSize(40);
        recorder.setVideoQuality(29);
        recorder.setMaxBFrames(0);
        recorder.setVideoOption("tune", "zerolatency");
        return recorder;
    }

    public FFmpegFrameRecorder getNewRecorder(String outputURL, int width, int height, String format) {
        FFmpegFrameRecorder recorderLocal = RTMPAdaptor.initRecorder(outputURL, width, height, format);
        try {
            recorderLocal.start();
        }
        catch (FrameRecorder.Exception e) {
            logger.error(ExceptionUtils.getStackTrace((Throwable)e));
            this.webSocketCommunityHandler.sendServerError(this.getStreamId(), this.getSession());
            this.stop();
        }
        return recorderLocal;
    }

    public RTMPAdaptor(String outputURL, WebSocketCommunityHandler webSocketHandler, int height) {
        this(outputURL, webSocketHandler, height, "flv");
    }

    public RTMPAdaptor(String outputURL, WebSocketCommunityHandler webSocketHandler, int height, String format) {
        super(webSocketHandler);
        this.outputURL = outputURL;
        this.format = format;
        this.height = height;
        this.setSdpMediaConstraints(new MediaConstraints());
        this.getSdpMediaConstraints().mandatory.add(new MediaConstraints.KeyValuePair("OfferToReceiveAudio", "true"));
        this.getSdpMediaConstraints().mandatory.add(new MediaConstraints.KeyValuePair("OfferToReceiveVideo", "true"));
    }

    public VideoDecoderFactory getVideoDecoderFactory() {
        return null;
    }

    public PeerConnectionFactory createPeerConnectionFactory() {
        PeerConnectionFactory.initialize(PeerConnectionFactory.InitializationOptions.builder().createInitializationOptions());
        VideoEncoderFactory encoderFactory = null;
        VideoDecoderFactory decoderFactory = this.getVideoDecoderFactory();
        PeerConnectionFactory.Options options = new PeerConnectionFactory.Options();
        options.disableNetworkMonitor = true;
        options.networkIgnoreMask = 16;
        BuiltinAudioDecoderFactoryFactory audioDecoderFactoryFactory = new BuiltinAudioDecoderFactoryFactory();
        JavaAudioDeviceModule adm = (JavaAudioDeviceModule)JavaAudioDeviceModule.builder(null).setUseHardwareAcousticEchoCanceler(false).setUseHardwareNoiseSuppressor(false).setAudioRecordErrorCallback(null).setAudioTrackErrorCallback(null).setAudioTrackListener(new IAudioTrackListener(){

            @Override
            public void playoutStopped() {
            }

            @Override
            public void playoutStarted() {
                RTMPAdaptor.this.initAudioTrackExecutor();
            }
        }).createAudioDeviceModule();
        this.webRtcAudioTrack = adm.getAudioTrack();
        return PeerConnectionFactory.builder().setOptions(options).setAudioDeviceModule(adm).setVideoEncoderFactory(encoderFactory).setVideoDecoderFactory(decoderFactory).setAudioDecoderFactoryFactory(audioDecoderFactoryFactory).createPeerConnectionFactory();
    }

    @Override
    public void start() {
        this.videoEncoderExecutor = Executors.newSingleThreadScheduledExecutor();
        this.audioEncoderExecutor = Executors.newSingleThreadScheduledExecutor();
        this.signallingExecutor = Executors.newSingleThreadScheduledExecutor();
        this.signallingExecutor.execute(() -> {
            try {
                this.peerConnectionFactory = this.createPeerConnectionFactory();
                ArrayList<PeerConnection.IceServer> iceServers = new ArrayList<PeerConnection.IceServer>();
                iceServers.add(PeerConnection.IceServer.builder(this.getStunServerUri()).createIceServer());
                PeerConnection.RTCConfiguration rtcConfig = new PeerConnection.RTCConfiguration(iceServers);
                rtcConfig.enableDtlsSrtp = true;
                rtcConfig.minPort = this.portRangeMin;
                rtcConfig.maxPort = this.portRangeMax;
                rtcConfig.tcpCandidatePolicy = this.tcpCandidatesEnabled ? PeerConnection.TcpCandidatePolicy.ENABLED : PeerConnection.TcpCandidatePolicy.DISABLED;
                this.peerConnection = this.peerConnectionFactory.createPeerConnection(rtcConfig, (PeerConnection.Observer)this);
                this.webSocketCommunityHandler.sendStartMessage(this.getStreamId(), this.getSession());
                this.videoEncoderFuture = this.videoEncoderExecutor.scheduleWithFixedDelay(this::encodeVideo, 10L, 10L, TimeUnit.MILLISECONDS);
                this.audioEncoderFuture = this.audioEncoderExecutor.scheduleWithFixedDelay(this::encodeAudio, 10L, 10L, TimeUnit.MILLISECONDS);
                this.started = true;
            }
            catch (Exception e) {
                logger.error(ExceptionUtils.getStackTrace((Throwable)e));
            }
        });
    }

    @Override
    public void stop() {
        if (this.isStopped.get()) {
            logger.info("Stopped already called. It's returning for stream: {}", (Object)this.getStreamId());
            return;
        }
        this.isStopped.set(true);
        if (this.audioDataSchedulerFuture != null) {
            this.audioDataSchedulerFuture.cancel(false);
        }
        if (this.videoEncoderFuture != null) {
            this.videoEncoderFuture.cancel(false);
        }
        logger.info("Video queue size: {} video frame last timestamp: {}", (Object)this.videoFrameQueue.size(), (Object)this.videoFrameLastTimestampMs);
        if (this.audioEncoderFuture != null) {
            this.audioEncoderFuture.cancel(false);
        }
        logger.info("Audio queue size: {} audio frame count: {}", (Object)this.audioFrameQueue.size(), (Object)this.audioFrameCount);
        logger.info("Scheduling stop procedure for stream: {}", (Object)this.getStreamId());
        this.signallingExecutor.execute(() -> {
            logger.info("Executing stop procedure for stream: {}", (Object)this.getStreamId());
            this.webSocketCommunityHandler.sendPublishFinishedMessage(this.getStreamId(), this.getSession());
            this.audioEncoderExecutor.shutdownNow();
            this.videoEncoderExecutor.shutdownNow();
            try {
                this.videoEncoderExecutor.awaitTermination(10L, TimeUnit.SECONDS);
            }
            catch (InterruptedException e1) {
                logger.error(ExceptionUtils.getStackTrace((Throwable)e1));
                Thread.currentThread().interrupt();
            }
            try {
                if (this.peerConnection != null) {
                    this.peerConnection.close();
                    this.recorder.stop();
                    this.peerConnection.dispose();
                    this.peerConnectionFactory.dispose();
                    this.peerConnection = null;
                }
            }
            catch (FrameRecorder.Exception e) {
                logger.error(ExceptionUtils.getStackTrace((Throwable)e));
            }
        });
        this.signallingExecutor.shutdown();
    }

    public ExecutorService getSignallingExecutor() {
        return this.signallingExecutor;
    }

    public void initAudioTrackExecutor() {
        this.audioDataSchedulerFuture = this.signallingExecutor.scheduleAtFixedRate(() -> {
            if (this.startTime == 0L) {
                this.startTime = System.currentTimeMillis();
                logger.info("Set startTime to {} in Audio Track executor:{}", (Object)this.startTime, (Object)this.getStreamId());
            }
            if (this.audioEncoderExecutor == null || this.audioEncoderExecutor.isShutdown()) {
                logger.warn("Audio encoder is null or shutdown for stream:{} ", (Object)this.getStreamId());
                return;
            }
            ++this.audioFrameCount;
            ByteBuffer playoutData = this.webRtcAudioTrack.getPlayoutData();
            this.audioFrameQueue.offer(new AudioFrame(playoutData, this.webRtcAudioTrack.getChannels(), this.webRtcAudioTrack.getSampleRate()));
        }, 0L, 10L, TimeUnit.MILLISECONDS);
    }

    public void encodeAudio() {
        if (this.recorder != null) {
            AudioFrame audioFrameContext = null;
            while ((audioFrameContext = this.audioFrameQueue.poll()) != null) {
                if (!this.isStopped.get()) {
                    this.recordSamples(audioFrameContext);
                    continue;
                }
                logger.error("Stream has stopped but audio encoder is running for stream:{}", (Object)this.getStreamId());
            }
        } else if (!this.enableVideo) {
            logger.info("Initializing the recorder with audio only for stream:{}", (Object)this.outputURL);
            this.recorder = this.getNewRecorder(this.outputURL, 0, 0, this.format);
        }
    }

    public void recordSamples(AudioFrame audioFrameContext) {
        try {
            ShortBuffer audioBuffer = audioFrameContext.data.asShortBuffer();
            boolean result = this.recorder.recordSamples(audioFrameContext.sampleRate, audioFrameContext.channels, audioBuffer);
            if (!result) {
                logger.info("could not audio sample for stream Id {}", (Object)this.getStreamId());
            }
        }
        catch (Exception e) {
            logger.error(ExceptionUtils.getStackTrace((Throwable)e));
        }
    }

    public void initializeRecorder(VideoFrame frame) {
        if (this.recorder == null) {
            long recorderStartTime = System.currentTimeMillis();
            int width = frame.getRotatedWidth() * this.height / frame.getRotatedHeight();
            if (width % 2 == 1) {
                ++width;
            }
            this.recorder = this.getNewRecorder(this.outputURL, width, this.height, this.format);
            long diff = System.currentTimeMillis() - recorderStartTime;
            logger.info("Initialize recorder takes {}ms for stream: {}", (Object)diff, (Object)this.getStreamId());
        }
    }

    public void encodeVideo() {
        VideoFrameContext videoFrameContext = null;
        while ((videoFrameContext = this.videoFrameQueue.poll()) != null) {
            if (!this.isStopped.get()) {
                this.initializeRecorder(videoFrameContext.videoFrame);
                int frameNumber = (int)((double)videoFrameContext.timestampMS * this.recorder.getFrameRate() / 1000.0);
                if (frameNumber > this.lastFrameNumber) {
                    this.recorder.setFrameNumber(frameNumber);
                    this.lastFrameNumber = frameNumber;
                    Frame frameCV = new Frame(videoFrameContext.videoFrame.getRotatedWidth(), videoFrameContext.videoFrame.getRotatedHeight(), 8, 2);
                    VideoFrame.Buffer buffer = videoFrameContext.videoFrame.getBuffer();
                    int[] stride = new int[3];
                    if (buffer instanceof WrappedNativeI420Buffer) {
                        WrappedNativeI420Buffer wrappedBuffer = (WrappedNativeI420Buffer)buffer;
                        ((ByteBuffer)frameCV.image[0].position(0)).put(wrappedBuffer.getDataY());
                        ((ByteBuffer)frameCV.image[0]).put(wrappedBuffer.getDataU());
                        ((ByteBuffer)frameCV.image[0]).put(wrappedBuffer.getDataV());
                        stride[0] = wrappedBuffer.getStrideY();
                        stride[1] = wrappedBuffer.getStrideU();
                        stride[2] = wrappedBuffer.getStrideV();
                        try {
                            this.recorder.recordImage(frameCV.imageWidth, frameCV.imageHeight, frameCV.imageDepth, frameCV.imageChannels, stride, 0, frameCV.image);
                        }
                        catch (FrameRecorder.Exception e) {
                            logger.error(ExceptionUtils.getStackTrace((Throwable)e));
                            ++this.errorLoopCount;
                            if (this.errorLoopCount > 5) {
                                this.webSocketCommunityHandler.sendServerError(this.getStreamId(), this.getSession());
                                this.stop();
                            }
                        }
                    } else {
                        logger.error("Buffer is not type of WrappedNativeI420Buffer for stream: {}", (Object)this.recorder.getFilename());
                    }
                } else {
                    ++this.dropFrameCount;
                    logger.debug("dropping video, total drop count: {} frame number: {} recorder frame number: {}", new Object[]{this.dropFrameCount, frameNumber, this.lastFrameNumber});
                }
            } else {
                logger.error("Stream has stopped but video encoder is running for stream:{}", (Object)this.getStreamId());
            }
            videoFrameContext.videoFrame.release();
        }
    }

    @Override
    public void onAddStream(MediaStream stream) {
        log.warn("onAddStream for stream: {}", (Object)this.getStreamId());
        if (!stream.audioTracks.isEmpty()) {
            this.enableAudio = true;
        }
        if (!stream.videoTracks.isEmpty()) {
            VideoTrack videoTrack = stream.videoTracks.get(0);
            if (videoTrack != null) {
                videoTrack.addSink(new WebRTCVideoSink());
            }
        } else {
            logger.warn("There is no video track for stream: {}", (Object)this.getStreamId());
        }
        this.webSocketCommunityHandler.sendPublishStartedMessage(this.getStreamId(), this.getSession(), null);
    }

    @Override
    public void onSetSuccess() {
        this.peerConnection.createAnswer(this, this.getSdpMediaConstraints());
    }

    public void setRemoteDescription(SessionDescription sdp) {
        this.signallingExecutor.execute(() -> this.peerConnection.setRemoteDescription(this, sdp));
    }

    public void addIceCandidate(IceCandidate iceCandidate) {
        this.signallingExecutor.execute(() -> {
            if (!this.peerConnection.addIceCandidate(iceCandidate)) {
                log.error("Add ice candidate failed for {}", (Object)iceCandidate);
            }
        });
    }

    public boolean isStarted() {
        return this.started;
    }

    public boolean isStopped() {
        return this.isStopped.get();
    }

    public ScheduledFuture getAudioDataSchedulerFuture() {
        return this.audioDataSchedulerFuture;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public String getStunServerUri() {
        return this.stunServerUri;
    }

    public void setStunServerUri(String stunServerUri) {
        this.stunServerUri = stunServerUri;
    }

    public void setPortRange(int webRTCPortRangeMin, int webRTCPortRangeMax) {
        this.portRangeMin = webRTCPortRangeMin;
        this.portRangeMax = webRTCPortRangeMax;
    }

    public void setTcpCandidatesEnabled(boolean tcpCandidatesEnabled) {
        this.tcpCandidatesEnabled = tcpCandidatesEnabled;
    }

    public int getHeight() {
        return this.height;
    }

    public String getOutputURL() {
        return this.outputURL;
    }

    public void setRecorder(FFmpegFrameRecorder recorder) {
        this.recorder = recorder;
    }

    public void setWebRtcAudioTrack(WebRtcAudioTrack webRtcAudioTrack) {
        this.webRtcAudioTrack = webRtcAudioTrack;
    }

    public Queue<VideoFrameContext> getVideoFrameQueue() {
        return this.videoFrameQueue;
    }

    public Queue<AudioFrame> getAudioFrameQueue() {
        return this.audioFrameQueue;
    }

    public FFmpegFrameRecorder getRecorder() {
        return this.recorder;
    }

    public ScheduledExecutorService getVideoEncoderExecutor() {
        return this.videoEncoderExecutor;
    }

    public ScheduledExecutorService getAudioEncoderExecutor() {
        return this.audioEncoderExecutor;
    }

    public void setEnableVideo(boolean enableVideo) {
        this.enableVideo = enableVideo;
    }

    public boolean isEnableVideo() {
        return this.enableVideo;
    }

    public class WebRTCVideoSink
    implements VideoSink {
        private int videoFrameLogCounter = 0;

        @Override
        public void onFrame(VideoFrame frame) {
            long timestampMS;
            if (RTMPAdaptor.this.startTime == 0L) {
                RTMPAdaptor.this.startTime = System.currentTimeMillis();
                logger.info("Set startTime to {} in onFrame for stream:{}", (Object)RTMPAdaptor.this.startTime, (Object)RTMPAdaptor.this.getStreamId());
            }
            if (RTMPAdaptor.this.videoEncoderExecutor == null || RTMPAdaptor.this.videoEncoderExecutor.isShutdown()) {
                logger.warn("Video Encoder is null or shutdown for stream: {}", (Object)RTMPAdaptor.this.getStreamId());
                return;
            }
            frame.retain();
            ++RTMPAdaptor.this.videoFrameCount;
            ++this.videoFrameLogCounter;
            if (this.videoFrameLogCounter % 100 == 0) {
                logger.info("Received total video frames: {}  received fps: {} frame rotated width:{} rotated height:{} width:{} height:{} rotation:{}", new Object[]{RTMPAdaptor.this.videoFrameCount, (long)RTMPAdaptor.this.videoFrameCount / ((System.currentTimeMillis() - RTMPAdaptor.this.startTime) / 1000L), frame.getRotatedWidth(), frame.getRotatedHeight(), frame.getBuffer().getWidth(), frame.getBuffer().getHeight(), frame.getRotation()});
                this.videoFrameLogCounter = 0;
            }
            RTMPAdaptor.this.videoFrameLastTimestampMs = timestampMS = System.currentTimeMillis() - RTMPAdaptor.this.startTime;
            VideoFrameContext videoFrameContext = new VideoFrameContext(frame, timestampMS);
            RTMPAdaptor.this.videoFrameQueue.offer(videoFrameContext);
        }
    }

    public static class AudioFrame {
        public final ByteBuffer data;
        public final int channels;
        public final int sampleRate;

        public AudioFrame(ByteBuffer data, int channels, int sampleRate) {
            this.data = data;
            this.channels = channels;
            this.sampleRate = sampleRate;
        }
    }
}

