/*
 * Decompiled with CFR 0.152.
 */
package io.apiman.gateway.engine.beans.util;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import io.apiman.gateway.engine.beans.util.HeaderMap;
import java.io.IOException;
import java.util.ArrayDeque;

public class HeaderMapDeserializer
extends JsonDeserializer<HeaderMap> {
    public HeaderMap deserialize(JsonParser p, DeserializationContext ctxt) throws IOException, JsonProcessingException {
        HeaderMap map = new HeaderMap();
        while (p.nextToken() != JsonToken.END_OBJECT) {
            String name = p.getCurrentName();
            p.nextToken();
            if (p.currentToken().isScalarValue()) {
                map.add(name, p.getValueAsString());
                continue;
            }
            ArrayDeque<String> values = new ArrayDeque<String>();
            while (p.nextToken() != JsonToken.END_ARRAY) {
                values.push(p.getValueAsString());
            }
            values.forEach(value -> map.add(name, (String)value));
        }
        return map;
    }
}

