/*
 * Decompiled with CFR 0.152.
 */
package io.asgardeo.tomcat.oidc.agent;

import io.asgardeo.java.oidc.sdk.config.FileBasedOIDCConfigProvider;
import io.asgardeo.java.oidc.sdk.config.model.OIDCAgentConfig;
import io.asgardeo.java.oidc.sdk.exception.SSOAgentClientException;
import java.util.Properties;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import org.apache.commons.lang.StringUtils;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SSOAgentContextEventListener
implements ServletContextListener {
    private static final Logger logger = LogManager.getLogger(SSOAgentContextEventListener.class);
    private static Properties properties;

    public static Properties getProperties() {
        return properties;
    }

    public static String getPropertyByKey(String key) {
        return properties.getProperty(key);
    }

    public void contextInitialized(ServletContextEvent servletContextEvent) {
        properties = new Properties();
        try {
            ServletContext servletContext = servletContextEvent.getServletContext();
            String propertyFileName = servletContext.getInitParameter("app-property-file");
            if (!StringUtils.isNotBlank((String)propertyFileName)) {
                throw new SSOAgentClientException("app-property-file context-param is not specified in the web.xml");
            }
            FileBasedOIDCConfigProvider configProvider = new FileBasedOIDCConfigProvider(servletContextEvent.getServletContext().getResourceAsStream("/WEB-INF/classes/" + propertyFileName));
            OIDCAgentConfig config = configProvider.getOidcAgentConfig();
            servletContext.setAttribute("io.asgardeo.java.oidc.sdk.config.model.OIDCAgentConfig", (Object)config);
        }
        catch (SSOAgentClientException e) {
            logger.log(Level.FATAL, "Error while loading properties.", (Throwable)e);
        }
    }

    public void contextDestroyed(ServletContextEvent servletContextEvent) {
    }
}

