/*
 * Decompiled with CFR 0.152.
 */
package io.asgardeo.tomcat.oidc.agent;

import io.asgardeo.java.oidc.sdk.exception.SSOAgentClientException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Properties;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import org.apache.commons.lang.StringUtils;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class JKSLoader
implements ServletContextListener {
    private static final Logger logger = LogManager.getLogger(JKSLoader.class);

    public void contextInitialized(ServletContextEvent servletContextEvent) {
        try {
            ServletContext servletContext = servletContextEvent.getServletContext();
            String propertyFileName = servletContext.getInitParameter("jks-property-file");
            if (!StringUtils.isNotBlank((String)propertyFileName)) {
                throw new SSOAgentClientException("jks-property-file context-param is not specified in the web.xml");
            }
            InputStream jksInputStream = this.getClass().getClassLoader().getResourceAsStream(propertyFileName);
            if (jksInputStream == null) {
                return;
            }
            Properties jksProperties = new Properties();
            jksProperties.load(jksInputStream);
            URL resource = this.getClass().getClassLoader().getResource(jksProperties.getProperty("keystorename"));
            if (resource != null) {
                System.setProperty("javax.net.ssl.trustStore", resource.getPath());
                System.setProperty("javax.net.ssl.trustStorePassword", jksProperties.getProperty("keystorepassword"));
            }
        }
        catch (SSOAgentClientException | IOException e) {
            logger.log(Level.FATAL, "Error while loading properties.", e);
            return;
        }
    }

    public void contextDestroyed(ServletContextEvent servletContextEvent) {
    }
}

