/*
 * Decompiled with CFR 0.152.
 */
package io.asgardeo.tomcat.oidc.agent;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Properties;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import org.apache.commons.lang.StringUtils;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class JKSLoader
implements ServletContextListener {
    private static final Logger logger = LogManager.getLogger(JKSLoader.class);

    public void contextInitialized(ServletContextEvent servletContextEvent) {
        try {
            ServletContext servletContext = servletContextEvent.getServletContext();
            String propertyFileName = servletContext.getInitParameter("jks-property-file");
            if (!StringUtils.isNotBlank((String)propertyFileName)) {
                logger.log(Level.INFO, "Could not locate a jks.properties configuration in the web.xml.");
                return;
            }
            InputStream jksInputStream = this.getClass().getClassLoader().getResourceAsStream(propertyFileName);
            if (jksInputStream == null) {
                return;
            }
            Properties jksProperties = new Properties();
            jksProperties.load(jksInputStream);
            URL resource = this.getClass().getClassLoader().getResource(jksProperties.getProperty("keystorename"));
            if (resource != null) {
                System.setProperty("javax.net.ssl.trustStore", resource.getPath());
                System.setProperty("javax.net.ssl.trustStorePassword", jksProperties.getProperty("keystorepassword"));
            } else {
                logger.log(Level.INFO, "Could not locate a keystore file defined in jks.properties.");
            }
        }
        catch (IOException e) {
            logger.log(Level.FATAL, "Error while loading properties.", (Throwable)e);
            return;
        }
    }

    public void contextDestroyed(ServletContextEvent servletContextEvent) {
    }
}

