/*
 * Decompiled with CFR 0.152.
 */
package io.asgardeo.tomcat.oidc.agent;

import com.nimbusds.oauth2.sdk.util.StringUtils;
import io.asgardeo.java.oidc.sdk.HTTPSessionBasedOIDCProcessor;
import io.asgardeo.java.oidc.sdk.bean.SessionContext;
import io.asgardeo.java.oidc.sdk.config.model.OIDCAgentConfig;
import io.asgardeo.java.oidc.sdk.exception.SSOAgentClientException;
import io.asgardeo.java.oidc.sdk.exception.SSOAgentException;
import io.asgardeo.java.oidc.sdk.request.OIDCRequestResolver;
import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class OIDCAgentFilter
implements Filter {
    private static final Logger logger = LogManager.getLogger(OIDCAgentFilter.class);
    protected FilterConfig filterConfig = null;
    OIDCAgentConfig oidcAgentConfig;
    HTTPSessionBasedOIDCProcessor oidcManager;

    public void init(FilterConfig filterConfig) throws ServletException {
        this.filterConfig = filterConfig;
        ServletContext servletContext = filterConfig.getServletContext();
        if (servletContext.getAttribute("io.asgardeo.java.oidc.sdk.config.model.OIDCAgentConfig") instanceof OIDCAgentConfig) {
            this.oidcAgentConfig = (OIDCAgentConfig)servletContext.getAttribute("io.asgardeo.java.oidc.sdk.config.model.OIDCAgentConfig");
        }
        try {
            this.oidcManager = new HTTPSessionBasedOIDCProcessor(this.oidcAgentConfig);
        }
        catch (SSOAgentClientException e) {
            throw new SSOAgentException(e.getMessage(), (Throwable)e);
        }
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        HttpServletRequest request = (HttpServletRequest)servletRequest;
        HttpServletResponse response = (HttpServletResponse)servletResponse;
        OIDCRequestResolver requestResolver = new OIDCRequestResolver(request, this.oidcAgentConfig);
        if (requestResolver.isSkipURI()) {
            filterChain.doFilter(servletRequest, servletResponse);
            return;
        }
        if (requestResolver.isLogoutURL()) {
            try {
                this.oidcManager.logout(request, response);
            }
            catch (SSOAgentException e) {
                this.handleException(request, response, e);
            }
            return;
        }
        if (requestResolver.isCallbackResponse()) {
            try {
                this.oidcManager.handleOIDCCallback(request, response);
            }
            catch (SSOAgentException e) {
                this.handleException(request, response, e);
                return;
            }
            response.sendRedirect("home.jsp");
            return;
        }
        if (!this.isActiveSessionPresent(request)) {
            try {
                this.oidcManager.sendForLogin(request, response);
            }
            catch (SSOAgentException e) {
                this.handleException(request, response, e);
            }
        } else {
            filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
        }
    }

    public void destroy() {
    }

    boolean isActiveSessionPresent(HttpServletRequest request) {
        HttpSession currentSession = request.getSession(false);
        return currentSession != null && currentSession.getAttribute("session_context") != null && currentSession.getAttribute("session_context") instanceof SessionContext;
    }

    void clearSession(HttpServletRequest request) {
        HttpSession session = request.getSession(false);
        if (session != null) {
            session.invalidate();
        }
    }

    protected void handleException(HttpServletRequest request, HttpServletResponse response, SSOAgentException e) throws ServletException, IOException {
        String errorPage = this.oidcAgentConfig.getErrorPage();
        if (StringUtils.isBlank((CharSequence)errorPage)) {
            errorPage = this.buildErrorPageURL(this.oidcAgentConfig, request);
        }
        if (errorPage.trim().charAt(0) != '/') {
            errorPage = "/" + errorPage;
        }
        this.clearSession(request);
        logger.log(Level.FATAL, e.getMessage());
        request.setAttribute("AgentException", (Object)e);
        RequestDispatcher requestDispatcher = request.getServletContext().getRequestDispatcher(errorPage);
        requestDispatcher.forward((ServletRequest)request, (ServletResponse)response);
    }

    private String buildErrorPageURL(OIDCAgentConfig oidcAgentConfig, HttpServletRequest request) {
        if (StringUtils.isNotBlank((CharSequence)oidcAgentConfig.getIndexPage())) {
            return oidcAgentConfig.getIndexPage();
        }
        return "/";
    }
}

