/*
 * Decompiled with CFR 0.152.
 */
package io.asgardeo.tomcat.saml.agent;

import io.asgardeo.java.saml.sdk.bean.SSOAgentConfig;
import io.asgardeo.java.saml.sdk.exception.SSOAgentException;
import io.asgardeo.java.saml.sdk.security.SSOAgentX509Credential;
import io.asgardeo.java.saml.sdk.security.SSOAgentX509KeyStoreCredential;
import java.io.IOException;
import java.io.InputStream;
import java.util.AbstractMap;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import org.apache.commons.lang.StringUtils;

public class SSOAgentContextEventListener
implements ServletContextListener {
    private static Logger logger = Logger.getLogger(SSOAgentContextEventListener.class.getName());

    public void contextInitialized(ServletContextEvent servletContextEvent) {
        Properties properties = new Properties();
        try {
            ServletContext servletContext = servletContextEvent.getServletContext();
            String propertyFileName = servletContext.getInitParameter("property-file");
            if (!StringUtils.isNotBlank((String)propertyFileName)) {
                throw new SSOAgentException("property-file context-param is not specified in the web.xml");
            }
            properties.load(servletContextEvent.getServletContext().getResourceAsStream("/WEB-INF/classes/" + propertyFileName));
            properties.putAll(this.resolvePropertiesFromEnvironmentVariables(properties));
            String certificateFileName = servletContext.getInitParameter("certificate-file");
            if (!StringUtils.isNotBlank((String)certificateFileName)) {
                throw new SSOAgentException("certificate-file context-param is not specified in the web.xml");
            }
            InputStream keyStoreInputStream = servletContext.getResourceAsStream("/WEB-INF/classes/" + certificateFileName);
            SSOAgentX509KeyStoreCredential credential = new SSOAgentX509KeyStoreCredential(keyStoreInputStream, properties.getProperty("KeyStorePassword").toCharArray(), properties.getProperty("IdPPublicCertAlias"), properties.getProperty("IdPPublicCert"), properties.getProperty("PrivateKeyAlias"), properties.getProperty("PrivateKeyPassword").toCharArray());
            SSOAgentConfig config = new SSOAgentConfig();
            config.initConfig(properties);
            config.getSAML2().setSSOAgentX509Credential((SSOAgentX509Credential)credential);
            servletContext.setAttribute("org.wso2.carbon.identity.sso.agent.SSOAgentConfig", (Object)config);
        }
        catch (SSOAgentException | IOException e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
        }
    }

    private Map<String, String> resolvePropertiesFromEnvironmentVariables(Properties properties) throws SSOAgentException {
        Map<String, String> processedPropertyMap = properties.entrySet().stream().map(entry -> new AbstractMap.SimpleEntry<String, String>(String.valueOf(entry.getKey()), String.valueOf(entry.getValue()))).filter(entry -> ((String)entry.getValue()).matches("\\$\\{(.*?)}")).map(entry -> new AbstractMap.SimpleEntry(entry.getKey(), StringUtils.substringsBetween((String)((String)entry.getValue()), (String)"${", (String)"}")[0])).map(entry -> new AbstractMap.SimpleEntry(entry.getKey(), System.getenv((String)entry.getValue()))).map(entry -> new AbstractMap.SimpleEntry(entry.getKey(), StringUtils.isNotBlank((String)((String)entry.getValue())) ? (String)entry.getValue() : "")).peek(entry -> {
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("Inferred value: " + (String)entry.getValue() + " for property: " + (String)entry.getKey() + " from environment.");
            }
        }).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        if (!processedPropertyMap.isEmpty() && StringUtils.isBlank((String)processedPropertyMap.get("IdPPublicCertAlias")) && StringUtils.isBlank((String)processedPropertyMap.get("IdPPublicCert"))) {
            throw new SSOAgentException("Environment variable value was not set for neither `IDP_PUBLIC_CERT` nor `IDP_PUBLIC_CERT_ALIAS`");
        }
        return processedPropertyMap;
    }

    public void contextDestroyed(ServletContextEvent servletContextEvent) {
    }
}

