/*
 * Decompiled with CFR 0.152.
 */
package io.asgardeo.tomcat.saml.agent;

import io.asgardeo.java.saml.sdk.SAML2SSOManager;
import io.asgardeo.java.saml.sdk.bean.LoggedInSessionBean;
import io.asgardeo.java.saml.sdk.bean.SSOAgentConfig;
import io.asgardeo.java.saml.sdk.exception.InvalidSessionException;
import io.asgardeo.java.saml.sdk.exception.SSOAgentException;
import io.asgardeo.java.saml.sdk.util.SSOAgentFilterUtils;
import io.asgardeo.java.saml.sdk.util.SSOAgentRequestResolver;
import io.asgardeo.java.saml.sdk.util.SSOAgentUtils;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.opensaml.saml.common.SignableSAMLObject;

public class SAML2SSOAgentFilter
implements Filter {
    private static final Logger LOGGER = Logger.getLogger("org.wso2.carbon.identity.sso.agent");
    protected FilterConfig filterConfig = null;

    public void init(FilterConfig fConfig) throws ServletException {
        this.filterConfig = fConfig;
    }

    /*
     * Unable to fully structure code
     */
    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain chain) throws IOException, ServletException {
        request = (HttpServletRequest)servletRequest;
        response = (HttpServletResponse)servletResponse;
        try {
            ssoAgentConfig = SSOAgentFilterUtils.getSSOAgentConfig((FilterConfig)this.filterConfig);
            resolver = new SSOAgentRequestResolver(request, response, ssoAgentConfig);
            if (resolver.isURLToSkip()) {
                chain.doFilter(servletRequest, servletResponse);
                return;
            }
            if (resolver.isSLORequest()) {
                try {
                    samlSSOManager = new SAML2SSOManager(ssoAgentConfig);
                    logoutResponse = samlSSOManager.doSLO(request);
                    encodedRequestMessage = samlSSOManager.buildPostResponse((SignableSAMLObject)logoutResponse);
                    SSOAgentUtils.sendPostResponse((HttpServletRequest)request, (HttpServletResponse)response, (String)encodedRequestMessage);
                }
                catch (SSOAgentException e) {
                    this.handleException(request, response, ssoAgentConfig, e);
                    return;
                }
                return;
            }
            if (resolver.isSAML2SSOResponse()) {
                try {
                    samlSSOManager = new SAML2SSOManager(ssoAgentConfig);
                    samlSSOManager.processResponse(request, response);
                    if (SSOAgentFilterUtils.shouldGoToWelcomePage((HttpServletRequest)request)) ** GOTO lbl100
                    response.sendRedirect(ssoAgentConfig.getSAML2().getACSURL());
                }
                catch (SSOAgentException e) {
                    if (e instanceof InvalidSessionException) {
                        SAML2SSOAgentFilter.LOGGER.log(Level.FINE, "Invalid Session!", e);
                        response.sendRedirect(this.filterConfig.getServletContext().getContextPath());
                        return;
                    }
                    this.handleException(request, response, ssoAgentConfig, e);
                    return;
                }
            } else {
                if (resolver.isSAML2ArtifactResponse()) {
                    try {
                        samlSSOManager = new SAML2SSOManager(ssoAgentConfig);
                        samlSSOManager.processArtifactResponse(request);
                    }
                    catch (SSOAgentException e) {
                        this.handleException(request, response, ssoAgentConfig, e);
                        return;
                    }
                }
                if (resolver.isSLOURL()) {
                    try {
                        samlSSOManager = new SAML2SSOManager(ssoAgentConfig);
                        if (resolver.isHttpPostBinding()) {
                            isPassiveAuth = ssoAgentConfig.getSAML2().isPassiveAuthn();
                            ssoAgentConfig.getSAML2().setPassiveAuthn(Boolean.valueOf(false));
                            htmlPayload = samlSSOManager.buildPostRequest(request, response, true);
                            ssoAgentConfig.getSAML2().setPassiveAuthn(Boolean.valueOf(isPassiveAuth));
                            SSOAgentUtils.sendPostResponse((HttpServletRequest)request, (HttpServletResponse)response, (String)htmlPayload);
                        } else {
                            isPassiveAuth = ssoAgentConfig.getSAML2().isPassiveAuthn();
                            ssoAgentConfig.getSAML2().setPassiveAuthn(Boolean.valueOf(false));
                            redirectUrl = samlSSOManager.buildRedirectRequest(request, true);
                            ssoAgentConfig.getSAML2().setPassiveAuthn(Boolean.valueOf(isPassiveAuth));
                            response.sendRedirect(redirectUrl);
                        }
                    }
                    catch (SSOAgentException e) {
                        if (e instanceof InvalidSessionException) {
                            SAML2SSOAgentFilter.LOGGER.log(Level.FINE, "Invalid Session!", e);
                            response.sendRedirect(this.filterConfig.getServletContext().getContextPath());
                            return;
                        }
                        this.handleException(request, response, ssoAgentConfig, e);
                        return;
                    }
                    return;
                }
                if (resolver.isSAML2SSOURL()) {
                    try {
                        samlSSOManager = new SAML2SSOManager(ssoAgentConfig);
                        if (resolver.isHttpPostBinding()) {
                            htmlPayload = samlSSOManager.buildPostRequest(request, response, false);
                            SSOAgentUtils.sendPostResponse((HttpServletRequest)request, (HttpServletResponse)response, (String)htmlPayload);
                            return;
                        }
                        response.sendRedirect(samlSSOManager.buildRedirectRequest(request, false));
                    }
                    catch (SSOAgentException e) {
                        if (e instanceof InvalidSessionException) {
                            SAML2SSOAgentFilter.LOGGER.log(Level.FINE, "Invalid Session!", e);
                            response.sendRedirect(this.filterConfig.getServletContext().getContextPath());
                            return;
                        }
                        this.handleException(request, response, ssoAgentConfig, e);
                        return;
                    }
                    return;
                }
                if (resolver.isPassiveAuthnRequest()) {
                    try {
                        samlSSOManager = new SAML2SSOManager(ssoAgentConfig);
                        isPassiveAuth = ssoAgentConfig.getSAML2().isPassiveAuthn();
                        ssoAgentConfig.getSAML2().setPassiveAuthn(Boolean.valueOf(true));
                        redirectUrl = samlSSOManager.buildRedirectRequest(request, false);
                        ssoAgentConfig.getSAML2().setPassiveAuthn(Boolean.valueOf(isPassiveAuth));
                        response.sendRedirect(redirectUrl);
                    }
                    catch (SSOAgentException e) {
                        if (e instanceof InvalidSessionException) {
                            SAML2SSOAgentFilter.LOGGER.log(Level.FINE, "Invalid Session!", e);
                            response.sendRedirect(this.filterConfig.getServletContext().getContextPath());
                            return;
                        }
                        this.handleException(request, response, ssoAgentConfig, e);
                        return;
                    }
                    return;
                }
            }
lbl100:
            // 5 sources

            indexPage = ssoAgentConfig.getIndexPage();
            if (request.getSession(false) != null && request.getSession(false).getAttribute("org.wso2.carbon.identity.sso.agent.LoggedInSessionBean") == null) {
                response.sendRedirect(indexPage);
                return;
            }
            session = request.getSession();
            sessionBean = (LoggedInSessionBean)session.getAttribute("org.wso2.carbon.identity.sso.agent.LoggedInSessionBean");
            if (sessionBean == null || sessionBean.getSAML2SSO() == null) {
                request.getSession().invalidate();
                response.sendRedirect(indexPage);
                return;
            }
            chain.doFilter((ServletRequest)request, (ServletResponse)response);
        }
        catch (InvalidSessionException e) {
            SAML2SSOAgentFilter.LOGGER.log(Level.FINE, "Invalid Session!", e);
            response.sendRedirect(this.filterConfig.getServletContext().getContextPath());
        }
    }

    public void destroy() {
    }

    protected void handleException(HttpServletRequest request, HttpServletResponse response, SSOAgentConfig ssoAgentConfig, SSOAgentException e) throws IOException, ServletException {
        String errorPage = ssoAgentConfig.getErrorPage();
        if (request.getSession(false) != null) {
            request.getSession(false).removeAttribute("org.wso2.carbon.identity.sso.agent.LoggedInSessionBean");
        }
        LOGGER.log(Level.SEVERE, e.getMessage());
        request.setAttribute("SSOAgentException", (Object)e);
        RequestDispatcher requestDispatcher = request.getServletContext().getRequestDispatcher(errorPage);
        requestDispatcher.forward((ServletRequest)request, (ServletResponse)response);
    }
}

