/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.search.connect.os;

import com.amazonaws.regions.DefaultAwsRegionProviderChain;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.camunda.search.connect.SearchClientConnectException;
import io.camunda.search.connect.configuration.ConnectConfiguration;
import io.camunda.search.connect.configuration.SecurityConfiguration;
import io.camunda.search.connect.jackson.JacksonConfiguration;
import io.camunda.search.connect.os.json.SearchRequestJacksonJsonpMapperWrapper;
import io.camunda.search.connect.util.SecurityUtil;
import java.net.URI;
import java.net.URISyntaxException;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import org.apache.hc.client5.http.auth.AuthScope;
import org.apache.hc.client5.http.auth.Credentials;
import org.apache.hc.client5.http.auth.CredentialsProvider;
import org.apache.hc.client5.http.auth.UsernamePasswordCredentials;
import org.apache.hc.client5.http.config.RequestConfig;
import org.apache.hc.client5.http.impl.async.HttpAsyncClientBuilder;
import org.apache.hc.client5.http.impl.auth.BasicCredentialsProvider;
import org.apache.hc.client5.http.impl.nio.PoolingAsyncClientConnectionManager;
import org.apache.hc.client5.http.impl.nio.PoolingAsyncClientConnectionManagerBuilder;
import org.apache.hc.client5.http.nio.AsyncClientConnectionManager;
import org.apache.hc.client5.http.ssl.ClientTlsStrategyBuilder;
import org.apache.hc.client5.http.ssl.NoopHostnameVerifier;
import org.apache.hc.core5.http.HttpHost;
import org.apache.hc.core5.http.nio.ssl.TlsStrategy;
import org.apache.hc.core5.util.Timeout;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.opensearch.OpenSearchAsyncClient;
import org.opensearch.client.opensearch.OpenSearchClient;
import org.opensearch.client.transport.OpenSearchTransport;
import org.opensearch.client.transport.aws.AwsSdk2Transport;
import org.opensearch.client.transport.aws.AwsSdk2TransportOptions;
import org.opensearch.client.transport.httpclient5.ApacheHttpClient5TransportBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider;
import software.amazon.awssdk.http.async.SdkAsyncHttpClient;
import software.amazon.awssdk.http.nio.netty.NettyNioAsyncHttpClient;
import software.amazon.awssdk.regions.Region;

public final class OpensearchConnector {
    private static final Logger LOGGER = LoggerFactory.getLogger(OpensearchConnector.class);
    private final ConnectConfiguration configuration;
    private final ObjectMapper objectMapper;

    public OpensearchConnector(ConnectConfiguration configuration) {
        this(configuration, new JacksonConfiguration(configuration).createObjectMapper());
    }

    public OpensearchConnector(ConnectConfiguration configuration, ObjectMapper objectMapper) {
        this.configuration = configuration;
        this.objectMapper = objectMapper;
    }

    public OpenSearchClient createClient() {
        OpenSearchTransport transport = this.createTransport(this.configuration);
        return new OpenSearchClient(transport);
    }

    public OpenSearchAsyncClient createAsyncClient() {
        OpenSearchTransport transport = this.createTransport(this.configuration);
        return new OpenSearchAsyncClient(transport);
    }

    private OpenSearchTransport createTransport(ConnectConfiguration configuration) {
        if (this.shouldCreateAWSBasedTransport()) {
            return this.createAWSBasedTransport(configuration);
        }
        return this.createDefaultTransport(configuration);
    }

    private OpenSearchTransport createAWSBasedTransport(ConnectConfiguration configuration) {
        HttpHost httpHost = this.getHttpHost(configuration);
        String region = new DefaultAwsRegionProviderChain().getRegion();
        SdkAsyncHttpClient httpClient = NettyNioAsyncHttpClient.builder().build();
        return new AwsSdk2Transport(httpClient, httpHost.getHostName(), Region.of((String)region), AwsSdk2TransportOptions.builder().setMapper((JsonpMapper)new SearchRequestJacksonJsonpMapperWrapper(this.objectMapper)).build());
    }

    private OpenSearchTransport createDefaultTransport(ConnectConfiguration configuration) {
        HttpHost host = this.getHttpHost(configuration);
        ApacheHttpClient5TransportBuilder builder = ApacheHttpClient5TransportBuilder.builder((HttpHost[])new HttpHost[]{host});
        builder.setHttpClientConfigCallback(httpClientBuilder -> {
            this.configureHttpClient(httpClientBuilder, configuration);
            return httpClientBuilder;
        });
        builder.setRequestConfigCallback(requestConfigBuilder -> {
            this.setTimeouts(requestConfigBuilder, configuration);
            return requestConfigBuilder;
        });
        SearchRequestJacksonJsonpMapperWrapper jsonpMapper = new SearchRequestJacksonJsonpMapperWrapper(this.objectMapper);
        builder.setMapper((JsonpMapper)jsonpMapper);
        return builder.build();
    }

    private boolean shouldCreateAWSBasedTransport() {
        DefaultCredentialsProvider credentialsProvider = DefaultCredentialsProvider.create();
        try {
            credentialsProvider.resolveCredentials();
            LOGGER.info("AWS Credentials can be resolved. Use AWS Opensearch");
            return true;
        }
        catch (Exception e) {
            LOGGER.warn("AWS not configured due to: {} ", (Object)e.getMessage());
            return false;
        }
    }

    private HttpHost getHttpHost(ConnectConfiguration osConfig) {
        try {
            URI uri = new URI(osConfig.getUrl());
            return new HttpHost(uri.getScheme(), uri.getHost(), uri.getPort());
        }
        catch (URISyntaxException e) {
            throw new SearchClientConnectException("Error in url: " + osConfig.getUrl(), e);
        }
    }

    protected HttpAsyncClientBuilder configureHttpClient(HttpAsyncClientBuilder httpAsyncClientBuilder, ConnectConfiguration osConfig) {
        this.setupAuthentication(httpAsyncClientBuilder, osConfig);
        if (osConfig.getSecurity() != null && osConfig.getSecurity().isEnabled()) {
            this.setupSSLContext(httpAsyncClientBuilder, osConfig.getSecurity());
        }
        return httpAsyncClientBuilder;
    }

    private RequestConfig.Builder setTimeouts(RequestConfig.Builder builder, ConnectConfiguration os) {
        if (os.getSocketTimeout() != null) {
            builder.setResponseTimeout(Timeout.ofMilliseconds((long)os.getSocketTimeout().intValue()));
        }
        if (os.getConnectTimeout() != null) {
            builder.setConnectTimeout(Timeout.ofMilliseconds((long)os.getConnectTimeout().intValue()));
        }
        return builder;
    }

    private HttpAsyncClientBuilder setupAuthentication(HttpAsyncClientBuilder builder, ConnectConfiguration configuration) {
        String username = configuration.getUsername();
        String password = configuration.getPassword();
        if (username == null || password == null || username.isEmpty() || password.isEmpty()) {
            LOGGER.warn("Username and/or password for are empty. Basic authentication for OpenSearch is not used.");
            return builder;
        }
        BasicCredentialsProvider credentialsProvider = new BasicCredentialsProvider();
        credentialsProvider.setCredentials(new AuthScope(this.getHttpHost(configuration)), (Credentials)new UsernamePasswordCredentials(configuration.getUsername(), configuration.getPassword().toCharArray()));
        builder.setDefaultCredentialsProvider((CredentialsProvider)credentialsProvider);
        return builder;
    }

    private void setupSSLContext(HttpAsyncClientBuilder httpAsyncClientBuilder, SecurityConfiguration configuration) {
        try {
            ClientTlsStrategyBuilder tlsStrategyBuilder = ClientTlsStrategyBuilder.create();
            SSLContext sslContext = SecurityUtil.getSSLContext(configuration, "opensearch-host");
            tlsStrategyBuilder.setSslContext(sslContext);
            if (!configuration.isVerifyHostname()) {
                tlsStrategyBuilder.setHostnameVerifier((HostnameVerifier)NoopHostnameVerifier.INSTANCE);
            }
            TlsStrategy tlsStrategy = tlsStrategyBuilder.build();
            PoolingAsyncClientConnectionManager connectionManager = PoolingAsyncClientConnectionManagerBuilder.create().setTlsStrategy(tlsStrategy).build();
            httpAsyncClientBuilder.setConnectionManager((AsyncClientConnectionManager)connectionManager);
        }
        catch (Exception e) {
            LOGGER.error("Error in setting up SSLContext", (Throwable)e);
        }
    }
}

