/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.search.connect.es;

import co.elastic.clients.elasticsearch.ElasticsearchClient;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.jackson.JacksonJsonpMapper;
import co.elastic.clients.transport.ElasticsearchTransport;
import co.elastic.clients.transport.rest_client.RestClientTransport;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.camunda.search.connect.SearchClientConnectException;
import io.camunda.search.connect.configuration.ConnectConfiguration;
import io.camunda.search.connect.configuration.SecurityConfiguration;
import io.camunda.search.connect.jackson.JacksonConfiguration;
import io.camunda.search.connect.util.SecurityUtil;
import java.net.URI;
import java.net.URISyntaxException;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import org.apache.http.HttpHost;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.nio.client.HttpAsyncClientBuilder;
import org.elasticsearch.client.RestClient;
import org.elasticsearch.client.RestClientBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ElasticsearchConnector {
    private static final Logger LOGGER = LoggerFactory.getLogger(ElasticsearchConnector.class);
    private final ConnectConfiguration configuration;
    private final ObjectMapper objectMapper;

    public ElasticsearchConnector(ConnectConfiguration configuration) {
        this(configuration, new JacksonConfiguration(configuration).createObjectMapper());
    }

    public ElasticsearchConnector(ConnectConfiguration configuration, ObjectMapper objectMapper) {
        this.configuration = configuration;
        this.objectMapper = objectMapper;
    }

    public ElasticsearchClient createClient() {
        LOGGER.debug("Creating Elasticsearch Client ...");
        RestClient restClient = this.createRestClient(this.configuration);
        RestClientTransport transport = new RestClientTransport(restClient, (JsonpMapper)new JacksonJsonpMapper(this.objectMapper));
        return new ElasticsearchClient((ElasticsearchTransport)transport);
    }

    private RestClient createRestClient(ConnectConfiguration configuration) {
        HttpHost httpHost = this.getHttpHost(configuration);
        RestClientBuilder restClientBuilder = RestClient.builder((HttpHost[])new HttpHost[]{httpHost});
        if (configuration.getConnectTimeout() != null || configuration.getSocketTimeout() != null) {
            restClientBuilder.setRequestConfigCallback(configCallback -> this.setTimeouts(configCallback, configuration));
        }
        RestClient restClient = restClientBuilder.setHttpClientConfigCallback(httpClientBuilder -> this.configureHttpClient(httpClientBuilder, configuration)).build();
        return restClient;
    }

    protected HttpAsyncClientBuilder configureHttpClient(HttpAsyncClientBuilder httpAsyncClientBuilder, ConnectConfiguration configuration) {
        this.setupAuthentication(httpAsyncClientBuilder, configuration);
        SecurityConfiguration security = configuration.getSecurity();
        if (security != null && security.isEnabled()) {
            this.setupSSLContext(httpAsyncClientBuilder, security);
        }
        return httpAsyncClientBuilder;
    }

    private void setupSSLContext(HttpAsyncClientBuilder httpAsyncClientBuilder, SecurityConfiguration configuration) {
        try {
            SSLContext sslContext = SecurityUtil.getSSLContext(configuration, "elasticsearch-host");
            httpAsyncClientBuilder.setSSLContext(sslContext);
            if (!configuration.isVerifyHostname()) {
                httpAsyncClientBuilder.setSSLHostnameVerifier((HostnameVerifier)NoopHostnameVerifier.INSTANCE);
            }
        }
        catch (Exception e) {
            LOGGER.error("Error in setting up SSLContext", (Throwable)e);
        }
    }

    private RequestConfig.Builder setTimeouts(RequestConfig.Builder builder, ConnectConfiguration elsConfig) {
        if (elsConfig.getSocketTimeout() != null) {
            builder.setSocketTimeout(elsConfig.getSocketTimeout().intValue());
        }
        if (elsConfig.getConnectTimeout() != null) {
            builder.setConnectTimeout(elsConfig.getConnectTimeout().intValue());
        }
        return builder;
    }

    private HttpHost getHttpHost(ConnectConfiguration elsConfig) {
        try {
            URI uri = new URI(elsConfig.getUrl());
            return new HttpHost(uri.getHost(), uri.getPort(), uri.getScheme());
        }
        catch (URISyntaxException e) {
            throw new SearchClientConnectException("Error in url: " + elsConfig.getUrl(), e);
        }
    }

    private void setupAuthentication(HttpAsyncClientBuilder builder, ConnectConfiguration configuration) {
        String username = configuration.getUsername();
        String password = configuration.getPassword();
        if (username == null || password == null || username.isEmpty() || password.isEmpty()) {
            LOGGER.warn("Username and/or password for are empty. Basic authentication for elasticsearch is not used.");
            return;
        }
        BasicCredentialsProvider credentialsProvider = new BasicCredentialsProvider();
        credentialsProvider.setCredentials(AuthScope.ANY, (Credentials)new UsernamePasswordCredentials(username, password));
        builder.setDefaultCredentialsProvider((CredentialsProvider)credentialsProvider);
    }
}

