/*
 * Decompiled with CFR 0.152.
 */
package io.cellery.observability.model.generator;

import io.cellery.observability.model.generator.Node;
import io.cellery.observability.model.generator.Utils;
import io.cellery.observability.model.generator.internal.ServiceHolder;
import io.cellery.observability.model.generator.model.SpanInfo;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;
import org.wso2.siddhi.annotation.Example;
import org.wso2.siddhi.annotation.Extension;
import org.wso2.siddhi.core.config.SiddhiAppContext;
import org.wso2.siddhi.core.event.ComplexEvent;
import org.wso2.siddhi.core.event.ComplexEventChunk;
import org.wso2.siddhi.core.event.stream.StreamEvent;
import org.wso2.siddhi.core.event.stream.StreamEventCloner;
import org.wso2.siddhi.core.event.stream.populater.ComplexEventPopulater;
import org.wso2.siddhi.core.exception.SiddhiAppCreationException;
import org.wso2.siddhi.core.executor.ExpressionExecutor;
import org.wso2.siddhi.core.query.processor.Processor;
import org.wso2.siddhi.core.query.processor.stream.StreamProcessor;
import org.wso2.siddhi.core.util.config.ConfigReader;
import org.wso2.siddhi.query.api.definition.AbstractDefinition;
import org.wso2.siddhi.query.api.definition.Attribute;

@Extension(name="modelGenerator", namespace="observe", description="This generates the dependency model based on request spans. This depends on the traceGroup window processor", examples={@Example(description="This travese through the grouped spans and generates the dependency model", syntax="observe:modelGenerator(cell, serviceName, operationName, spanId, parentId, kind, traceId, startTime)\nselect * \ninsert into outputStream;")})
public class ModelGenerationExtension
extends StreamProcessor {
    private static final Logger log = Logger.getLogger(ModelGenerationExtension.class);
    private ExpressionExecutor cellNameExecutor;
    private ExpressionExecutor instanceKindExecutor;
    private ExpressionExecutor serviceNameExecutor;
    private ExpressionExecutor operationNameExecutor;
    private ExpressionExecutor traceIdExecutor;
    private ExpressionExecutor spanIdExecutor;
    private ExpressionExecutor parentIdExecutor;
    private ExpressionExecutor spanKindExecutor;
    private ExpressionExecutor startTimeExecutor;

    protected void process(ComplexEventChunk<StreamEvent> complexEventChunk, Processor processor, StreamEventCloner streamEventCloner, ComplexEventPopulater complexEventPopulater) {
        try {
            if (complexEventChunk.getFirst() != null && ((StreamEvent)complexEventChunk.getFirst()).getType().equals((Object)ComplexEvent.Type.EXPIRED)) {
                HashMap<String, List<SpanInfo>> spanCache = new HashMap<String, List<SpanInfo>>();
                String traceId = null;
                ArrayList<SpanInfo> rootSpans = new ArrayList<SpanInfo>();
                int totalSpans = 0;
                while (complexEventChunk.hasNext()) {
                    StreamEvent streamEvent = (StreamEvent)complexEventChunk.next();
                    String cellName = (String)this.cellNameExecutor.execute((ComplexEvent)streamEvent);
                    String instanceKind = (String)this.instanceKindExecutor.execute((ComplexEvent)streamEvent);
                    String serviceName = (String)this.serviceNameExecutor.execute((ComplexEvent)streamEvent);
                    String operationName = (String)this.operationNameExecutor.execute((ComplexEvent)streamEvent);
                    String spanId = (String)this.spanIdExecutor.execute((ComplexEvent)streamEvent);
                    String parentId = (String)this.parentIdExecutor.execute((ComplexEvent)streamEvent);
                    String kind = (String)this.spanKindExecutor.execute((ComplexEvent)streamEvent);
                    Long startTime = (Long)this.startTimeExecutor.execute((ComplexEvent)streamEvent);
                    if (traceId == null) {
                        traceId = (String)this.traceIdExecutor.execute((ComplexEvent)streamEvent);
                    }
                    if (kind == null || kind.isEmpty()) {
                        kind = SpanInfo.Kind.NONE.name();
                    }
                    SpanInfo spanInfo = new SpanInfo(cellName, instanceKind, serviceName, operationName, spanId, parentId, SpanInfo.Kind.valueOf(kind), startTime);
                    List childNodes = spanCache.computeIfAbsent(parentId, k -> new ArrayList());
                    childNodes.add(spanInfo);
                    spanCache.putIfAbsent(parentId, childNodes);
                    if (spanId.equalsIgnoreCase(traceId) || parentId == null) {
                        rootSpans.add(spanInfo);
                    }
                    ++totalSpans;
                }
                if (!rootSpans.isEmpty()) {
                    this.addPossibleLinkForRootSpans(rootSpans);
                    Set<SpanInfo> rootCellSpans = this.findRootCellSpan(rootSpans, spanCache);
                    this.traceWalk(rootCellSpans, spanCache);
                    ServiceHolder.getModelStoreManager().storeCurrentModel();
                } else {
                    log.warn((Object)("Root span was not detected for the trace: " + traceId + ", total parents spans cache: " + spanCache.size() + " , totalSpans: " + totalSpans));
                }
            } else {
                processor.process(complexEventChunk);
            }
        }
        catch (Throwable throwable) {
            log.error((Object)"Unexpected error occured while processing the event in the model processor.", throwable);
        }
    }

    private void addPossibleLinkForRootSpans(List<SpanInfo> spans) {
        Collections.sort(spans);
        for (int i = 0; i < spans.size(); ++i) {
            Node cellChildNode;
            Node cellParentNode;
            SpanInfo spanInfo = spans.get(i);
            if (!spanInfo.getKind().equals((Object)SpanInfo.Kind.CLIENT) || i + 1 >= spans.size() || !spans.get(i + 1).getKind().equals((Object)SpanInfo.Kind.SERVER)) continue;
            SpanInfo childSpanInfo = spans.get(i + 1);
            if (spanInfo.getCellName() == null || spanInfo.getCellName().isEmpty() || spanInfo.getOperationName().startsWith("async ") || childSpanInfo.getCellName() == null || childSpanInfo.getCellName().isEmpty() || childSpanInfo.getOperationName().startsWith("async ") || (cellParentNode = ServiceHolder.getModelManager().getOrGenerateNode(spanInfo)).equals(cellChildNode = ServiceHolder.getModelManager().getOrGenerateNode(childSpanInfo)) && spanInfo.getComponentName().equalsIgnoreCase(childSpanInfo.getComponentName())) continue;
            cellChildNode.addComponent(childSpanInfo.getComponentName());
            ServiceHolder.getModelManager().addNode(cellChildNode);
            ServiceHolder.getModelManager().addLink(cellParentNode, cellChildNode, Utils.generateServiceName(spanInfo.getComponentName(), childSpanInfo.getComponentName()));
        }
    }

    private Set<SpanInfo> findRootCellSpan(List<SpanInfo> rootSpans, Map<String, List<SpanInfo>> spanInfoMap) {
        HashSet<SpanInfo> parents = new HashSet<SpanInfo>();
        for (SpanInfo spanInfo : rootSpans) {
            parents.addAll(this.findRootCellSpan(spanInfo, spanInfoMap));
        }
        return parents;
    }

    private Set<SpanInfo> findRootCellSpan(SpanInfo rootSpan, Map<String, List<SpanInfo>> spanInfoMap) {
        HashSet<SpanInfo> parents = new HashSet<SpanInfo>();
        if (rootSpan.getCellName() == null || rootSpan.getCellName().isEmpty()) {
            List<SpanInfo> children = spanInfoMap.get(rootSpan.getSpanId());
            if (children != null) {
                Collections.sort(children);
                for (int i = 0; i < children.size(); ++i) {
                    SpanInfo child = children.get(i);
                    if (child.getKind().equals((Object)SpanInfo.Kind.CLIENT) && i + 1 < children.size() && children.get(i + 1).getKind().equals((Object)SpanInfo.Kind.SERVER)) continue;
                    if (child.getCellName() != null && !child.getCellName().isEmpty()) {
                        parents.add(child);
                        continue;
                    }
                    parents.addAll(this.findRootCellSpan(child, spanInfoMap));
                }
            }
        } else {
            parents.add(rootSpan);
        }
        return parents;
    }

    private void traceWalk(Set<SpanInfo> rootSpans, Map<String, List<SpanInfo>> spanInfoMap) {
        for (SpanInfo rootSpan : rootSpans) {
            Set<SpanInfo> linkedChildren;
            Node parentNode = ServiceHolder.getModelManager().getOrGenerateNode(rootSpan);
            parentNode.addComponent(rootSpan.getComponentName());
            ServiceHolder.getModelManager().addNode(parentNode);
            if (spanInfoMap.get(rootSpan.getSpanId()) == null || (linkedChildren = this.goDepth(parentNode, rootSpan, spanInfoMap)).isEmpty()) continue;
            this.traceWalk(linkedChildren, spanInfoMap);
        }
    }

    private Set<SpanInfo> goDepth(Node cellParentNode, SpanInfo parentSpanInfo, Map<String, List<SpanInfo>> spanInfoMap) {
        List<SpanInfo> childSpanInfoList = spanInfoMap.get(parentSpanInfo.getSpanId());
        HashSet<SpanInfo> linkedChildren = new HashSet<SpanInfo>();
        if (childSpanInfoList != null) {
            Collections.sort(childSpanInfoList);
            for (SpanInfo childSpanInfo : childSpanInfoList) {
                if (childSpanInfo.getCellName() != null && !childSpanInfo.getCellName().isEmpty() && !childSpanInfo.getOperationName().startsWith("async ")) {
                    Node childNode = ServiceHolder.getModelManager().getOrGenerateNode(childSpanInfo);
                    if (!childNode.equals(cellParentNode) || !parentSpanInfo.getComponentName().equalsIgnoreCase(childSpanInfo.getComponentName())) {
                        childNode.addComponent(childSpanInfo.getComponentName());
                        ServiceHolder.getModelManager().addNode(childNode);
                        ServiceHolder.getModelManager().addLink(cellParentNode, childNode, Utils.generateServiceName(parentSpanInfo.getComponentName(), childSpanInfo.getComponentName()));
                        linkedChildren.add(childSpanInfo);
                        continue;
                    }
                    linkedChildren.addAll(this.goDepth(cellParentNode, childSpanInfo, spanInfoMap));
                    continue;
                }
                linkedChildren.addAll(this.goDepth(cellParentNode, childSpanInfo, spanInfoMap));
            }
        }
        return linkedChildren;
    }

    protected List<Attribute> init(AbstractDefinition abstractDefinition, ExpressionExecutor[] expressionExecutors, ConfigReader configReader, SiddhiAppContext siddhiAppContext) {
        if (expressionExecutors.length != 9) {
            throw new SiddhiAppCreationException("Nine arguments are required");
        }
        if (expressionExecutors[0].getReturnType() != Attribute.Type.STRING) {
            throw new SiddhiAppCreationException("Expected a field with String return type for the instance field, but found a field with return type - " + expressionExecutors[0].getReturnType());
        }
        this.cellNameExecutor = expressionExecutors[0];
        if (expressionExecutors[1].getReturnType() != Attribute.Type.STRING) {
            throw new SiddhiAppCreationException("Expected a field with String return type for the instanceKind field, but found a field with return type - " + expressionExecutors[1].getReturnType());
        }
        this.instanceKindExecutor = expressionExecutors[1];
        if (expressionExecutors[2].getReturnType() != Attribute.Type.STRING) {
            throw new SiddhiAppCreationException("Expected a field with Long return type for the serviceName field, but found a field with return type - " + expressionExecutors[2].getReturnType());
        }
        this.serviceNameExecutor = expressionExecutors[2];
        if (expressionExecutors[3].getReturnType() != Attribute.Type.STRING) {
            throw new SiddhiAppCreationException("Expected a field with Long return type for the operationName field, but found a field with return type - " + expressionExecutors[3].getReturnType());
        }
        this.operationNameExecutor = expressionExecutors[3];
        if (expressionExecutors[4].getReturnType() != Attribute.Type.STRING) {
            throw new SiddhiAppCreationException("Expected a field with String return type for the spanId field, but found a field with return type - " + expressionExecutors[4].getReturnType());
        }
        this.spanIdExecutor = expressionExecutors[4];
        if (expressionExecutors[5].getReturnType() != Attribute.Type.STRING) {
            throw new SiddhiAppCreationException("Expected a field with String return type for the parentId field, but found a field with return type - " + expressionExecutors[5].getReturnType());
        }
        this.parentIdExecutor = expressionExecutors[5];
        if (expressionExecutors[6].getReturnType() != Attribute.Type.STRING) {
            throw new SiddhiAppCreationException("Expected a field with String return type for the spanKind field, but found a field with return type - " + expressionExecutors[6].getReturnType());
        }
        this.spanKindExecutor = expressionExecutors[6];
        if (expressionExecutors[7].getReturnType() != Attribute.Type.STRING) {
            throw new SiddhiAppCreationException("Expected a field with String return type for the traceId field, but found a field with return type - " + expressionExecutors[7].getReturnType());
        }
        this.traceIdExecutor = expressionExecutors[7];
        if (expressionExecutors[8].getReturnType() != Attribute.Type.LONG) {
            throw new SiddhiAppCreationException("Expected a field with long return type for the startTime field, but found a field with return type - " + expressionExecutors[8].getReturnType());
        }
        this.startTimeExecutor = expressionExecutors[8];
        return new ArrayList<Attribute>();
    }

    public void start() {
    }

    public void stop() {
    }

    public Map<String, Object> currentState() {
        return null;
    }

    public void restoreState(Map<String, Object> map) {
    }
}

