/*
 * Decompiled with CFR 0.152.
 */
package io.cellery.observability.model.generator;

import com.google.common.graph.MutableNetwork;
import com.google.common.graph.NetworkBuilder;
import io.cellery.observability.model.generator.Node;
import io.cellery.observability.model.generator.Utils;
import io.cellery.observability.model.generator.exception.GraphStoreException;
import io.cellery.observability.model.generator.exception.ModelException;
import io.cellery.observability.model.generator.internal.ServiceHolder;
import io.cellery.observability.model.generator.model.Edge;
import io.cellery.observability.model.generator.model.Model;
import io.cellery.observability.model.generator.model.SpanInfo;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ModelManager {
    private MutableNetwork<Node, String> dependencyGraph;
    private Map<String, Node> nodeCache = new HashMap<String, Node>();

    public ModelManager() throws ModelException {
        try {
            Model model = ServiceHolder.getModelStoreManager().loadLastModel();
            this.dependencyGraph = NetworkBuilder.directed().allowsParallelEdges(true).expectedNodeCount(100000).expectedEdgeCount(1000000).build();
            if (model != null) {
                Set<Node> nodes = model.getNodes();
                Set<String> edges = Utils.getEdgesString(model.getEdges());
                this.addNodes(nodes);
                this.addEdges(edges);
            }
        }
        catch (GraphStoreException e) {
            throw new ModelException("Unable to load already persisted model.", e);
        }
    }

    private void addNodes(Set<Node> nodes) {
        for (Node node : nodes) {
            this.dependencyGraph.addNode((Object)node);
            this.nodeCache.putIfAbsent(node.getId(), node);
        }
    }

    private void addEdges(Set<String> edges) throws ModelException {
        for (String edge : edges) {
            String[] elements = Utils.edgeNameElements(edge);
            Node parentNode = this.getNode(elements[0]);
            Node childNode = this.getNode(elements[1]);
            if (parentNode != null && childNode != null) {
                this.dependencyGraph.addEdge((Object)parentNode, (Object)childNode, (Object)edge);
                continue;
            }
            String msg = "";
            if (parentNode == null) {
                msg = msg + "Parent node doesn't exist in the graph for edgename :" + edge + ". ";
            }
            if (childNode == null) {
                msg = msg + "Client node doesn't exist in the graph for edgename :" + edge + ". ";
            }
            throw new ModelException(msg);
        }
    }

    public Node getNode(String nodeName) {
        Node cachedNode = this.nodeCache.get(nodeName);
        if (cachedNode == null) {
            Set nodes = this.dependencyGraph.nodes();
            for (Node node : nodes) {
                if (!node.getId().equalsIgnoreCase(nodeName)) continue;
                this.nodeCache.put(node.getId(), node);
                return node;
            }
            return null;
        }
        return cachedNode;
    }

    public Node getOrGenerateNode(SpanInfo span) {
        Node cachedNode = this.nodeCache.get(span.getCellName());
        if (cachedNode == null) {
            Set nodes = this.dependencyGraph.nodes();
            for (Node node : nodes) {
                if (!node.getId().equalsIgnoreCase(span.getCellName())) continue;
                this.nodeCache.put(node.getId(), node);
                return node;
            }
        } else {
            return cachedNode;
        }
        return new Node(span.getCellName(), span.getInstanceKind());
    }

    public void addNode(Node node) {
        this.dependencyGraph.addNode((Object)node);
        this.nodeCache.put(node.getId(), node);
    }

    public void addLink(Node parent, Node child, String serviceName) {
        try {
            if (!parent.equals(child)) {
                this.dependencyGraph.addEdge((Object)parent, (Object)child, (Object)Utils.generateEdgeName(parent.getId(), child.getId(), serviceName));
            } else {
                parent.addEdge(serviceName);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public MutableNetwork<Node, String> getDependencyGraph() {
        return this.dependencyGraph;
    }

    public Model getGraph(long fromTime, long toTime) throws GraphStoreException {
        if (fromTime == 0L && toTime == 0L) {
            return new Model(this.dependencyGraph.nodes(), Utils.getEdges(this.dependencyGraph.edges()));
        }
        if (toTime == 0L) {
            toTime = System.currentTimeMillis();
        }
        List<Model> models = ServiceHolder.getModelStoreManager().loadModel(fromTime, toTime);
        return this.getMergedModel(models);
    }

    public Model getDependencyModel(long fromTime, long toTime, String cellName) throws GraphStoreException {
        Model graph = this.getGraph(fromTime, toTime);
        ArrayList<Model> models = new ArrayList<Model>();
        HashSet<String> processedNodes = new HashSet<String>();
        this.populateDependencyModel(graph, cellName, models, processedNodes);
        return this.getMergedModel(models);
    }

    private void populateDependencyModel(Model graph, String cellName, List<Model> models, Set<String> processedNodes) {
        if (!processedNodes.contains(cellName)) {
            Model dependencyGraph = this.getDependencyModel(graph, cellName);
            processedNodes.add(cellName);
            if (dependencyGraph.getNodes().size() > 1) {
                models.add(dependencyGraph);
                for (Node node : dependencyGraph.getNodes()) {
                    this.populateDependencyModel(graph, node.getId(), models, processedNodes);
                }
            } else if (models.isEmpty()) {
                models.add(dependencyGraph);
            }
        }
    }

    private Model getDependencyModel(Model model, String cell) {
        HashSet<Node> dependedNodes = new HashSet<Node>();
        HashSet<Edge> dependedEdges = new HashSet<Edge>();
        for (Edge edge : model.getEdges()) {
            if (!edge.getSource().equalsIgnoreCase(cell)) continue;
            dependedEdges.add(edge);
            dependedNodes.add(Utils.getNode(model.getNodes(), new Node(edge.getTarget())));
        }
        Node cellNode = Utils.getNode(model.getNodes(), new Node(cell));
        if (cellNode != null) {
            dependedNodes.add(cellNode);
        }
        return new Model(dependedNodes, dependedEdges);
    }

    public Model getDependencyModel(long fromTime, long toTime, String cellName, String serviceName) throws GraphStoreException {
        Model graph = this.getGraph(fromTime, toTime);
        ArrayList<String> traversedServices = new ArrayList<String>();
        Node cell = Utils.getNode(graph.getNodes(), new Node(cellName));
        Model serviceModel = null;
        if (cell != null) {
            String qualifiedServiceName = Utils.getQualifiedServiceName(cellName, serviceName);
            serviceModel = this.getDependencyModel(cell, serviceName, traversedServices);
            for (Edge edge : graph.getEdges()) {
                Node dependedCell;
                String edgeServiceName = Utils.getEdgeServiceName(edge.getEdgeString());
                String[] services = Utils.getServices(edgeServiceName);
                if (!edge.getSource().equalsIgnoreCase(cellName) || !services[0].equalsIgnoreCase(serviceName) || services[1].equalsIgnoreCase(serviceName) || edge.getTarget().equalsIgnoreCase(cellName) || (dependedCell = Utils.getNode(graph.getNodes(), new Node(edge.getTarget()))) == null) continue;
                Model dependentCellModel = this.getDependencyModel(dependedCell, services[1], traversedServices);
                serviceModel.mergeModel(dependentCellModel, new Edge(Utils.generateEdgeName(qualifiedServiceName, Utils.getQualifiedServiceName(dependedCell.getId(), services[1]), "")));
            }
        }
        if (serviceModel == null) {
            serviceModel = new Model(new HashSet<Node>(), new HashSet<Edge>());
        }
        return serviceModel;
    }

    private Model getDependencyModel(Node cell, String serviceName, List<String> traversedServices) {
        HashSet<Node> nodes = new HashSet<Node>();
        HashSet<Edge> edges = new HashSet<Edge>();
        String qualifiedServiceName = Utils.getQualifiedServiceName(cell.getId(), serviceName);
        if (!traversedServices.contains(qualifiedServiceName)) {
            nodes.add(new Node(qualifiedServiceName, cell.getInstanceKind()));
            traversedServices.add(qualifiedServiceName);
            for (String edge : cell.getEdges()) {
                String[] sourceTarget = edge.split("##");
                if (!sourceTarget[0].trim().equalsIgnoreCase(serviceName) || sourceTarget[0].trim().equalsIgnoreCase(sourceTarget[1])) continue;
                String qualifiedTargetServiceName = Utils.getQualifiedServiceName(cell.getId(), sourceTarget[1].trim());
                nodes.add(new Node(qualifiedTargetServiceName, cell.getInstanceKind()));
                edges.add(new Edge(Utils.generateEdgeName(qualifiedServiceName, qualifiedTargetServiceName, "")));
                Model nextLevelModel = this.getDependencyModel(cell, sourceTarget[1], traversedServices);
                if (nextLevelModel.getNodes().size() <= 1) continue;
                nodes.addAll(nextLevelModel.getNodes());
                edges.addAll(nextLevelModel.getEdges());
            }
        }
        return new Model(nodes, edges);
    }

    private Model getMergedModel(List<Model> models) {
        HashSet<Node> allNodes = new HashSet<Node>();
        HashSet<Edge> allEdges = new HashSet<Edge>();
        for (Model model : models) {
            Set<Node> aModelNodes = model.getNodes();
            for (Node node : aModelNodes) {
                Node nodeFromAllNodes = Utils.getNode(allNodes, node);
                if (nodeFromAllNodes == null) {
                    allNodes.add(node);
                    continue;
                }
                nodeFromAllNodes.getComponents().addAll(node.getComponents());
                nodeFromAllNodes.getEdges().addAll(node.getEdges());
            }
            allEdges.addAll(model.getEdges());
        }
        return new Model(allNodes, allEdges);
    }
}

