/*
 * Decompiled with CFR 0.152.
 */
package io.cellery.observability.model.generator;

import java.util.HashSet;
import java.util.Set;

public class Node
implements Comparable {
    private String id;
    private String instanceKind;
    private Set<String> components;
    private Set<String> edges;

    Node(String name) {
        this(name, null);
    }

    Node(String name, String instanceKind) {
        this.id = name;
        this.instanceKind = instanceKind;
        this.components = new HashSet<String>();
        this.edges = new HashSet<String>();
    }

    public String getId() {
        return this.id;
    }

    public String getInstanceKind() {
        return this.instanceKind;
    }

    public void addComponent(String component) {
        this.components.add(component);
    }

    public void addEdge(String serviceEdge) {
        this.edges.add(serviceEdge);
    }

    public int compareTo(Object anotherNode) {
        if (anotherNode != null && anotherNode instanceof Node) {
            if (this.equals(anotherNode)) {
                return 0;
            }
            return this.id.compareTo(((Node)anotherNode).id);
        }
        return -1;
    }

    public boolean equals(Object object) {
        return object != null && object instanceof Node && this.id.equalsIgnoreCase(((Node)object).id);
    }

    public Set<String> getComponents() {
        return this.components;
    }

    public Set<String> getEdges() {
        return this.edges;
    }

    public int hashCode() {
        return this.id.hashCode();
    }
}

