/*
 * Decompiled with CFR 0.152.
 */
package io.cellery.observability.model.generator;

import io.cellery.observability.model.generator.Node;
import io.cellery.observability.model.generator.model.Edge;
import java.util.HashSet;
import java.util.Set;

public class Utils {
    private Utils() {
    }

    public static String[] edgeNameElements(String edgeName) {
        return edgeName.split(" ---> ");
    }

    public static String generateEdgeName(String parentNodeId, String childNodeId, String serviceName) {
        return parentNodeId + " ---> " + childNodeId + " ---> " + serviceName;
    }

    public static String generateServiceName(String parentService, String childService) {
        return parentService + "##" + childService;
    }

    public static Set<Edge> getEdges(Set<String> edgeString) {
        HashSet<Edge> edges = new HashSet<Edge>();
        for (String anEdge : edgeString) {
            edges.add(new Edge(anEdge));
        }
        return edges;
    }

    public static Set<String> getEdgesString(Set<Edge> edgeList) {
        HashSet<String> edges = new HashSet<String>();
        for (Edge edge : edgeList) {
            edges.add(edge.getEdgeString());
        }
        return edges;
    }

    public static Node getNode(Set<Node> nodes, Node node) {
        for (Node setNode : nodes) {
            if (setNode.compareTo(node) != 0) continue;
            return setNode;
        }
        return null;
    }

    public static String getQualifiedServiceName(String cellName, String serviceName) {
        return cellName + ":" + serviceName;
    }

    public static String getEdgeServiceName(String edgeString) {
        return edgeString.split(" ---> ")[2];
    }

    public static String[] getServices(String serviceName) {
        return serviceName.split("##");
    }
}

