/*
 * Decompiled with CFR 0.152.
 */
package io.cellery.observability.model.generator.internal;

import io.cellery.observability.model.generator.ModelManager;
import io.cellery.observability.model.generator.internal.ModelStoreManager;
import io.cellery.observability.model.generator.internal.ServiceHolder;
import org.apache.log4j.Logger;
import org.osgi.framework.BundleContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.wso2.carbon.datasource.core.api.DataSourceService;

@Component(service={ModelServiceComponent.class}, immediate=true)
public class ModelServiceComponent {
    private static final Logger log = Logger.getLogger(ModelServiceComponent.class);

    @Activate
    protected void start(BundleContext bundleContext) throws Exception {
        try {
            ServiceHolder.setModelStoreManager(new ModelStoreManager());
            ServiceHolder.setModelManager(new ModelManager());
            bundleContext.registerService(ModelManager.class.getName(), (Object)ServiceHolder.getModelManager(), null);
        }
        catch (Throwable throwable) {
            log.error((Object)"Error occurred while activating the model generation bundle", throwable);
            throw throwable;
        }
    }

    @Reference(name="org.wso2.carbon.datasource.DataSourceService", service=DataSourceService.class, cardinality=ReferenceCardinality.AT_LEAST_ONE, policy=ReferencePolicy.DYNAMIC, unbind="unregisterDataSourceService")
    protected void registerDataSourceService(DataSourceService service) {
        ServiceHolder.setDataSourceService(service);
    }

    protected void unregisterDataSourceService(DataSourceService service) {
        ServiceHolder.setDataSourceService(null);
    }
}

