/*
 * Decompiled with CFR 0.152.
 */
package io.cellery.observability.model.generator.internal;

import com.google.common.graph.MutableNetwork;
import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import io.cellery.observability.model.generator.Node;
import io.cellery.observability.model.generator.Utils;
import io.cellery.observability.model.generator.exception.GraphStoreException;
import io.cellery.observability.model.generator.internal.ServiceHolder;
import io.cellery.observability.model.generator.model.Model;
import java.lang.reflect.Type;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.time.Instant;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.sql.DataSource;
import org.apache.log4j.Logger;
import org.wso2.carbon.datasource.core.exception.DataSourceException;

public class ModelStoreManager {
    private static final Logger log = Logger.getLogger(ModelStoreManager.class);
    private static final String TABLE_NAME = "DependencyModelTable";
    private static final String DATASOURCE_NAME = "CELLERY_OBSERVABILITY_DB";
    private static final Type NODE_SET_TYPE = new TypeToken<HashSet<Node>>(){}.getType();
    private static final Type STRING_SET_TYPE = new TypeToken<HashSet<String>>(){}.getType();
    private DataSource dataSource;
    private Gson gson;
    private Model lastModel;

    public ModelStoreManager() {
        try {
            this.dataSource = (DataSource)ServiceHolder.getDataSourceService().getDataSource(DATASOURCE_NAME);
            this.createTable();
            this.gson = new Gson();
            this.lastModel = this.loadLastModel();
        }
        catch (GraphStoreException | SQLException | DataSourceException e) {
            log.error((Object)"Unable to load the datasource : CELLERY_OBSERVABILITY_DB , and hence unable to schedule the periodic dependency persistence.", e);
        }
    }

    private void createTable() throws SQLException, GraphStoreException {
        Connection connection = this.getConnection();
        PreparedStatement statement = connection.prepareStatement("CREATE TABLE IF NOT EXISTS DependencyModelTable (MODEL_TIME TIMESTAMP, NODES TEXT, EDGES TEXT)");
        statement.execute();
        this.cleanupConnection(null, statement, connection);
    }

    public Model loadLastModel() throws GraphStoreException {
        try {
            Connection connection = this.getConnection();
            PreparedStatement statement = connection.prepareStatement("SELECT * FROM DependencyModelTable ORDER BY MODEL_TIME DESC LIMIT 1");
            ResultSet resultSet = statement.executeQuery();
            Model model = null;
            if (resultSet.next()) {
                model = this.getModel(resultSet);
            }
            this.cleanupConnection(resultSet, statement, connection);
            return model;
        }
        catch (SQLException ex) {
            throw new GraphStoreException("Unable to load the graph from datasource : CELLERY_OBSERVABILITY_DB", ex);
        }
    }

    private Model getModel(ResultSet resultSet) throws SQLException {
        String nodes = resultSet.getString(2);
        String edges = resultSet.getString(3);
        Set nodesSet = (Set)this.gson.fromJson(nodes, NODE_SET_TYPE);
        Set edgeSet = (Set)this.gson.fromJson(edges, STRING_SET_TYPE);
        return new Model(nodesSet, Utils.getEdges(edgeSet));
    }

    public List<Model> loadModel(long fromTime, long toTime) throws GraphStoreException {
        try {
            Connection connection = this.getConnection();
            PreparedStatement statement = connection.prepareStatement("SELECT * FROM DependencyModelTable WHERE MODEL_TIME >= ? AND MODEL_TIME <= ? ORDER BY MODEL_TIME");
            statement.setTimestamp(1, new Timestamp(fromTime));
            statement.setTimestamp(2, new Timestamp(toTime));
            ResultSet resultSet = statement.executeQuery();
            ArrayList<Model> models = new ArrayList<Model>();
            while (resultSet.next()) {
                models.add(this.getModel(resultSet));
            }
            if (models.isEmpty()) {
                Timestamp timestamp;
                this.cleanupConnection(resultSet, statement, null);
                statement = connection.prepareStatement("SELECT * FROM DependencyModelTable ORDER BY MODEL_TIME DESC LIMIT 1");
                resultSet = statement.executeQuery();
                if (resultSet.next() && (timestamp = resultSet.getTimestamp(1)).getTime() < fromTime) {
                    models.add(this.getModel(resultSet));
                }
                this.cleanupConnection(resultSet, statement, connection);
            } else {
                this.cleanupConnection(resultSet, statement, connection);
            }
            return models;
        }
        catch (SQLException ex) {
            throw new GraphStoreException("Unable to load the graph from datasource : CELLERY_OBSERVABILITY_DB", ex);
        }
    }

    private Connection getConnection() throws SQLException, GraphStoreException {
        if (this.dataSource != null) {
            return this.dataSource.getConnection();
        }
        throw new GraphStoreException("Datasource is not available!");
    }

    private void cleanupConnection(ResultSet rs, Statement stmt, Connection conn) {
        if (rs != null) {
            try {
                rs.close();
            }
            catch (SQLException e) {
                log.error((Object)("Error on closing resultSet " + e.getMessage()), (Throwable)e);
            }
        }
        if (stmt != null) {
            try {
                stmt.close();
            }
            catch (SQLException e) {
                log.error((Object)("Error on closing statement " + e.getMessage()), (Throwable)e);
            }
        }
        if (conn != null) {
            try {
                conn.close();
            }
            catch (SQLException e) {
                log.error((Object)("Error on closing connection " + e.getMessage()), (Throwable)e);
            }
        }
    }

    public Model persistModel(MutableNetwork<Node, String> graph) throws GraphStoreException {
        try {
            String nodes = this.gson.toJson((Object)graph.nodes(), NODE_SET_TYPE);
            String edges = this.gson.toJson((Object)graph.edges(), STRING_SET_TYPE);
            Connection connection = this.getConnection();
            PreparedStatement statement = connection.prepareStatement("INSERT INTO DependencyModelTable VALUES (?, ?, ?)");
            statement.setTimestamp(1, Timestamp.from(Instant.now()));
            statement.setString(2, nodes);
            statement.setString(3, edges);
            statement.executeUpdate();
            connection.commit();
            Model model = new Model((Set)this.gson.fromJson(nodes, NODE_SET_TYPE), Utils.getEdges((Set)this.gson.fromJson(edges, STRING_SET_TYPE)));
            this.cleanupConnection(null, statement, connection);
            return model;
        }
        catch (SQLException ex) {
            throw new GraphStoreException("Unable to persist the graph to the datasource: CELLERY_OBSERVABILITY_DB", ex);
        }
    }

    public void storeCurrentModel() throws GraphStoreException {
        try {
            MutableNetwork<Node, String> currentModel = ServiceHolder.getModelManager().getDependencyGraph();
            if (this.lastModel == null) {
                this.lastModel = this.loadLastModel();
            }
            if (this.lastModel == null) {
                if (currentModel.nodes().size() != 0) {
                    this.lastModel = ServiceHolder.getModelStoreManager().persistModel(currentModel);
                }
            } else {
                Set currentNodes = currentModel.nodes();
                Set currentEdges = currentModel.edges();
                Set<Node> lastNodes = this.lastModel.getNodes();
                Set<String> lastEdges = Utils.getEdgesString(this.lastModel.getEdges());
                if (currentEdges.size() == lastEdges.size() && currentNodes.size() == lastNodes.size() && this.isSameNodes(currentNodes, lastNodes) && this.isSameEdges(currentEdges, lastEdges)) {
                    return;
                }
                this.lastModel = ServiceHolder.getModelStoreManager().persistModel(currentModel);
            }
        }
        catch (GraphStoreException e) {
            log.error((Object)"Error occurred while handling the dependency graph persistence. ", (Throwable)e);
            throw e;
        }
    }

    private boolean isSameNodes(Set<Node> currentNodes, Set<Node> lastNodes) {
        boolean isSameModel = true;
        for (Node currentNode : currentNodes) {
            Node lastNode = null;
            for (Node node : lastNodes) {
                if (!node.equals(currentNode)) continue;
                lastNode = node;
                break;
            }
            if (lastNode != null) {
                if (lastNode.getComponents().size() == currentNode.getComponents().size()) {
                    if (!lastNode.getComponents().containsAll(currentNode.getComponents())) {
                        isSameModel = false;
                        break;
                    }
                } else {
                    isSameModel = false;
                    break;
                }
                if (lastNode.getEdges().size() == currentNode.getEdges().size()) {
                    if (lastNode.getEdges().containsAll(currentNode.getEdges())) continue;
                    isSameModel = false;
                    break;
                }
                isSameModel = false;
                break;
            }
            isSameModel = false;
            break;
        }
        return isSameModel;
    }

    private boolean isSameEdges(Set<String> currentEdges, Set<String> lastEdges) {
        return currentEdges.containsAll(lastEdges);
    }
}

