/*
 * Copyright (c) 2019, WSO2 Inc. (http://www.wso2.org) All Rights Reserved.
 *
 * WSO2 Inc. licenses this file to you under the Apache License,
 * Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied. See the License for the
 * specific language governing permissions and limitations
 * under the License.
 *
 */

package io.cellery.security.cell.sts.server.jwks;

import sun.security.tools.keytool.CertAndKeyGen;
import sun.security.x509.X500Name;

import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.X509Certificate;

/**
 * Generates and stores self signed certificates.
 */
public class SelfSignedCertGenerator {

    private PrivateKey privateKey;
    private X509Certificate certificate;
    private PublicKey publicKey;

    public PrivateKey getPrivateKey() {

        return privateKey;
    }

    public X509Certificate getCertificate() {

        return certificate;
    }

    public PublicKey getPublicKey() {

        return publicKey;
    }

    public SelfSignedCertGenerator(String commonName) throws Exception {

        CertAndKeyGen keyGen = new CertAndKeyGen("RSA", "SHA1WithRSA", null);
        keyGen.generate(2048);

        this.privateKey = keyGen.getPrivateKey();
        this.publicKey = keyGen.getPublicKey();
        //Generate self signed certificate
        X509Certificate[] chain = new X509Certificate[1];
        chain[0] = keyGen.getSelfCertificate(new X500Name("CN=" + commonName), (long) 365 * 24 * 3600);
        this.certificate = chain[0];
    }

}
