/*
 * Decompiled with CFR 0.152.
 */
package io.cellery.security.cell.sts.server.authorization;

import io.cellery.security.cell.sts.server.authorization.AuthorizationFailedException;
import io.cellery.security.cell.sts.server.authorization.AuthorizationHandler;
import io.cellery.security.cell.sts.server.authorization.opa.OPAAuthorizationHandler;
import io.cellery.security.cell.sts.server.core.model.CellStsRequest;
import io.cellery.security.cell.sts.server.core.model.config.CellStsConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AuthorizationService {
    private static final Logger log = LoggerFactory.getLogger(AuthorizationService.class);
    AuthorizationHandler authorizationHandler = new OPAAuthorizationHandler();

    public void authorize(CellStsRequest request, String jwt) throws AuthorizationFailedException {
        if (!CellStsConfiguration.getInstance().isAuthorizationEnabled()) {
            log.debug("Authorization is disabled. Hence returning without evaluating policies");
            return;
        }
        log.info("Authorization service is invoked for request: {}", (Object)request.getRequestId());
        this.authorizationHandler.authorize(request, jwt);
    }
}

