/*
 * Decompiled with CFR 0.152.
 */
package io.cellery.security.cell.sts.server.authorization;

import io.cellery.security.cell.sts.server.core.model.CellStsRequest;
import io.cellery.security.cell.sts.server.core.model.RequestContext;
import io.cellery.security.cell.sts.server.core.model.config.CellStsConfiguration;
import io.cellery.security.cell.sts.server.core.service.CelleryCellSTSException;
import org.apache.commons.lang.StringUtils;

public class AuthorizationUtils {
    public static String getOPAEndpoint(CellStsRequest request, boolean toMicrogateway) throws CelleryCellSTSException {
        int opaPort = 8181;
        String opaHost = "localhost";
        String opaPortCofig = System.getenv("STS_OPA_PORT");
        String opaHostConfig = System.getenv("STS_OPA_HOST");
        if (StringUtils.isNotBlank(opaPortCofig)) {
            opaPort = Integer.parseInt(opaPortCofig);
        }
        if (StringUtils.isNotEmpty(opaHostConfig)) {
            opaHost = opaHostConfig;
        }
        String opaPrefix = "data";
        if (!toMicrogateway && StringUtils.isEmpty(opaPrefix = CellStsConfiguration.getInstance().getSTSOPAQueryPrefix())) {
            opaPrefix = "/data/cellery/io";
        }
        String baseQuery = "http://" + opaHost + ":" + opaPort + "/v1/" + opaPrefix;
        if (toMicrogateway) {
            return AuthorizationUtils.getGatewayContextPolicyQuery(baseQuery, request);
        }
        return baseQuery;
    }

    public static String getGatewayContextPolicyQuery(String baseQueryPath, CellStsRequest request) {
        String context = "";
        RequestContext requestContext = request.getRequestContext();
        if (requestContext != null && StringUtils.isNotEmpty(requestContext.getPath())) {
            String[] split = requestContext.getPath().split("/");
            if (split.length > 0 && StringUtils.isNotEmpty(split[0])) {
                context = split[0];
            } else if (split.length > 1 && StringUtils.isNotEmpty(split[1])) {
                context = split[1];
            }
        }
        return baseQueryPath + "/" + context;
    }
}

