/*
 * Decompiled with CFR 0.152.
 */
package io.cellery.security.cell.sts.server.authorization.opa;

import com.nimbusds.jwt.JWT;
import com.nimbusds.jwt.JWTClaimsSet;
import com.nimbusds.jwt.JWTParser;
import io.cellery.security.cell.sts.server.authorization.AuthorizationContext;
import io.cellery.security.cell.sts.server.authorization.AuthorizationFailedException;
import java.text.ParseException;

public class OPAAuthorizationContext
extends AuthorizationContext {
    private JWTClaimsSet jwtContent;

    public OPAAuthorizationContext(String jwt) throws AuthorizationFailedException {
        super(jwt);
        try {
            JWT parsedJWT = JWTParser.parse(jwt);
            this.jwtContent = parsedJWT.getJWTClaimsSet();
        }
        catch (ParseException e) {
            throw new AuthorizationFailedException("Error while parsing JWT", e);
        }
    }

    public JWTClaimsSet getJwtContent() {
        return this.jwtContent;
    }
}

