/*
 * Decompiled with CFR 0.152.
 */
package io.cellery.security.cell.sts.server.authorization.opa;

import com.google.gson.Gson;
import com.mashape.unirest.http.HttpResponse;
import com.mashape.unirest.http.JsonNode;
import com.mashape.unirest.http.Unirest;
import com.mashape.unirest.http.exceptions.UnirestException;
import io.cellery.security.cell.sts.server.authorization.AuthorizationContext;
import io.cellery.security.cell.sts.server.authorization.AuthorizationFailedException;
import io.cellery.security.cell.sts.server.authorization.AuthorizationHandler;
import io.cellery.security.cell.sts.server.authorization.AuthorizationUtils;
import io.cellery.security.cell.sts.server.authorization.AuthorizeRequest;
import io.cellery.security.cell.sts.server.authorization.opa.OPAAuthorizationContext;
import io.cellery.security.cell.sts.server.core.CellStsUtils;
import io.cellery.security.cell.sts.server.core.model.CellStsRequest;
import io.cellery.security.cell.sts.server.core.service.CelleryCellSTSException;
import org.apache.commons.lang.StringUtils;
import org.json.JSONException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OPAAuthorizationHandler
implements AuthorizationHandler {
    private static final Logger log = LoggerFactory.getLogger(OPAAuthorizationHandler.class);

    @Override
    public void authorize(CellStsRequest cellStsRequest, String jwt) throws AuthorizationFailedException {
        AuthorizeRequest authorizeRequest = this.buildAuthorizeRequest(cellStsRequest, jwt);
        log.debug("OPA authorization handler invoked for request id: {}", (Object)authorizeRequest.getRequestId());
        if (StringUtils.isNotEmpty(jwt)) {
            authorizeRequest.setAuthorizationContext(new OPAAuthorizationContext(authorizeRequest.getAuthorizationContext().getJwt()));
        }
        Gson gson = new Gson();
        String requestString = gson.toJson(authorizeRequest);
        requestString = "{ \"input\" :" + requestString + "}";
        HttpResponse<JsonNode> apiResponse = null;
        log.info("Request to OPA server : {}", (Object)requestString);
        try {
            boolean requestToMicroGateway = CellStsUtils.isRequestToMicroGateway(cellStsRequest);
            String query = this.buildEndpoint(AuthorizationUtils.getOPAEndpoint(cellStsRequest, requestToMicroGateway), authorizeRequest.getDestination().getWorkload(), requestToMicroGateway);
            log.info("Querying OPA from {}", (Object)query);
            apiResponse = Unirest.post(query).body(requestString).asJson();
            log.info("Response from OPA server: {}", (Object)apiResponse.getBody().toString());
            try {
                Boolean allow = apiResponse.getBody().getObject().getBoolean("result");
                if (!allow.booleanValue()) {
                    throw new AuthorizationFailedException("Error while authorizing request. Decision found : " + apiResponse.getBody().toString());
                }
            }
            catch (JSONException e) {
                log.debug("Proper policies which returns {\"result\" : boolean} are not defined for query {}", (Object)query);
            }
            log.info("Authorization successfully completed for request: ", (Object)authorizeRequest.getRequestId());
        }
        catch (UnirestException | CelleryCellSTSException e) {
            throw new AuthorizationFailedException("Error while sending authorization request to OPA", e);
        }
    }

    private String buildEndpoint(String endpointAddress, String destinationService, boolean toMicroGateway) {
        if (toMicroGateway) {
            return endpointAddress + "/allow_access";
        }
        if (StringUtils.isEmpty(destinationService)) {
            return endpointAddress;
        }
        String sanitizedService = destinationService.replace("-", "_").split(":")[0].concat("_allow");
        return endpointAddress + "/" + sanitizedService;
    }

    private AuthorizeRequest buildAuthorizeRequest(CellStsRequest request, String jwt) throws AuthorizationFailedException {
        log.info("Building authorize request with jwt: " + jwt);
        AuthorizationContext authorizationContext = new AuthorizationContext(jwt);
        AuthorizeRequest authorizeRequest = new AuthorizeRequest(request, authorizationContext);
        return authorizeRequest;
    }
}

